/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.IntIdentityHashBiMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.RegistryDelegate;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ClearableRegistry<T>
extends MutableRegistry<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker REGISTRY = MarkerManager.getMarker((String)"REGISTRY");
    private final IntIdentityHashBiMap<T> ids = new IntIdentityHashBiMap(256);
    private final BiMap<ResourceLocation, T> map = HashBiMap.create();
    private final Set<ResourceLocation> keys = Collections.unmodifiableSet(this.map.keySet());
    private List<T> values = new ArrayList<T>();
    private Map<ResourceLocation, Set<T>> known = new HashMap<ResourceLocation, Set<T>>();
    private final ResourceLocation name;
    private final boolean isDelegated;
    private int nextId = 0;

    public ClearableRegistry(ResourceLocation name) {
        this(name, null);
    }

    public ClearableRegistry(ResourceLocation name, Class<T> superType) {
        this.name = name;
        this.isDelegated = ForgeRegistryEntry.class.isAssignableFrom(superType);
    }

    @Nullable
    public ResourceLocation func_177774_c(T value) {
        return (ResourceLocation)this.map.inverse().get(value);
    }

    @Nullable
    public int func_148757_b(T value) {
        return this.ids.func_186815_a(value);
    }

    @Nullable
    public T func_148745_a(int id) {
        return (T)this.ids.func_148745_a(id);
    }

    public Iterator<T> iterator() {
        return this.ids.iterator();
    }

    @Nullable
    public T func_82594_a(ResourceLocation key) {
        return (T)this.map.get((Object)key);
    }

    public <V extends T> V func_218382_a(int id, ResourceLocation key, V value) {
        Validate.isTrue((id >= 0 ? 1 : 0) != 0, (String)"Invalid ID, can not be < 0", (Object[])new Object[0]);
        Validate.notNull((Object)key);
        Validate.notNull(value);
        Object old = this.map.get((Object)key);
        if (old != null) {
            LOGGER.debug(REGISTRY, "{}: Adding duplicate key '{}' to registry. Old: {} New: {}", (Object)this.name, (Object)key, old, value);
            this.values.remove(old);
            if (this.isDelegated) {
                Set others = this.known.computeIfAbsent(key, k -> new HashSet());
                others.add(old);
                others.forEach(e -> this.getDelegate(e).changeReference(value));
            }
        }
        this.map.put((Object)key, value);
        this.ids.func_186814_a(value, id);
        this.values.add(value);
        if (this.nextId <= id) {
            this.nextId = id + 1;
        }
        if (this.isDelegated) {
            this.getDelegate(value).setName(key);
        }
        return value;
    }

    private RegistryDelegate<T> getDelegate(T thing) {
        if (this.isDelegated) {
            return (RegistryDelegate)((ForgeRegistryEntry)thing).delegate;
        }
        throw new IllegalStateException("Tried to get existing delegate from registry that is not delegated.");
    }

    public <V extends T> V func_218381_a(ResourceLocation key, V value) {
        return this.func_218382_a(this.nextId, key, value);
    }

    public Set<ResourceLocation> func_148742_b() {
        return this.keys;
    }

    public boolean func_195866_d() {
        return this.map.isEmpty();
    }

    @Nullable
    public T func_186801_a(Random random) {
        return this.values.isEmpty() ? null : (T)this.values.get(random.nextInt(this.values.size()));
    }

    public boolean func_212607_c(ResourceLocation key) {
        return this.map.containsKey((Object)key);
    }

    public void clear() {
        LOGGER.debug(REGISTRY, "{}: Clearing registry", (Object)this.name);
        if (this.isDelegated) {
            this.known.values().forEach(s -> {
                s.forEach(e -> this.getDelegate(e).changeReference(e));
                s.clear();
            });
            this.known.clear();
        }
        this.map.clear();
        this.values.clear();
        this.ids.func_186812_a();
        this.nextId = 0;
    }

    public int getNextId() {
        return this.nextId;
    }

    public Optional<T> func_218349_b(ResourceLocation key) {
        return Optional.ofNullable(this.map.get((Object)key));
    }
}

