/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.toposort;

import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.toposort.ModSortingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class TopologicalSort {
    public static <T> List<T> topologicalSort(DirectedGraph<T> graph) {
        DirectedGraph<T> rGraph = TopologicalSort.reverse(graph);
        ArrayList sortedResult = new ArrayList();
        HashSet visitedNodes = new HashSet();
        HashSet expandedNodes = new HashSet();
        for (T node : rGraph) {
            TopologicalSort.explore(node, rGraph, sortedResult, visitedNodes, expandedNodes);
        }
        return sortedResult;
    }

    public static <T> DirectedGraph<T> reverse(DirectedGraph<T> graph) {
        DirectedGraph<T> result = new DirectedGraph<T>();
        for (T node : graph) {
            result.addNode(node);
        }
        for (T from : graph) {
            for (T to2 : graph.edgesFrom(from)) {
                result.addEdge(to2, from);
            }
        }
        return result;
    }

    public static <T> void explore(T node, DirectedGraph<T> graph, List<T> sortedResult, Set<T> visitedNodes, Set<T> expandedNodes) {
        if (visitedNodes.contains(node)) {
            if (expandedNodes.contains(node)) {
                return;
            }
            FMLLog.severe("Mod Sorting failed.", new Object[0]);
            FMLLog.severe("Visting node %s", node);
            FMLLog.severe("Current sorted list : %s", sortedResult);
            FMLLog.severe("Visited set for this node : %s", visitedNodes);
            FMLLog.severe("Explored node set : %s", expandedNodes);
            Sets.SetView cycleList = Sets.difference(visitedNodes, expandedNodes);
            FMLLog.severe("Likely cycle is in : %s", cycleList);
            throw new ModSortingException("There was a cycle detected in the input graph, sorting is not possible", node, cycleList);
        }
        visitedNodes.add(node);
        for (T inbound : graph.edgesFrom(node)) {
            TopologicalSort.explore(inbound, graph, sortedResult, visitedNodes, expandedNodes);
        }
        sortedResult.add(node);
        expandedNodes.add(node);
    }

    public static class DirectedGraph<T>
    implements Iterable<T> {
        private final Map<T, SortedSet<T>> graph = new HashMap<T, SortedSet<T>>();
        private List<T> orderedNodes = new ArrayList<T>();

        public boolean addNode(T node) {
            if (this.graph.containsKey(node)) {
                return false;
            }
            this.orderedNodes.add(node);
            this.graph.put(node, new TreeSet(new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    return DirectedGraph.this.orderedNodes.indexOf(o1) - DirectedGraph.this.orderedNodes.indexOf(o2);
                }
            }));
            return true;
        }

        public void addEdge(T from, T to2) {
            if (!this.graph.containsKey(from) || !this.graph.containsKey(to2)) {
                throw new NoSuchElementException("Missing nodes from graph");
            }
            this.graph.get(from).add(to2);
        }

        public void removeEdge(T from, T to2) {
            if (!this.graph.containsKey(from) || !this.graph.containsKey(to2)) {
                throw new NoSuchElementException("Missing nodes from graph");
            }
            this.graph.get(from).remove(to2);
        }

        public boolean edgeExists(T from, T to2) {
            if (!this.graph.containsKey(from) || !this.graph.containsKey(to2)) {
                throw new NoSuchElementException("Missing nodes from graph");
            }
            return this.graph.get(from).contains(to2);
        }

        public Set<T> edgesFrom(T from) {
            if (!this.graph.containsKey(from)) {
                throw new NoSuchElementException("Missing node from graph");
            }
            return Collections.unmodifiableSortedSet(this.graph.get(from));
        }

        @Override
        public Iterator<T> iterator() {
            return this.orderedNodes.iterator();
        }

        public int size() {
            return this.graph.size();
        }

        public boolean isEmpty() {
            return this.graph.isEmpty();
        }

        public String toString() {
            return this.graph.toString();
        }
    }
}

