/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.client;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import cpw.mods.fml.client.CustomModLoadingErrorDisplayException;
import cpw.mods.fml.client.GuiCustomModLoadingErrorScreen;
import cpw.mods.fml.client.GuiDupesFound;
import cpw.mods.fml.client.GuiIdMismatchScreen;
import cpw.mods.fml.client.GuiModsMissing;
import cpw.mods.fml.client.GuiModsMissingForServer;
import cpw.mods.fml.client.GuiSortingProblem;
import cpw.mods.fml.client.GuiWrongMinecraft;
import cpw.mods.fml.client.modloader.ModLoaderClientHelper;
import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.DuplicateModsFoundException;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IFMLSidedHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.MissingModsException;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.WrongMinecraftVersionException;
import cpw.mods.fml.common.network.EntitySpawnAdjustmentPacket;
import cpw.mods.fml.common.network.EntitySpawnPacket;
import cpw.mods.fml.common.network.ModMissingPacket;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.common.registry.IThrowableEntity;
import cpw.mods.fml.common.registry.ItemData;
import cpw.mods.fml.common.toposort.ModSortingException;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;

public class FMLClientHandler
implements IFMLSidedHandler {
    private static final FMLClientHandler INSTANCE = new FMLClientHandler();
    private ats client;
    private DummyModContainer optifineContainer;
    private boolean guiLoaded;
    private boolean serverIsRunning;
    private MissingModsException modsMissing;
    private ModSortingException modSorting;
    private boolean loading;
    private WrongMinecraftVersionException wrongMC;
    private CustomModLoadingErrorDisplayException customError;
    private DuplicateModsFoundException dupesFound;
    private boolean serverShouldBeKilledQuietly;
    private List<bjo> resourcePackList;
    private bjj resourceManager;
    private Map<String, bjo> resourcePackMap;

    public void beginMinecraftLoading(ats minecraft, List resourcePackList, bjj resourceManager) {
        this.client = minecraft;
        this.resourcePackList = resourcePackList;
        this.resourceManager = resourceManager;
        this.resourcePackMap = Maps.newHashMap();
        if (minecraft.p()) {
            FMLLog.severe("DEMO MODE DETECTED, FML will not work. Finishing now.", new Object[0]);
            this.haltGame("FML will not run in demo mode", new RuntimeException());
            return;
        }
        this.loading = true;
        FMLCommonHandler.instance().beginLoading(this);
        new ModLoaderClientHelper(this.client);
        try {
            Class<?> optifineConfig = Class.forName("Config", false, Loader.instance().getModClassLoader());
            String optifineVersion = (String)optifineConfig.getField("VERSION").get(null);
            ImmutableMap dummyOptifineMeta = ImmutableMap.builder().put((Object)"name", (Object)"Optifine").put((Object)"version", (Object)optifineVersion).build();
            ModMetadata optifineMetadata = MetadataCollection.from(this.getClass().getResourceAsStream("optifinemod.info"), "optifine").getMetadataForId("optifine", (Map<String, Object>)dummyOptifineMeta);
            this.optifineContainer = new DummyModContainer(optifineMetadata);
            FMLLog.info("Forge Mod Loader has detected optifine %s, enabling compatibility features", this.optifineContainer.getVersion());
        }
        catch (Exception e) {
            this.optifineContainer = null;
        }
        try {
            Loader.instance().loadMods();
        }
        catch (WrongMinecraftVersionException wrong) {
            this.wrongMC = wrong;
        }
        catch (DuplicateModsFoundException dupes) {
            this.dupesFound = dupes;
        }
        catch (MissingModsException missing) {
            this.modsMissing = missing;
        }
        catch (ModSortingException sorting) {
            this.modSorting = sorting;
        }
        catch (CustomModLoadingErrorDisplayException custom) {
            FMLLog.log(Level.SEVERE, custom, "A custom exception was thrown by a mod, the game will now halt", new Object[0]);
            this.customError = custom;
        }
        catch (LoaderException le) {
            this.haltGame("There was a severe problem during mod loading that has caused the game to fail", le);
            return;
        }
    }

    @Override
    public void haltGame(String message, Throwable t2) {
        this.client.c(new b(message, t2));
        throw Throwables.propagate((Throwable)t2);
    }

    public void finishMinecraftLoading() {
        if (this.modsMissing != null || this.wrongMC != null || this.customError != null || this.dupesFound != null || this.modSorting != null) {
            return;
        }
        try {
            Loader.instance().initializeMods();
        }
        catch (CustomModLoadingErrorDisplayException custom) {
            FMLLog.log(Level.SEVERE, custom, "A custom exception was thrown by a mod, the game will now halt", new Object[0]);
            this.customError = custom;
            return;
        }
        catch (LoaderException le) {
            this.haltGame("There was a severe problem during mod loading that has caused the game to fail", le);
            return;
        }
        this.client.a();
        RenderingRegistry.instance().loadEntityRenderers(bgi.a.q);
        this.loading = false;
        KeyBindingRegistry.instance().uploadKeyBindingsToGame(this.client.u);
    }

    public void onInitializationComplete() {
        if (this.wrongMC != null) {
            this.client.a((awb)new GuiWrongMinecraft(this.wrongMC));
        } else if (this.modsMissing != null) {
            this.client.a((awb)new GuiModsMissing(this.modsMissing));
        } else if (this.dupesFound != null) {
            this.client.a((awb)new GuiDupesFound(this.dupesFound));
        } else if (this.modSorting != null) {
            this.client.a((awb)new GuiSortingProblem(this.modSorting));
        } else if (this.customError != null) {
            this.client.a((awb)new GuiCustomModLoadingErrorScreen(this.customError));
        }
    }

    public ats getClient() {
        return this.client;
    }

    public Logger getMinecraftLogger() {
        return null;
    }

    public static FMLClientHandler instance() {
        return INSTANCE;
    }

    public void displayGuiScreen(ue player, awb gui) {
        if (this.client.h == player && gui != null) {
            this.client.a(gui);
        }
    }

    public void addSpecialModEntries(ArrayList<ModContainer> mods) {
        if (this.optifineContainer != null) {
            mods.add(this.optifineContainer);
        }
    }

    @Override
    public List<String> getAdditionalBrandingInformation() {
        if (this.optifineContainer != null) {
            return Arrays.asList(String.format("Optifine %s", this.optifineContainer.getVersion()));
        }
        return ImmutableList.of();
    }

    @Override
    public Side getSide() {
        return Side.CLIENT;
    }

    public boolean hasOptifine() {
        return this.optifineContainer != null;
    }

    @Override
    public void showGuiScreen(Object clientGuiElement) {
        awb gui = (awb)clientGuiElement;
        this.client.a(gui);
    }

    @Override
    public nm spawnEntityIntoClientWorld(EntityRegistry.EntityRegistration er, EntitySpawnPacket packet) {
        bda wc = this.client.f;
        Class<? extends nm> cls = er.getEntityClass();
        try {
            nm entity;
            if (er.hasCustomSpawning()) {
                entity = er.doCustomSpawning(packet);
            } else {
                nm[] parts;
                entity = cls.getConstructor(abv.class).newInstance(wc);
                int offset = packet.entityId - entity.k;
                entity.k = packet.entityId;
                entity.b(packet.scaledX, packet.scaledY, packet.scaledZ, packet.scaledYaw, packet.scaledPitch);
                if (entity instanceof of) {
                    ((of)entity).aP = packet.scaledHeadYaw;
                }
                if ((parts = entity.an()) != null) {
                    for (int j = 0; j < parts.length; ++j) {
                        parts[j].k += offset;
                    }
                }
            }
            entity.bY = packet.rawX;
            entity.bZ = packet.rawY;
            entity.ca = packet.rawZ;
            if (entity instanceof IThrowableEntity) {
                bdf thrower = this.client.h.k == packet.throwerId ? this.client.h : wc.a(packet.throwerId);
                ((IThrowableEntity)entity).setThrower((nm)thrower);
            }
            if (packet.metadata != null) {
                entity.u().a(packet.metadata);
            }
            if (packet.throwerId > 0) {
                entity.h(packet.speedScaledX, packet.speedScaledY, packet.speedScaledZ);
            }
            if (entity instanceof IEntityAdditionalSpawnData) {
                ((IEntityAdditionalSpawnData)entity).readSpawnData(packet.dataStream);
            }
            wc.a(packet.entityId, entity);
            return entity;
        }
        catch (Exception e) {
            FMLLog.log(Level.SEVERE, e, "A severe problem occurred during the spawning of an entity", new Object[0]);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void adjustEntityLocationOnClient(EntitySpawnAdjustmentPacket packet) {
        nm ent = this.client.f.a(packet.entityId);
        if (ent != null) {
            ent.bY = packet.serverX;
            ent.bZ = packet.serverY;
            ent.ca = packet.serverZ;
        } else {
            FMLLog.fine("Attempted to adjust the position of entity %d which is not present on the client", packet.entityId);
        }
    }

    @Override
    public void beginServerLoading(MinecraftServer server) {
        this.serverShouldBeKilledQuietly = false;
    }

    @Override
    public void finishServerLoading() {
    }

    @Override
    public MinecraftServer getServer() {
        return this.client.C();
    }

    @Override
    public void sendPacket(ex packet) {
        if (this.client.h != null) {
            this.client.h.a.c(packet);
        }
    }

    @Override
    public void displayMissingMods(ModMissingPacket modMissingPacket) {
        this.client.a((awb)new GuiModsMissingForServer(modMissingPacket));
    }

    public boolean isLoading() {
        return this.loading;
    }

    @Override
    public void handleTinyPacket(ey handler, dq mapData) {
        ((bct)handler).fmlPacket131Callback(mapData);
    }

    @Override
    public void setClientCompatibilityLevel(byte compatibilityLevel) {
        bct.setConnectionCompatibilityLevel((byte)compatibilityLevel);
    }

    @Override
    public byte getClientCompatibilityLevel() {
        return bct.getConnectionCompatibilityLevel();
    }

    public void warnIDMismatch(MapDifference<Integer, ItemData> idDifferences, boolean mayContinue) {
        GuiIdMismatchScreen mismatch = new GuiIdMismatchScreen(idDifferences, mayContinue);
        this.client.a((awb)mismatch);
    }

    public void callbackIdDifferenceResponse(boolean response) {
        if (response) {
            this.serverShouldBeKilledQuietly = false;
            GameData.releaseGate(true);
            this.client.continueWorldLoading();
        } else {
            this.serverShouldBeKilledQuietly = true;
            GameData.releaseGate(false);
            this.client.a((bda)null);
            this.client.a(null);
        }
    }

    @Override
    public boolean shouldServerShouldBeKilledQuietly() {
        return this.serverShouldBeKilledQuietly;
    }

    @Override
    public void disconnectIDMismatch(MapDifference<Integer, ItemData> s, ey toKill, cl mgr) {
        boolean criticalMismatch = !s.entriesOnlyOnLeft().isEmpty();
        for (Map.Entry mismatch : s.entriesDiffering().entrySet()) {
            MapDifference.ValueDifference vd = (MapDifference.ValueDifference)mismatch.getValue();
            if (((ItemData)vd.leftValue()).mayDifferByOrdinal((ItemData)vd.rightValue())) continue;
            criticalMismatch = true;
        }
        if (!criticalMismatch) {
            return;
        }
        ((bct)toKill).f();
        bcv.forceTermination((bcv)((bcv)this.client.n));
        mgr.b();
        this.client.a((bda)null);
        this.warnIDMismatch(s, false);
    }

    public boolean isGUIOpen(Class<? extends awb> gui) {
        return this.client.n != null && this.client.n.getClass().equals(gui);
    }

    @Override
    public void addModAsResource(ModContainer container) {
        Class<?> resourcePackType = container.getCustomResourcePackClass();
        if (resourcePackType != null) {
            try {
                bjo pack = (bjo)resourcePackType.getConstructor(ModContainer.class).newInstance(container);
                this.resourcePackList.add(pack);
                this.resourcePackMap.put(container.getModId(), pack);
            }
            catch (NoSuchMethodException e) {
                FMLLog.log(Level.SEVERE, "The container %s (type %s) returned an invalid class for it's resource pack.", container.getName(), container.getClass().getName());
                return;
            }
            catch (Exception e) {
                FMLLog.log(Level.SEVERE, e, "An unexpected exception occurred constructing the custom resource pack for %s", container.getName());
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    @Override
    public void updateResourcePackList() {
        this.client.a();
    }

    public bjo getResourcePackFor(String modId) {
        return this.resourcePackMap.get(modId);
    }
}

