/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.network.packet;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.network.ForgePacket;

public class DimensionRegisterPacket
extends ForgePacket {
    public int dimensionId;
    public int providerId;

    public DimensionRegisterPacket() {
    }

    public DimensionRegisterPacket(int dimensionId, int providerId) {
        this.dimensionId = dimensionId;
        this.providerId = providerId;
    }

    @Override
    public byte[] generatePacket() {
        ByteArrayDataOutput dat = ByteStreams.newDataOutput();
        dat.writeInt(this.dimensionId);
        dat.writeInt(this.providerId);
        return dat.toByteArray();
    }

    @Override
    public ForgePacket consumePacket(byte[] data) {
        ByteArrayDataInput dat = ByteStreams.newDataInput((byte[])data);
        this.dimensionId = dat.readInt();
        this.providerId = dat.readInt();
        return this;
    }

    @Override
    public void execute(cl network, ue player) {
        if (!(player instanceof ju) && !DimensionManager.isDimensionRegistered(this.dimensionId)) {
            DimensionManager.registerDimension(this.dimensionId, this.providerId);
        }
    }
}

