/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.launcher;

import com.google.common.base.Throwables;
import com.google.common.collect.ObjectArrays;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class FMLTweaker
implements ITweaker {
    private List<String> args;
    private File gameDir;
    private File assetsDir;
    private String profile;
    private static URI jarLocation;

    public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
        this.gameDir = gameDir == null ? new File(".") : gameDir;
        this.assetsDir = assetsDir;
        this.profile = profile;
        this.args = args;
        try {
            jarLocation = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            Logger.getLogger("FMLTWEAK").log(Level.SEVERE, "Missing URI information for FML tweak");
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
        classLoader.addTransformerExclusion("cpw.mods.fml.repackage.");
        classLoader.addTransformerExclusion("cpw.mods.fml.relauncher.");
        classLoader.addTransformerExclusion("cpw.mods.fml.common.asm.transformers.");
        classLoader.addClassLoaderExclusion("LZMA.");
        FMLLaunchHandler.configureForClientLaunch(classLoader, this);
        FMLLaunchHandler.appendCoreMods();
    }

    public String getLaunchTarget() {
        return "net.minecraft.client.main.Main";
    }

    public String[] getLaunchArguments() {
        List blackboardArgs = (List)Launch.blackboard.get("ArgumentList");
        Object[] launchArgsArray = this.args.toArray(new String[this.args.size()]);
        if (this.gameDir != null && !blackboardArgs.contains("--gameDir")) {
            launchArgsArray = (String[])ObjectArrays.concat((Object)this.gameDir.getAbsolutePath(), (Object[])launchArgsArray);
            launchArgsArray = (String[])ObjectArrays.concat((Object)"--gameDir", (Object[])launchArgsArray);
        }
        if (this.assetsDir != null && !blackboardArgs.contains("--assetsDir")) {
            launchArgsArray = (String[])ObjectArrays.concat((Object)this.assetsDir.getAbsolutePath(), (Object[])launchArgsArray);
            launchArgsArray = (String[])ObjectArrays.concat((Object)"--assetsDir", (Object[])launchArgsArray);
        }
        if (!blackboardArgs.contains("--version")) {
            launchArgsArray = (String[])ObjectArrays.concat((Object)(this.profile != null ? this.profile : "UnknownFMLProfile"), (Object[])launchArgsArray);
            launchArgsArray = (String[])ObjectArrays.concat((Object)"--version", (Object[])launchArgsArray);
        }
        return launchArgsArray;
    }

    public File getGameDir() {
        return this.gameDir;
    }

    public static URI getJarLocation() {
        return jarLocation;
    }

    public void injectCascadingTweak(String tweakClassName) {
        List tweakClasses = (List)Launch.blackboard.get("TweakClasses");
        tweakClasses.add(tweakClassName);
    }
}

