/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraftforge.event.terraingen.DeferredBiomeDecorator;

public class BiomeDictionary {
    private static final int BIOME_LIST_SIZE = 256;
    private static BiomeInfo[] biomeList = new BiomeInfo[256];
    private static ArrayList<acq>[] typeInfoList = new ArrayList[Type.values().length];

    public static boolean registerBiomeType(acq biome, Type ... types) {
        if (acq.a[biome.N] != null) {
            for (Type type : types) {
                if (typeInfoList[type.ordinal()] == null) {
                    BiomeDictionary.typeInfoList[type.ordinal()] = new ArrayList();
                }
                typeInfoList[type.ordinal()].add(biome);
            }
            if (biomeList[biome.N] == null) {
                BiomeDictionary.biomeList[biome.N] = new BiomeInfo(types);
            } else {
                for (Type type : types) {
                    BiomeDictionary.biomeList[biome.N].typeList.add(type);
                }
            }
            return true;
        }
        return false;
    }

    public static acq[] getBiomesForType(Type type) {
        if (typeInfoList[type.ordinal()] != null) {
            return typeInfoList[type.ordinal()].toArray(new acq[0]);
        }
        return new acq[0];
    }

    public static Type[] getTypesForBiome(acq biome) {
        BiomeDictionary.checkRegistration(biome);
        if (biomeList[biome.N] != null) {
            return BiomeDictionary.biomeList[biome.N].typeList.toArray(new Type[0]);
        }
        return new Type[0];
    }

    public static boolean areBiomesEquivalent(acq biomeA, acq biomeB) {
        int a2 = biomeA.N;
        int b2 = biomeB.N;
        BiomeDictionary.checkRegistration(biomeA);
        BiomeDictionary.checkRegistration(biomeB);
        if (biomeList[a2] != null && biomeList[b2] != null) {
            for (Type type : BiomeDictionary.biomeList[a2].typeList) {
                if (!BiomeDictionary.containsType(biomeList[b2], type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBiomeOfType(acq biome, Type type) {
        BiomeDictionary.checkRegistration(biome);
        if (biomeList[biome.N] != null) {
            return BiomeDictionary.containsType(biomeList[biome.N], type);
        }
        return false;
    }

    public static boolean isBiomeRegistered(acq biome) {
        return biomeList[biome.N] != null;
    }

    public static boolean isBiomeRegistered(int biomeID) {
        return biomeList[biomeID] != null;
    }

    public static void registerAllBiomes() {
        FMLLog.warning("Redundant call to BiomeDictionary.registerAllBiomes ignored", new Object[0]);
    }

    public static void registerAllBiomesAndGenerateEvents() {
        for (int i = 0; i < 256; ++i) {
            acq biome = acq.a[i];
            if (biome.I instanceof DeferredBiomeDecorator) {
                DeferredBiomeDecorator decorator = (DeferredBiomeDecorator)biome.I;
                decorator.fireCreateEventAndReplace();
            }
            if (biome == null) continue;
            BiomeDictionary.checkRegistration(biome);
        }
    }

    public static void makeBestGuess(acq biome) {
        if (biome.I.z >= 3) {
            if (biome.e() && biome.F >= 1.0f) {
                BiomeDictionary.registerBiomeType(biome, Type.JUNGLE);
            } else if (!biome.e()) {
                BiomeDictionary.registerBiomeType(biome, Type.FOREST);
            }
        } else if (biome.E <= 0.3f && biome.E >= 0.0f && (!biome.e() || biome.D >= 0.0f)) {
            BiomeDictionary.registerBiomeType(biome, Type.PLAINS);
        }
        if (biome.e() && biome.D < 0.0f && biome.E <= 0.3f && biome.E >= 0.0f) {
            BiomeDictionary.registerBiomeType(biome, Type.SWAMP);
        }
        if (biome.D <= -0.5f) {
            BiomeDictionary.registerBiomeType(biome, Type.WATER);
        }
        if (biome.E >= 1.5f) {
            BiomeDictionary.registerBiomeType(biome, Type.MOUNTAIN);
        }
        if (biome.c() || biome.F < 0.2f) {
            BiomeDictionary.registerBiomeType(biome, Type.FROZEN);
        }
        if (!biome.e() && biome.F >= 1.0f) {
            BiomeDictionary.registerBiomeType(biome, Type.DESERT);
        }
    }

    private static void checkRegistration(acq biome) {
        if (!BiomeDictionary.isBiomeRegistered(biome)) {
            BiomeDictionary.makeBestGuess(biome);
        }
    }

    private static boolean containsType(BiomeInfo info, Type type) {
        return info.typeList.contains((Object)type);
    }

    private static void registerVanillaBiomes() {
        BiomeDictionary.registerBiomeType(acq.b, Type.WATER);
        BiomeDictionary.registerBiomeType(acq.c, Type.PLAINS);
        BiomeDictionary.registerBiomeType(acq.d, Type.DESERT);
        BiomeDictionary.registerBiomeType(acq.e, Type.MOUNTAIN);
        BiomeDictionary.registerBiomeType(acq.f, Type.FOREST);
        BiomeDictionary.registerBiomeType(acq.g, Type.FOREST, Type.FROZEN);
        BiomeDictionary.registerBiomeType(acq.u, Type.FOREST, Type.FROZEN);
        BiomeDictionary.registerBiomeType(acq.h, Type.SWAMP);
        BiomeDictionary.registerBiomeType(acq.i, Type.WATER);
        BiomeDictionary.registerBiomeType(acq.l, Type.WATER, Type.FROZEN);
        BiomeDictionary.registerBiomeType(acq.m, Type.WATER, Type.FROZEN);
        BiomeDictionary.registerBiomeType(acq.n, Type.FROZEN);
        BiomeDictionary.registerBiomeType(acq.o, Type.FROZEN);
        BiomeDictionary.registerBiomeType(acq.r, Type.BEACH);
        BiomeDictionary.registerBiomeType(acq.s, Type.DESERT);
        BiomeDictionary.registerBiomeType(acq.w, Type.JUNGLE);
        BiomeDictionary.registerBiomeType(acq.x, Type.JUNGLE);
        BiomeDictionary.registerBiomeType(acq.t, Type.FOREST);
        BiomeDictionary.registerBiomeType(acq.k, Type.END);
        BiomeDictionary.registerBiomeType(acq.j, Type.NETHER);
        BiomeDictionary.registerBiomeType(acq.p, Type.MUSHROOM);
        BiomeDictionary.registerBiomeType(acq.v, Type.MOUNTAIN);
        BiomeDictionary.registerBiomeType(acq.q, Type.MUSHROOM, Type.BEACH);
    }

    static {
        BiomeDictionary.registerVanillaBiomes();
    }

    private static class BiomeInfo {
        public EnumSet<Type> typeList = EnumSet.noneOf(Type.class);

        public BiomeInfo(Type[] types) {
            for (Type t2 : types) {
                this.typeList.add(t2);
            }
        }
    }

    public static enum Type {
        FOREST,
        PLAINS,
        MOUNTAIN,
        HILLS,
        SWAMP,
        WATER,
        DESERT,
        FROZEN,
        JUNGLE,
        WASTELAND,
        BEACH,
        NETHER,
        END,
        MUSHROOM,
        MAGICAL;

    }
}

