/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public abstract class FluidRegistry {
    static int maxID = 0;
    static HashMap<String, Fluid> fluids = new HashMap();
    static BiMap<String, Integer> fluidIDs = HashBiMap.create();
    static BiMap<aqz, Fluid> fluidBlocks;
    public static final Fluid WATER;
    public static final Fluid LAVA;
    public static int renderIdFluid;

    private FluidRegistry() {
    }

    static void initFluidIDs(BiMap<String, Integer> newfluidIDs) {
        maxID = newfluidIDs.size();
        fluidIDs.clear();
        fluidIDs.putAll(newfluidIDs);
    }

    public static boolean registerFluid(Fluid fluid) {
        if (fluidIDs.containsKey((Object)fluid.getName())) {
            return false;
        }
        fluids.put(fluid.getName(), fluid);
        fluidIDs.put((Object)fluid.getName(), (Object)(++maxID));
        MinecraftForge.EVENT_BUS.post(new FluidRegisterEvent(fluid.getName(), maxID));
        return true;
    }

    public static boolean isFluidRegistered(Fluid fluid) {
        return fluidIDs.containsKey((Object)fluid.getName());
    }

    public static boolean isFluidRegistered(String fluidName) {
        return fluidIDs.containsKey((Object)fluidName);
    }

    public static Fluid getFluid(String fluidName) {
        return fluids.get(fluidName);
    }

    public static Fluid getFluid(int fluidID) {
        return fluids.get(FluidRegistry.getFluidName(fluidID));
    }

    public static String getFluidName(int fluidID) {
        return (String)fluidIDs.inverse().get((Object)fluidID);
    }

    public static String getFluidName(FluidStack stack) {
        return FluidRegistry.getFluidName(stack.fluidID);
    }

    public static int getFluidID(String fluidName) {
        return (Integer)fluidIDs.get((Object)fluidName);
    }

    public static FluidStack getFluidStack(String fluidName, int amount) {
        if (!fluidIDs.containsKey((Object)fluidName)) {
            return null;
        }
        return new FluidStack(FluidRegistry.getFluidID(fluidName), amount);
    }

    public static Map<String, Fluid> getRegisteredFluids() {
        return ImmutableMap.copyOf(fluids);
    }

    public static Map<String, Integer> getRegisteredFluidIDs() {
        return ImmutableMap.copyOf(fluidIDs);
    }

    public static Fluid lookupFluidForBlock(aqz block) {
        if (fluidBlocks == null) {
            fluidBlocks = HashBiMap.create();
            for (Fluid fluid : fluids.values()) {
                if (!fluid.canBePlacedInWorld() || aqz.s[fluid.getBlockID()] == null) continue;
                fluidBlocks.put((Object)aqz.s[fluid.getBlockID()], (Object)fluid);
            }
        }
        return (Fluid)fluidBlocks.get((Object)block);
    }

    static {
        WATER = new Fluid("water").setBlockID(aqz.G.cF).setUnlocalizedName(aqz.G.a());
        LAVA = new Fluid("lava").setBlockID(aqz.I.cF).setLuminosity(15).setDensity(3000).setViscosity(6000).setTemperature(1300).setUnlocalizedName(aqz.I.a());
        renderIdFluid = -1;
        FluidRegistry.registerFluid(WATER);
        FluidRegistry.registerFluid(LAVA);
    }

    public static class FluidRegisterEvent
    extends Event {
        public final String fluidName;
        public final int fluidID;

        public FluidRegisterEvent(String fluidName, int fluidID) {
            this.fluidName = fluidName;
            this.fluidID = fluidID;
        }
    }
}

