/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class OreDictionary {
    private static boolean hasInit = false;
    private static int maxID = 0;
    private static HashMap<String, Integer> oreIDs = new HashMap();
    private static HashMap<Integer, ArrayList<ye>> oreStacks = new HashMap();
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;

    public static void initVanillaEntries() {
        if (!hasInit) {
            OreDictionary.registerOre("logWood", new ye(aqz.O, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("plankWood", new ye(aqz.C, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("slabWood", new ye((aqz)aqz.bT, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("stairWood", aqz.ay);
            OreDictionary.registerOre("stairWood", aqz.cc);
            OreDictionary.registerOre("stairWood", aqz.cd);
            OreDictionary.registerOre("stairWood", aqz.cb);
            OreDictionary.registerOre("stickWood", yc.F);
            OreDictionary.registerOre("treeSapling", new ye(aqz.D, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new ye((aqz)aqz.P, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("oreGold", aqz.L);
            OreDictionary.registerOre("oreIron", aqz.M);
            OreDictionary.registerOre("oreLapis", aqz.S);
            OreDictionary.registerOre("oreDiamond", aqz.aB);
            OreDictionary.registerOre("oreRedstone", aqz.aS);
            OreDictionary.registerOre("oreEmerald", aqz.bW);
            OreDictionary.registerOre("oreQuartz", aqz.cu);
            OreDictionary.registerOre("stone", aqz.y);
            OreDictionary.registerOre("cobblestone", aqz.B);
        }
        HashMap<ye, String> replacements = new HashMap<ye, String>();
        replacements.put(new ye(aqz.C, 1, Short.MAX_VALUE), "plankWood");
        replacements.put(new ye(yc.F), "stickWood");
        replacements.put(new ye(aqz.y), "stone");
        replacements.put(new ye(aqz.B), "cobblestone");
        String[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
        for (int i = 0; i < 16; ++i) {
            ye dye = new ye(yc.aY, 1, i);
            if (!hasInit) {
                OreDictionary.registerOre(dyes[i], dye);
            }
            replacements.put(dye, dyes[i]);
        }
        hasInit = true;
        ye[] replaceStacks = replacements.keySet().toArray(new ye[replacements.keySet().size()]);
        ye[] exclusions = new ye[]{new ye(aqz.T), new ye(yc.be), new ye(aqz.br), new ye((aqz)aqz.ap), new ye(aqz.aM), new ye(aqz.cg)};
        List recipes = aaf.a().b();
        ArrayList<Object> recipesToRemove = new ArrayList<Object>();
        ArrayList<Object> recipesToAdd = new ArrayList<Object>();
        for (Object obj : recipes) {
            ye output;
            aai recipe;
            if (obj instanceof aai) {
                recipe = (aai)obj;
                output = recipe.b();
                if (output != null && OreDictionary.containsMatch(false, exclusions, output) || !OreDictionary.containsMatch(true, recipe.d, replaceStacks)) continue;
                recipesToRemove.add(recipe);
                recipesToAdd.add(new ShapedOreRecipe(recipe, replacements));
                continue;
            }
            if (!(obj instanceof aaj) || (output = (recipe = (aaj)obj).b()) != null && OreDictionary.containsMatch(false, exclusions, output) || !OreDictionary.containsMatch(true, recipe.b.toArray(new ye[recipe.b.size()]), replaceStacks)) continue;
            recipesToRemove.add((aah)obj);
            ShapelessOreRecipe newRecipe = new ShapelessOreRecipe((aaj)recipe, replacements);
            recipesToAdd.add(newRecipe);
        }
        recipes.removeAll(recipesToRemove);
        recipes.addAll(recipesToAdd);
        if (recipesToRemove.size() > 0) {
            System.out.println("Replaced " + recipesToRemove.size() + " ore recipies");
        }
    }

    public static int getOreID(String name) {
        Integer val = oreIDs.get(name);
        if (val == null) {
            val = maxID++;
            oreIDs.put(name, val);
            oreStacks.put(val, new ArrayList());
        }
        return val;
    }

    public static String getOreName(int id) {
        for (Map.Entry<String, Integer> entry : oreIDs.entrySet()) {
            if (id != entry.getValue()) continue;
            return entry.getKey();
        }
        return "Unknown";
    }

    public static int getOreID(ye itemStack) {
        if (itemStack == null) {
            return -1;
        }
        for (Map.Entry<Integer, ArrayList<ye>> ore : oreStacks.entrySet()) {
            for (ye target : ore.getValue()) {
                if (itemStack.d != target.d || target.k() != Short.MAX_VALUE && itemStack.k() != target.k()) continue;
                return ore.getKey();
            }
        }
        return -1;
    }

    public static ArrayList<ye> getOres(String name) {
        return OreDictionary.getOres(OreDictionary.getOreID(name));
    }

    public static String[] getOreNames() {
        return oreIDs.keySet().toArray(new String[oreIDs.keySet().size()]);
    }

    public static ArrayList<ye> getOres(Integer id) {
        ArrayList<Object> val = oreStacks.get(id);
        if (val == null) {
            val = new ArrayList();
            oreStacks.put(id, val);
        }
        return val;
    }

    private static boolean containsMatch(boolean strict, ye[] inputs, ye ... targets) {
        for (ye input : inputs) {
            for (ye target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean itemMatches(ye target, ye input, boolean strict) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return target.d == input.d && (target.k() == Short.MAX_VALUE && !strict || target.k() == input.k());
    }

    public static void registerOre(String name, yc ore) {
        OreDictionary.registerOre(name, new ye(ore));
    }

    public static void registerOre(String name, aqz ore) {
        OreDictionary.registerOre(name, new ye(ore));
    }

    public static void registerOre(String name, ye ore) {
        OreDictionary.registerOre(name, OreDictionary.getOreID(name), ore);
    }

    public static void registerOre(int id, yc ore) {
        OreDictionary.registerOre(id, new ye(ore));
    }

    public static void registerOre(int id, aqz ore) {
        OreDictionary.registerOre(id, new ye(ore));
    }

    public static void registerOre(int id, ye ore) {
        OreDictionary.registerOre(OreDictionary.getOreName(id), id, ore);
    }

    private static void registerOre(String name, int id, ye ore) {
        ArrayList<ye> ores = OreDictionary.getOres(id);
        ore = ore.m();
        ores.add(ore);
        MinecraftForge.EVENT_BUS.post(new OreRegisterEvent(name, ore));
    }

    static {
        OreDictionary.initVanillaEntries();
    }

    public static class OreRegisterEvent
    extends Event {
        public final String Name;
        public final ye Ore;

        public OreRegisterEvent(String name, ye ore) {
            this.Name = name;
            this.Ore = ore;
        }
    }
}

