/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraftforge.event.terraingen.DeferredBiomeDecorator;

public class BiomeDictionary {
    private static final int BIOME_LIST_SIZE = ahu.n().length;
    private static BiomeInfo[] biomeList = new BiomeInfo[BIOME_LIST_SIZE];
    private static ArrayList<ahu>[] typeInfoList = new ArrayList[Type.values().length];

    public static boolean registerBiomeType(ahu biome, Type ... types) {
        if (ahu.n()[biome.ay] != null) {
            for (Type type : types) {
                if (typeInfoList[type.ordinal()] == null) {
                    BiomeDictionary.typeInfoList[type.ordinal()] = new ArrayList();
                }
                typeInfoList[type.ordinal()].add(biome);
            }
            if (biomeList[biome.ay] == null) {
                BiomeDictionary.biomeList[biome.ay] = new BiomeInfo(types);
            } else {
                for (Type type : types) {
                    BiomeDictionary.biomeList[biome.ay].typeList.add(type);
                }
            }
            return true;
        }
        return false;
    }

    public static ahu[] getBiomesForType(Type type) {
        if (typeInfoList[type.ordinal()] != null) {
            return typeInfoList[type.ordinal()].toArray(new ahu[0]);
        }
        return new ahu[0];
    }

    public static Type[] getTypesForBiome(ahu biome) {
        BiomeDictionary.checkRegistration(biome);
        if (biomeList[biome.ay] != null) {
            return BiomeDictionary.biomeList[biome.ay].typeList.toArray(new Type[0]);
        }
        return new Type[0];
    }

    public static boolean areBiomesEquivalent(ahu biomeA, ahu biomeB) {
        int a2 = biomeA.ay;
        int b2 = biomeB.ay;
        BiomeDictionary.checkRegistration(biomeA);
        BiomeDictionary.checkRegistration(biomeB);
        if (biomeList[a2] != null && biomeList[b2] != null) {
            for (Type type : BiomeDictionary.biomeList[a2].typeList) {
                if (!BiomeDictionary.containsType(biomeList[b2], type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBiomeOfType(ahu biome, Type type) {
        BiomeDictionary.checkRegistration(biome);
        if (biomeList[biome.ay] != null) {
            return BiomeDictionary.containsType(biomeList[biome.ay], type);
        }
        return false;
    }

    public static boolean isBiomeRegistered(ahu biome) {
        return biomeList[biome.ay] != null;
    }

    public static boolean isBiomeRegistered(int biomeID) {
        return biomeList[biomeID] != null;
    }

    public static void registerAllBiomes() {
        FMLLog.warning("Redundant call to BiomeDictionary.registerAllBiomes ignored", new Object[0]);
    }

    public static void registerAllBiomesAndGenerateEvents() {
        for (int i = 0; i < ahu.n().length; ++i) {
            ahu biome = ahu.n()[i];
            if (biome == null) continue;
            if (biome.ar instanceof DeferredBiomeDecorator) {
                DeferredBiomeDecorator decorator = (DeferredBiomeDecorator)biome.ar;
                decorator.fireCreateEventAndReplace(biome);
            }
            BiomeDictionary.checkRegistration(biome);
        }
    }

    public static void makeBestGuess(ahu biome) {
        if (biome.ar.x >= 3) {
            if (biome.f() && biome.ao >= 1.0f) {
                BiomeDictionary.registerBiomeType(biome, Type.JUNGLE);
            } else if (!biome.f()) {
                BiomeDictionary.registerBiomeType(biome, Type.FOREST);
            }
        } else if (biome.an <= 0.3f && biome.an >= 0.0f && (!biome.f() || biome.am >= 0.0f)) {
            BiomeDictionary.registerBiomeType(biome, Type.PLAINS);
        }
        if (biome.f() && biome.am < 0.0f && biome.an <= 0.3f && biome.an >= 0.0f) {
            BiomeDictionary.registerBiomeType(biome, Type.SWAMP);
        }
        if (biome.am <= -0.5f) {
            BiomeDictionary.registerBiomeType(biome, Type.WATER);
        }
        if (biome.an >= 1.5f) {
            BiomeDictionary.registerBiomeType(biome, Type.MOUNTAIN);
        }
        if (biome.d() || biome.ao < 0.2f) {
            BiomeDictionary.registerBiomeType(biome, Type.FROZEN);
        }
        if (!biome.f() && biome.ao >= 1.0f) {
            BiomeDictionary.registerBiomeType(biome, Type.DESERT);
        }
    }

    private static void checkRegistration(ahu biome) {
        if (!BiomeDictionary.isBiomeRegistered(biome)) {
            BiomeDictionary.makeBestGuess(biome);
        }
    }

    private static boolean containsType(BiomeInfo info, Type type) {
        return info.typeList.contains((Object)type);
    }

    private static void registerVanillaBiomes() {
        BiomeDictionary.registerBiomeType(ahu.o, Type.WATER);
        BiomeDictionary.registerBiomeType(ahu.p, Type.PLAINS);
        BiomeDictionary.registerBiomeType(ahu.q, Type.DESERT);
        BiomeDictionary.registerBiomeType(ahu.r, Type.MOUNTAIN);
        BiomeDictionary.registerBiomeType(ahu.s, Type.FOREST);
        BiomeDictionary.registerBiomeType(ahu.t, Type.FOREST, Type.FROZEN);
        BiomeDictionary.registerBiomeType(ahu.H, Type.FOREST, Type.FROZEN);
        BiomeDictionary.registerBiomeType(ahu.u, Type.SWAMP);
        BiomeDictionary.registerBiomeType(ahu.v, Type.WATER);
        BiomeDictionary.registerBiomeType(ahu.y, Type.WATER, Type.FROZEN);
        BiomeDictionary.registerBiomeType(ahu.z, Type.WATER, Type.FROZEN);
        BiomeDictionary.registerBiomeType(ahu.A, Type.FROZEN);
        BiomeDictionary.registerBiomeType(ahu.B, Type.FROZEN);
        BiomeDictionary.registerBiomeType(ahu.E, Type.BEACH);
        BiomeDictionary.registerBiomeType(ahu.F, Type.DESERT);
        BiomeDictionary.registerBiomeType(ahu.J, Type.JUNGLE);
        BiomeDictionary.registerBiomeType(ahu.K, Type.JUNGLE);
        BiomeDictionary.registerBiomeType(ahu.G, Type.FOREST);
        BiomeDictionary.registerBiomeType(ahu.x, Type.END);
        BiomeDictionary.registerBiomeType(ahu.w, Type.NETHER);
        BiomeDictionary.registerBiomeType(ahu.C, Type.MUSHROOM);
        BiomeDictionary.registerBiomeType(ahu.I, Type.MOUNTAIN);
        BiomeDictionary.registerBiomeType(ahu.D, Type.MUSHROOM, Type.BEACH);
        BiomeDictionary.registerBiomeType(ahu.L, Type.JUNGLE);
        BiomeDictionary.registerBiomeType(ahu.M, Type.WATER);
        BiomeDictionary.registerBiomeType(ahu.N, Type.BEACH);
        BiomeDictionary.registerBiomeType(ahu.O, Type.BEACH, Type.FROZEN);
        BiomeDictionary.registerBiomeType(ahu.P, Type.FOREST);
        BiomeDictionary.registerBiomeType(ahu.Q, Type.FOREST);
        BiomeDictionary.registerBiomeType(ahu.R, Type.FOREST);
        BiomeDictionary.registerBiomeType(ahu.S, Type.FOREST, Type.FROZEN);
        BiomeDictionary.registerBiomeType(ahu.T, Type.FOREST, Type.FROZEN);
        BiomeDictionary.registerBiomeType(ahu.U, Type.FOREST);
        BiomeDictionary.registerBiomeType(ahu.V, Type.FOREST);
        BiomeDictionary.registerBiomeType(ahu.W, Type.FOREST);
        BiomeDictionary.registerBiomeType(ahu.X, Type.PLAINS, Type.DESERT);
        BiomeDictionary.registerBiomeType(ahu.Y, Type.PLAINS, Type.DESERT);
        BiomeDictionary.registerBiomeType(ahu.Z, Type.DESERT);
        BiomeDictionary.registerBiomeType(ahu.aa, Type.DESERT);
        BiomeDictionary.registerBiomeType(ahu.ab, Type.DESERT);
    }

    static {
        BiomeDictionary.registerVanillaBiomes();
    }

    private static class BiomeInfo {
        public EnumSet<Type> typeList = EnumSet.noneOf(Type.class);

        public BiomeInfo(Type[] types) {
            for (Type t : types) {
                this.typeList.add(t);
            }
        }
    }

    public static enum Type {
        FOREST,
        PLAINS,
        MOUNTAIN,
        HILLS,
        SWAMP,
        WATER,
        DESERT,
        FROZEN,
        JUNGLE,
        WASTELAND,
        BEACH,
        NETHER,
        END,
        MUSHROOM,
        MAGICAL;

    }
}

