/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ItemFluidContainer
extends adb
implements IFluidContainerItem {
    protected int capacity;

    public ItemFluidContainer(int itemID) {
    }

    public ItemFluidContainer(int itemID, int capacity) {
        this.capacity = capacity;
    }

    public ItemFluidContainer setCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    @Override
    public FluidStack getFluid(add container) {
        if (container.d == null || !container.d.c("Fluid")) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT(container.d.m("Fluid"));
    }

    @Override
    public int getCapacity(add container) {
        return this.capacity;
    }

    @Override
    public int fill(add container, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (!doFill) {
            if (container.d == null || !container.d.c("Fluid")) {
                return Math.min(this.capacity, resource.amount);
            }
            FluidStack stack = FluidStack.loadFluidStackFromNBT(container.d.m("Fluid"));
            if (stack == null) {
                return Math.min(this.capacity, resource.amount);
            }
            if (!stack.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.capacity - stack.amount, resource.amount);
        }
        if (container.d == null) {
            container.d = new dh();
        }
        if (!container.d.c("Fluid")) {
            dh fluidTag = resource.writeToNBT(new dh());
            if (this.capacity < resource.amount) {
                fluidTag.a("Amount", this.capacity);
                container.d.a("Fluid", (dy)fluidTag);
                return this.capacity;
            }
            container.d.a("Fluid", (dy)fluidTag);
            return resource.amount;
        }
        dh fluidTag = container.d.m("Fluid");
        FluidStack stack = FluidStack.loadFluidStackFromNBT(fluidTag);
        if (!stack.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.capacity - stack.amount;
        if (resource.amount < filled) {
            stack.amount += resource.amount;
            filled = resource.amount;
        } else {
            stack.amount = this.capacity;
        }
        container.d.a("Fluid", (dy)stack.writeToNBT(fluidTag));
        return filled;
    }

    @Override
    public FluidStack drain(add container, int maxDrain, boolean doDrain) {
        if (container.d == null || !container.d.c("Fluid")) {
            return null;
        }
        FluidStack stack = FluidStack.loadFluidStackFromNBT(container.d.m("Fluid"));
        if (stack == null) {
            return null;
        }
        stack.amount = Math.min(stack.amount, maxDrain);
        if (doDrain) {
            if (maxDrain >= this.capacity) {
                container.d.o("Fluid");
                if (container.d.d()) {
                    container.d = null;
                }
                return stack;
            }
            dh fluidTag = container.d.m("Fluid");
            fluidTag.a("Amount", fluidTag.f("Amount") - maxDrain);
            container.d.a("Fluid", (dy)fluidTag);
        }
        return stack;
    }
}

