/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ICrashCallable;
import cpw.mods.fml.common.IFMLSidedHandler;
import cpw.mods.fml.common.InjectedModContainer;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.WorldAccessContainer;
import cpw.mods.fml.common.eventhandler.EventBus;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.server.FMLServerHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class FMLCommonHandler {
    private static final FMLCommonHandler INSTANCE = new FMLCommonHandler();
    private IFMLSidedHandler sidedDelegate;
    private Class<?> forge;
    private boolean noForge;
    private List<String> brandings;
    private List<String> brandingsNoMC;
    private List<ICrashCallable> crashCallables = Lists.newArrayList((Object[])new ICrashCallable[]{Loader.instance().getCallableCrashInformation()});
    private Set<axc> handlerSet = Sets.newSetFromMap((Map)new MapMaker().weakKeys().makeMap());
    private EventBus eventBus = new EventBus();

    public EventBus bus() {
        return this.eventBus;
    }

    public void beginLoading(IFMLSidedHandler handler) {
        this.sidedDelegate = handler;
        FMLLog.log("MinecraftForge", Level.INFO, "Attempting early MinecraftForge initialization", new Object[0]);
        this.callForgeMethod("initialize");
        this.callForgeMethod("registerCrashCallable");
        FMLLog.log("MinecraftForge", Level.INFO, "Completed early MinecraftForge initialization", new Object[0]);
    }

    public static FMLCommonHandler instance() {
        return INSTANCE;
    }

    public ModContainer findContainerFor(Object mod) {
        return (ModContainer)Loader.instance().getReversedModObjectList().get(mod);
    }

    public Logger getFMLLogger() {
        return FMLLog.getLogger();
    }

    public Side getSide() {
        return this.sidedDelegate.getSide();
    }

    public Side getEffectiveSide() {
        Thread thr = Thread.currentThread();
        if (thr.getName().equals("Server thread")) {
            return Side.SERVER;
        }
        return Side.CLIENT;
    }

    public void raiseException(Throwable exception, String message, boolean stopGame) {
        FMLLog.log(Level.ERROR, exception, "Something raised an exception. The message was '%s'. 'stopGame' is %b", message, stopGame);
        if (stopGame) {
            this.getSidedDelegate().haltGame(message, exception);
        }
    }

    private Class<?> findMinecraftForge() {
        if (this.forge == null && !this.noForge) {
            try {
                this.forge = Class.forName("net.minecraftforge.common.MinecraftForge");
            }
            catch (Exception ex) {
                this.noForge = true;
            }
        }
        return this.forge;
    }

    private Object callForgeMethod(String method) {
        if (this.noForge) {
            return null;
        }
        try {
            return this.findMinecraftForge().getMethod(method, new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void computeBranding() {
        if (this.brandings == null) {
            ImmutableList.Builder brd = ImmutableList.builder();
            brd.add((Object)Loader.instance().getMCVersionString());
            brd.add((Object)Loader.instance().getMCPVersionString());
            brd.add((Object)("FML v" + Loader.instance().getFMLVersionString()));
            String forgeBranding = (String)this.callForgeMethod("getBrandingVersion");
            if (!Strings.isNullOrEmpty((String)forgeBranding)) {
                brd.add((Object)forgeBranding);
            }
            if (this.sidedDelegate != null) {
                brd.addAll(this.sidedDelegate.getAdditionalBrandingInformation());
            }
            if (Loader.instance().getFMLBrandingProperties().containsKey("fmlbranding")) {
                brd.add((Object)Loader.instance().getFMLBrandingProperties().get("fmlbranding"));
            }
            int tModCount = Loader.instance().getModList().size();
            int aModCount = Loader.instance().getActiveModList().size();
            brd.add((Object)String.format("%d mod%s loaded, %d mod%s active", tModCount, tModCount != 1 ? "s" : "", aModCount, aModCount != 1 ? "s" : ""));
            this.brandings = brd.build();
            this.brandingsNoMC = this.brandings.subList(1, this.brandings.size());
        }
    }

    public List<String> getBrandings(boolean includeMC) {
        if (this.brandings == null) {
            this.computeBranding();
        }
        return includeMC ? ImmutableList.copyOf(this.brandings) : ImmutableList.copyOf(this.brandingsNoMC);
    }

    public IFMLSidedHandler getSidedDelegate() {
        return this.sidedDelegate;
    }

    public void onPostServerTick() {
        this.bus().post(new TickEvent.ServerTickEvent(TickEvent.Phase.END));
    }

    public void onPostWorldTick(afn world) {
        this.bus().post(new TickEvent.WorldTickEvent(Side.SERVER, TickEvent.Phase.END, world));
    }

    public void onPreServerTick() {
        this.bus().post(new TickEvent.ServerTickEvent(TickEvent.Phase.START));
    }

    public void onPreWorldTick(afn world) {
        this.bus().post(new TickEvent.WorldTickEvent(Side.SERVER, TickEvent.Phase.START, world));
    }

    public boolean handleServerAboutToStart(MinecraftServer server) {
        return Loader.instance().serverAboutToStart(server);
    }

    public boolean handleServerStarting(MinecraftServer server) {
        return Loader.instance().serverStarting(server);
    }

    public void handleServerStarted() {
        Loader.instance().serverStarted();
    }

    public void handleServerStopping() {
        Loader.instance().serverStopping();
    }

    public MinecraftServer getMinecraftServerInstance() {
        return this.sidedDelegate.getServer();
    }

    public void showGuiScreen(Object clientGuiElement) {
        this.sidedDelegate.showGuiScreen(clientGuiElement);
    }

    public void onServerStart(MinecraftServer dedicatedServer) {
        FMLServerHandler.instance();
        this.sidedDelegate.beginServerLoading(dedicatedServer);
    }

    public void onServerStarted() {
        this.sidedDelegate.finishServerLoading();
    }

    public void onPreClientTick() {
        this.bus().post(new TickEvent.ClientTickEvent(TickEvent.Phase.START));
    }

    public void onPostClientTick() {
        this.bus().post(new TickEvent.ClientTickEvent(TickEvent.Phase.END));
    }

    public void onRenderTickStart(float timer) {
        this.bus().post(new TickEvent.RenderTickEvent(TickEvent.Phase.START, timer));
    }

    public void onRenderTickEnd(float timer) {
        this.bus().post(new TickEvent.RenderTickEvent(TickEvent.Phase.END, timer));
    }

    public void onPlayerPreTick(xl player) {
        this.bus().post(new TickEvent.PlayerTickEvent(TickEvent.Phase.START, player));
    }

    public void onPlayerPostTick(xl player) {
        this.bus().post(new TickEvent.PlayerTickEvent(TickEvent.Phase.END, player));
    }

    public void registerCrashCallable(ICrashCallable callable) {
        this.crashCallables.add(callable);
    }

    public void enhanceCrashReport(b crashReport, k category) {
        for (ICrashCallable call : this.crashCallables) {
            category.a(call.getLabel(), (Callable)call);
        }
    }

    public void handleWorldDataSave(axc handler, axe worldInfo, dg tagCompound) {
        for (ModContainer mc : Loader.instance().getModList()) {
            WorldAccessContainer wac;
            if (!(mc instanceof InjectedModContainer) || (wac = ((InjectedModContainer)mc).getWrappedWorldAccessContainer()) == null) continue;
            dg dataForWriting = wac.getDataForWriting(handler, worldInfo);
            tagCompound.a(mc.getModId(), (du)dataForWriting);
        }
    }

    public void handleWorldDataLoad(axc handler, axe worldInfo, dg tagCompound) {
        if (this.getEffectiveSide() != Side.SERVER) {
            return;
        }
        if (this.handlerSet.contains(handler)) {
            return;
        }
        this.handlerSet.add(handler);
        HashMap additionalProperties = Maps.newHashMap();
        for (ModContainer mc : Loader.instance().getModList()) {
            WorldAccessContainer wac;
            if (!(mc instanceof InjectedModContainer) || (wac = ((InjectedModContainer)mc).getWrappedWorldAccessContainer()) == null) continue;
            wac.readData(handler, worldInfo, additionalProperties, tagCompound.m(mc.getModId()));
        }
    }

    public boolean shouldServerBeKilledQuietly() {
        if (this.sidedDelegate == null) {
            return false;
        }
        return this.sidedDelegate.shouldServerShouldBeKilledQuietly();
    }

    public void handleServerStopped() {
        this.sidedDelegate.serverStopped();
        MinecraftServer server = this.getMinecraftServerInstance();
        Loader.instance().serverStopped();
        if (server != null) {
            ObfuscationReflectionHelper.setPrivateValue(MinecraftServer.class, server, Boolean.valueOf(false), "field_71316_v", "u", "serverStopped");
        }
    }

    public String getModName() {
        ArrayList modNames = Lists.newArrayListWithExpectedSize((int)3);
        modNames.add("fml");
        if (!this.noForge) {
            modNames.add("forge");
        }
        if (Loader.instance().getFMLBrandingProperties().containsKey("snooperbranding")) {
            modNames.add(Loader.instance().getFMLBrandingProperties().get("snooperbranding"));
        }
        return Joiner.on((char)',').join((Iterable)modNames);
    }

    public void addModToResourcePack(ModContainer container) {
        this.sidedDelegate.addModAsResource(container);
    }

    public void updateResourcePackList() {
        this.sidedDelegate.updateResourcePackList();
    }

    public String getCurrentLanguage() {
        return this.sidedDelegate.getCurrentLanguage();
    }

    public void bootstrap() {
    }

    public ef getClientToServerNetworkManager() {
        return this.sidedDelegate.getClientToServerNetworkManager();
    }

    public void fireMouseInput() {
        this.bus().post(new InputEvent.MouseInputEvent());
    }

    public void fireKeyInput() {
        this.bus().post(new InputEvent.KeyInputEvent());
    }

    public void firePlayerChangedDimensionEvent(xl player, int fromDim, int toDim) {
        this.bus().post(new PlayerEvent.PlayerChangedDimensionEvent(player, fromDim, toDim));
    }

    public void firePlayerLoggedIn(xl player) {
        this.bus().post(new PlayerEvent.PlayerLoggedInEvent(player));
    }

    public void firePlayerLoggedOut(xl player) {
        this.bus().post(new PlayerEvent.PlayerLoggedOutEvent(player));
    }

    public void firePlayerRespawnEvent(xl player) {
        this.bus().post(new PlayerEvent.PlayerRespawnEvent(player));
    }

    public void firePlayerItemPickupEvent(xl player, vw item) {
        this.bus().post(new PlayerEvent.ItemPickupEvent(player, item));
    }

    public void firePlayerCraftingEvent(xl player, abp crafted, po craftMatrix) {
        this.bus().post(new PlayerEvent.ItemCraftedEvent(player, crafted, craftMatrix));
    }

    public void firePlayerSmeltedEvent(xl player, abp smelted) {
        this.bus().post(new PlayerEvent.ItemSmeltedEvent(player, smelted));
    }

    public es getClientPlayHandler() {
        return this.sidedDelegate.getClientPlayHandler();
    }
}

