/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.collect.Maps;
import java.util.BitSet;
import java.util.IdentityHashMap;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.IItemRenderer;

public class MinecraftForgeClient {
    private static IdentityHashMap<abn, IItemRenderer> customItemRenderers = Maps.newIdentityHashMap();
    private static BitSet stencilBits = new BitSet(MinecraftForgeClient.getStencilBits());

    public static void registerItemRenderer(abn item, IItemRenderer renderer) {
        customItemRenderers.put(item, renderer);
    }

    public static IItemRenderer getItemRenderer(abp item, IItemRenderer.ItemRenderType type) {
        IItemRenderer renderer = customItemRenderers.get(item);
        if (renderer != null && renderer.handleRenderType(item, type)) {
            return renderer;
        }
        return null;
    }

    public static int getRenderPass() {
        return ForgeHooksClient.renderPass;
    }

    public static int getStencilBits() {
        return ForgeHooksClient.stencilBits;
    }

    public static int reserveStencilBit() {
        int bit = stencilBits.nextSetBit(0);
        if (bit >= 0) {
            stencilBits.clear(bit);
        }
        return bit;
    }

    public static void releaseStencilBit(int bit) {
        if (bit >= 0 && bit < MinecraftForgeClient.getStencilBits()) {
            stencilBits.set(bit);
        }
    }

    static {
        stencilBits.set(0, MinecraftForgeClient.getStencilBits());
    }
}

