/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraftforge.event.terraingen.DeferredBiomeDecorator;

public class BiomeDictionary {
    private static final int BIOME_LIST_SIZE = 256;
    private static BiomeInfo[] biomeList = new BiomeInfo[256];
    private static ArrayList<agg>[] typeInfoList = new ArrayList[Type.values().length];

    public static boolean registerBiomeType(agg biome, Type ... types) {
        if (agg.n()[biome.ay] != null) {
            for (Type type : types) {
                if (typeInfoList[type.ordinal()] == null) {
                    BiomeDictionary.typeInfoList[type.ordinal()] = new ArrayList();
                }
                typeInfoList[type.ordinal()].add(biome);
            }
            if (biomeList[biome.ay] == null) {
                BiomeDictionary.biomeList[biome.ay] = new BiomeInfo(types);
            } else {
                for (Type type : types) {
                    BiomeDictionary.biomeList[biome.ay].typeList.add(type);
                }
            }
            return true;
        }
        return false;
    }

    public static agg[] getBiomesForType(Type type) {
        if (typeInfoList[type.ordinal()] != null) {
            return typeInfoList[type.ordinal()].toArray(new agg[0]);
        }
        return new agg[0];
    }

    public static Type[] getTypesForBiome(agg biome) {
        BiomeDictionary.checkRegistration(biome);
        if (biomeList[biome.ay] != null) {
            return BiomeDictionary.biomeList[biome.ay].typeList.toArray(new Type[0]);
        }
        return new Type[0];
    }

    public static boolean areBiomesEquivalent(agg biomeA, agg biomeB) {
        int a2 = biomeA.ay;
        int b2 = biomeB.ay;
        BiomeDictionary.checkRegistration(biomeA);
        BiomeDictionary.checkRegistration(biomeB);
        if (biomeList[a2] != null && biomeList[b2] != null) {
            for (Type type : BiomeDictionary.biomeList[a2].typeList) {
                if (!BiomeDictionary.containsType(biomeList[b2], type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBiomeOfType(agg biome, Type type) {
        BiomeDictionary.checkRegistration(biome);
        if (biomeList[biome.ay] != null) {
            return BiomeDictionary.containsType(biomeList[biome.ay], type);
        }
        return false;
    }

    public static boolean isBiomeRegistered(agg biome) {
        return biomeList[biome.ay] != null;
    }

    public static boolean isBiomeRegistered(int biomeID) {
        return biomeList[biomeID] != null;
    }

    public static void registerAllBiomes() {
        FMLLog.warning("Redundant call to BiomeDictionary.registerAllBiomes ignored", new Object[0]);
    }

    public static void registerAllBiomesAndGenerateEvents() {
        for (int i = 0; i < agg.n().length; ++i) {
            agg biome = agg.n()[i];
            if (biome == null) continue;
            if (biome.ar instanceof DeferredBiomeDecorator) {
                DeferredBiomeDecorator decorator = (DeferredBiomeDecorator)biome.ar;
                decorator.fireCreateEventAndReplace(biome);
            }
            BiomeDictionary.checkRegistration(biome);
        }
    }

    public static void makeBestGuess(agg biome) {
        if (biome.ar.x >= 3) {
            if (biome.f() && biome.ao >= 1.0f) {
                BiomeDictionary.registerBiomeType(biome, Type.JUNGLE);
            } else if (!biome.f()) {
                BiomeDictionary.registerBiomeType(biome, Type.FOREST);
            }
        } else if (biome.an <= 0.3f && biome.an >= 0.0f && (!biome.f() || biome.am >= 0.0f)) {
            BiomeDictionary.registerBiomeType(biome, Type.PLAINS);
        }
        if (biome.f() && biome.am < 0.0f && biome.an <= 0.3f && biome.an >= 0.0f) {
            BiomeDictionary.registerBiomeType(biome, Type.SWAMP);
        }
        if (biome.am <= -0.5f) {
            BiomeDictionary.registerBiomeType(biome, Type.WATER);
        }
        if (biome.an >= 1.5f) {
            BiomeDictionary.registerBiomeType(biome, Type.MOUNTAIN);
        }
        if (biome.d() || biome.ao < 0.2f) {
            BiomeDictionary.registerBiomeType(biome, Type.FROZEN);
        }
        if (!biome.f() && biome.ao >= 1.0f) {
            BiomeDictionary.registerBiomeType(biome, Type.DESERT);
        }
    }

    private static void checkRegistration(agg biome) {
        if (!BiomeDictionary.isBiomeRegistered(biome)) {
            BiomeDictionary.makeBestGuess(biome);
        }
    }

    private static boolean containsType(BiomeInfo info, Type type) {
        return info.typeList.contains((Object)type);
    }

    private static void registerVanillaBiomes() {
        BiomeDictionary.registerBiomeType(agg.o, Type.WATER);
        BiomeDictionary.registerBiomeType(agg.p, Type.PLAINS);
        BiomeDictionary.registerBiomeType(agg.q, Type.DESERT);
        BiomeDictionary.registerBiomeType(agg.r, Type.MOUNTAIN);
        BiomeDictionary.registerBiomeType(agg.s, Type.FOREST);
        BiomeDictionary.registerBiomeType(agg.t, Type.FOREST, Type.FROZEN);
        BiomeDictionary.registerBiomeType(agg.H, Type.FOREST, Type.FROZEN);
        BiomeDictionary.registerBiomeType(agg.u, Type.SWAMP);
        BiomeDictionary.registerBiomeType(agg.v, Type.WATER);
        BiomeDictionary.registerBiomeType(agg.y, Type.WATER, Type.FROZEN);
        BiomeDictionary.registerBiomeType(agg.z, Type.WATER, Type.FROZEN);
        BiomeDictionary.registerBiomeType(agg.A, Type.FROZEN);
        BiomeDictionary.registerBiomeType(agg.B, Type.FROZEN);
        BiomeDictionary.registerBiomeType(agg.E, Type.BEACH);
        BiomeDictionary.registerBiomeType(agg.F, Type.DESERT);
        BiomeDictionary.registerBiomeType(agg.J, Type.JUNGLE);
        BiomeDictionary.registerBiomeType(agg.K, Type.JUNGLE);
        BiomeDictionary.registerBiomeType(agg.G, Type.FOREST);
        BiomeDictionary.registerBiomeType(agg.x, Type.END);
        BiomeDictionary.registerBiomeType(agg.w, Type.NETHER);
        BiomeDictionary.registerBiomeType(agg.C, Type.MUSHROOM);
        BiomeDictionary.registerBiomeType(agg.I, Type.MOUNTAIN);
        BiomeDictionary.registerBiomeType(agg.D, Type.MUSHROOM, Type.BEACH);
    }

    static {
        BiomeDictionary.registerVanillaBiomes();
    }

    private static class BiomeInfo {
        public EnumSet<Type> typeList = EnumSet.noneOf(Type.class);

        public BiomeInfo(Type[] types) {
            for (Type t : types) {
                this.typeList.add(t);
            }
        }
    }

    public static enum Type {
        FOREST,
        PLAINS,
        MOUNTAIN,
        HILLS,
        SWAMP,
        WATER,
        DESERT,
        FROZEN,
        JUNGLE,
        WASTELAND,
        BEACH,
        NETHER,
        END,
        MUSHROOM,
        MAGICAL;

    }
}

