/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;

public class ChestGenHooks {
    public static final String MINESHAFT_CORRIDOR = "mineshaftCorridor";
    public static final String PYRAMID_DESERT_CHEST = "pyramidDesertyChest";
    public static final String PYRAMID_JUNGLE_CHEST = "pyramidJungleChest";
    public static final String PYRAMID_JUNGLE_DISPENSER = "pyramidJungleDispenser";
    public static final String STRONGHOLD_CORRIDOR = "strongholdCorridor";
    public static final String STRONGHOLD_LIBRARY = "strongholdLibrary";
    public static final String STRONGHOLD_CROSSING = "strongholdCrossing";
    public static final String VILLAGE_BLACKSMITH = "villageBlacksmith";
    public static final String BONUS_CHEST = "bonusChest";
    public static final String DUNGEON_CHEST = "dungeonChest";
    private static final HashMap<String, ChestGenHooks> chestInfo = new HashMap();
    private static boolean hasInit = false;
    private String category;
    private int countMin = 0;
    private int countMax = 0;
    ArrayList<pk> contents = new ArrayList();

    private static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        ChestGenHooks.addInfo(MINESHAFT_CORRIDOR, arj.a, 3, 7);
        ChestGenHooks.addInfo(PYRAMID_DESERT_CHEST, asn.i, 2, 7);
        ChestGenHooks.addInfo(PYRAMID_JUNGLE_CHEST, aso.l, 2, 7);
        ChestGenHooks.addInfo(PYRAMID_JUNGLE_DISPENSER, aso.m, 2, 2);
        ChestGenHooks.addInfo(STRONGHOLD_CORRIDOR, asy.a, 2, 4);
        ChestGenHooks.addInfo(STRONGHOLD_LIBRARY, atc.a, 1, 5);
        ChestGenHooks.addInfo(STRONGHOLD_CROSSING, ath.b, 1, 5);
        ChestGenHooks.addInfo(VILLAGE_BLACKSMITH, auk.a, 3, 9);
        ChestGenHooks.addInfo(BONUS_CHEST, mj.U, 10, 10);
        ChestGenHooks.addInfo(DUNGEON_CHEST, aqp.a, 8, 8);
        abp book = new abp((abn)abq.bR, 1, 0);
        pk tmp = new pk(book, 1, 1, 1);
        ChestGenHooks.getInfo(MINESHAFT_CORRIDOR).addItem(tmp);
        ChestGenHooks.getInfo(PYRAMID_DESERT_CHEST).addItem(tmp);
        ChestGenHooks.getInfo(PYRAMID_JUNGLE_CHEST).addItem(tmp);
        ChestGenHooks.getInfo(STRONGHOLD_CORRIDOR).addItem(tmp);
        ChestGenHooks.getInfo(STRONGHOLD_LIBRARY).addItem(new pk(book, 1, 5, 2));
        ChestGenHooks.getInfo(STRONGHOLD_CROSSING).addItem(tmp);
        ChestGenHooks.getInfo(DUNGEON_CHEST).addItem(tmp);
    }

    static void addDungeonLoot(ChestGenHooks dungeon, abp item, int weight, int min, int max) {
        dungeon.addItem(new pk(item, min, max, weight));
    }

    private static void addInfo(String category, pk[] items, int min, int max) {
        chestInfo.put(category, new ChestGenHooks(category, items, min, max));
    }

    public static ChestGenHooks getInfo(String category) {
        if (!chestInfo.containsKey(category)) {
            chestInfo.put(category, new ChestGenHooks(category));
        }
        return chestInfo.get(category);
    }

    public static abp[] generateStacks(Random rand, abp source, int min, int max) {
        abp[] ret;
        int count = min + rand.nextInt(max - min + 1);
        if (source.b() == null) {
            ret = new abp[]{};
        } else if (count > source.e()) {
            ret = new abp[count];
            for (int x = 0; x < count; ++x) {
                ret[x] = source.m();
                ret[x].b = 1;
            }
        } else {
            ret = new abp[]{source.m()};
            ret[0].b = count;
        }
        return ret;
    }

    public static pk[] getItems(String category, Random rnd) {
        return ChestGenHooks.getInfo(category).getItems(rnd);
    }

    public static int getCount(String category, Random rand) {
        return ChestGenHooks.getInfo(category).getCount(rand);
    }

    public static void addItem(String category, pk item) {
        ChestGenHooks.getInfo(category).addItem(item);
    }

    public static void removeItem(String category, abp item) {
        ChestGenHooks.getInfo(category).removeItem(item);
    }

    public static abp getOneItem(String category, Random rand) {
        return ChestGenHooks.getInfo(category).getOneItem(rand);
    }

    public ChestGenHooks(String category) {
        this.category = category;
    }

    public ChestGenHooks(String category, pk[] items, int min, int max) {
        this(category);
        for (pk item : items) {
            this.contents.add(item);
        }
        this.countMin = min;
        this.countMax = max;
    }

    public void addItem(pk item) {
        this.contents.add(item);
    }

    public void removeItem(abp item) {
        Iterator<pk> itr = this.contents.iterator();
        while (itr.hasNext()) {
            pk cont = itr.next();
            if (!item.a(cont.b) && (item.k() != Short.MAX_VALUE || item.b() != cont.b.b())) continue;
            itr.remove();
        }
    }

    public pk[] getItems(Random rnd) {
        ArrayList<pk> ret = new ArrayList<pk>();
        for (pk orig : this.contents) {
            pk n;
            abn item = orig.b.b();
            if (item == null || (n = item.getChestGenBase(this, rnd, orig)) == null) continue;
            ret.add(n);
        }
        return ret.toArray(new pk[ret.size()]);
    }

    public int getCount(Random rand) {
        return this.countMin < this.countMax ? this.countMin + rand.nextInt(this.countMax - this.countMin) : this.countMin;
    }

    public abp getOneItem(Random rand) {
        pk[] items = this.getItems(rand);
        pk item = (pk)pi.a((Random)rand, (pj[])items);
        abp[] stacks = ChestGenHooks.generateStacks(rand, item.b, item.c, item.d);
        return stacks.length > 0 ? stacks[0] : null;
    }

    public int getMin() {
        return this.countMin;
    }

    public int getMax() {
        return this.countMax;
    }

    public void setMin(int value) {
        this.countMin = value;
    }

    public void setMax(int value) {
        this.countMax = value;
    }

    static {
        ChestGenHooks.init();
    }
}

