/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.network;

import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.HandshakeCompletionHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.EnumMap;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.network.DimensionMessageHandler;
import net.minecraftforge.common.network.FluidIdRegistryMessageHandler;
import net.minecraftforge.common.network.ForgeRuntimeCodec;
import net.minecraftforge.common.network.ServerToClientConnectionEstablishedHandler;

public class ForgeNetworkHandler {
    private static EnumMap<Side, FMLEmbeddedChannel> channelPair;

    public static void registerChannel(ForgeModContainer forgeModContainer, Side side) {
        channelPair = NetworkRegistry.INSTANCE.newChannel(forgeModContainer, "FORGE", new ChannelHandler[]{new ForgeRuntimeCodec(), new HandshakeCompletionHandler()});
        EmbeddedChannel embeddedChannel = channelPair.get((Object)Side.SERVER);
        embeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.NOWHERE);
        if (side == Side.CLIENT) {
            ForgeNetworkHandler.addClientHandlers();
        }
        channelPair.get((Object)Side.SERVER).pipeline().addAfter("net.minecraftforge.common.network.ForgeRuntimeCodec#0", "ServerToClientConnection", (ChannelHandler)new ServerToClientConnectionEstablishedHandler());
    }

    @SideOnly(value=Side.CLIENT)
    private static void addClientHandlers() {
        channelPair.get((Object)Side.CLIENT).pipeline().addAfter("net.minecraftforge.common.network.ForgeRuntimeCodec#0", "DimensionHandler", (ChannelHandler)new DimensionMessageHandler());
        channelPair.get((Object)Side.CLIENT).pipeline().addAfter("net.minecraftforge.common.network.ForgeRuntimeCodec#0", "FluidIdRegistryHandler", (ChannelHandler)new FluidIdRegistryMessageHandler());
    }
}

