/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class OreDictionary {
    private static boolean hasInit = false;
    private static int maxID = 0;
    private static HashMap<String, Integer> oreIDs = new HashMap();
    private static HashMap<Integer, ArrayList<abp>> oreStacks = new HashMap();
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;

    public static void initVanillaEntries() {
        if (!hasInit) {
            OreDictionary.registerOre("logWood", new abp(ahz.r, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("logWood", new abp(ahz.s, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("plankWood", new abp(ahz.f, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("slabWood", new abp((ahu)ahz.bx, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("stairWood", ahz.ad);
            OreDictionary.registerOre("stairWood", ahz.bF);
            OreDictionary.registerOre("stairWood", ahz.bG);
            OreDictionary.registerOre("stairWood", ahz.bH);
            OreDictionary.registerOre("stairWood", ahz.ck);
            OreDictionary.registerOre("stairWood", ahz.cl);
            OreDictionary.registerOre("stickWood", abq.y);
            OreDictionary.registerOre("treeSapling", new abp(ahz.g, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new abp((ahu)ahz.t, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new abp((ahu)ahz.u, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("oreGold", ahz.o);
            OreDictionary.registerOre("oreIron", ahz.p);
            OreDictionary.registerOre("oreLapis", ahz.x);
            OreDictionary.registerOre("oreDiamond", ahz.ag);
            OreDictionary.registerOre("oreRedstone", ahz.ax);
            OreDictionary.registerOre("oreEmerald", ahz.bA);
            OreDictionary.registerOre("oreQuartz", ahz.bY);
            OreDictionary.registerOre("oreCoal", ahz.q);
            OreDictionary.registerOre("stone", ahz.b);
            OreDictionary.registerOre("cobblestone", ahz.e);
            OreDictionary.registerOre("record", abq.cd);
            OreDictionary.registerOre("record", abq.ce);
            OreDictionary.registerOre("record", abq.cf);
            OreDictionary.registerOre("record", abq.cg);
            OreDictionary.registerOre("record", abq.ch);
            OreDictionary.registerOre("record", abq.ci);
            OreDictionary.registerOre("record", abq.cj);
            OreDictionary.registerOre("record", abq.ck);
            OreDictionary.registerOre("record", abq.cl);
            OreDictionary.registerOre("record", abq.cm);
            OreDictionary.registerOre("record", abq.cn);
            OreDictionary.registerOre("record", abq.co);
        }
        HashMap<abp, String> replacements = new HashMap<abp, String>();
        replacements.put(new abp(abq.y), "stickWood");
        replacements.put(new abp(ahz.f), "plankWood");
        replacements.put(new abp(ahz.f, 1, Short.MAX_VALUE), "plankWood");
        replacements.put(new abp(ahz.b), "stone");
        replacements.put(new abp(ahz.b, 1, Short.MAX_VALUE), "stone");
        replacements.put(new abp(ahz.e), "cobblestone");
        replacements.put(new abp(ahz.e, 1, Short.MAX_VALUE), "cobblestone");
        String[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
        for (int i = 0; i < 16; ++i) {
            abp dye = new abp(abq.aR, 1, i);
            if (!hasInit) {
                OreDictionary.registerOre(dyes[i], dye);
            }
            replacements.put(dye, dyes[i]);
        }
        hasInit = true;
        abp[] replaceStacks = replacements.keySet().toArray(new abp[replacements.keySet().size()]);
        abp[] exclusions = new abp[]{new abp(ahz.y), new abp(abq.aX), new abp(ahz.aV), new abp((ahu)ahz.U), new abp(ahz.ar), new abp(ahz.bK), new abp(ahz.ad), new abp(ahz.bF), new abp(ahz.bG), new abp(ahz.bH), new abp(ahz.ck), new abp(ahz.cl)};
        List recipes = adq.a().b();
        ArrayList<Object> recipesToRemove = new ArrayList<Object>();
        ArrayList<Object> recipesToAdd = new ArrayList<Object>();
        for (Object obj : recipes) {
            abp output;
            adt recipe;
            if (obj instanceof adt) {
                recipe = (adt)obj;
                output = recipe.b();
                if (output != null && OreDictionary.containsMatch(false, exclusions, output) || !OreDictionary.containsMatch(true, recipe.c, replaceStacks)) continue;
                recipesToRemove.add(recipe);
                recipesToAdd.add(new ShapedOreRecipe(recipe, replacements));
                continue;
            }
            if (!(obj instanceof adu) || (output = (recipe = (adu)obj).b()) != null && OreDictionary.containsMatch(false, exclusions, output) || !OreDictionary.containsMatch(true, recipe.b.toArray(new abp[recipe.b.size()]), replaceStacks)) continue;
            recipesToRemove.add((ads)obj);
            ShapelessOreRecipe newRecipe = new ShapelessOreRecipe((adu)recipe, replacements);
            recipesToAdd.add(newRecipe);
        }
        recipes.removeAll(recipesToRemove);
        recipes.addAll(recipesToAdd);
        if (recipesToRemove.size() > 0) {
            FMLLog.info("Replaced %d ore recipies", recipesToRemove.size());
        }
    }

    public static int getOreID(String name) {
        Integer val = oreIDs.get(name);
        if (val == null) {
            val = maxID++;
            oreIDs.put(name, val);
            oreStacks.put(val, new ArrayList());
        }
        return val;
    }

    public static String getOreName(int id) {
        for (Map.Entry<String, Integer> entry : oreIDs.entrySet()) {
            if (id != entry.getValue()) continue;
            return entry.getKey();
        }
        return "Unknown";
    }

    public static int getOreID(abp itemStack) {
        if (itemStack == null) {
            return -1;
        }
        for (Map.Entry<Integer, ArrayList<abp>> ore : oreStacks.entrySet()) {
            for (abp target : ore.getValue()) {
                if (itemStack.b() != target.b() || target.k() != Short.MAX_VALUE && itemStack.k() != target.k()) continue;
                return ore.getKey();
            }
        }
        return -1;
    }

    public static ArrayList<abp> getOres(String name) {
        return OreDictionary.getOres(OreDictionary.getOreID(name));
    }

    public static String[] getOreNames() {
        return oreIDs.keySet().toArray(new String[oreIDs.keySet().size()]);
    }

    public static ArrayList<abp> getOres(Integer id) {
        ArrayList<Object> val = oreStacks.get(id);
        if (val == null) {
            val = new ArrayList();
            oreStacks.put(id, val);
        }
        return val;
    }

    private static boolean containsMatch(boolean strict, abp[] inputs, abp ... targets) {
        for (abp input : inputs) {
            for (abp target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean itemMatches(abp target, abp input, boolean strict) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return target.b() == input.b() && (target.k() == Short.MAX_VALUE && !strict || target.k() == input.k());
    }

    public static void registerOre(String name, abn ore) {
        OreDictionary.registerOre(name, new abp(ore));
    }

    public static void registerOre(String name, ahu ore) {
        OreDictionary.registerOre(name, new abp(ore));
    }

    public static void registerOre(String name, abp ore) {
        OreDictionary.registerOre(name, OreDictionary.getOreID(name), ore);
    }

    public static void registerOre(int id, abn ore) {
        OreDictionary.registerOre(id, new abp(ore));
    }

    public static void registerOre(int id, ahu ore) {
        OreDictionary.registerOre(id, new abp(ore));
    }

    public static void registerOre(int id, abp ore) {
        OreDictionary.registerOre(OreDictionary.getOreName(id), id, ore);
    }

    private static void registerOre(String name, int id, abp ore) {
        ArrayList<abp> ores = OreDictionary.getOres(id);
        ore = ore.m();
        ores.add(ore);
        MinecraftForge.EVENT_BUS.post(new OreRegisterEvent(name, ore));
    }

    static {
        OreDictionary.initVanillaEntries();
    }

    public static class OreRegisterEvent
    extends Event {
        public final String Name;
        public final abp Ore;

        public OreRegisterEvent(String name, abp ore) {
            this.Name = name;
            this.Ore = ore;
        }
    }
}

