/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class UsernameCache {
    private static Map<UUID, String> map = Maps.newHashMap();
    private static final Charset charset = Charsets.UTF_8;
    private static final File saveFile = new File((File)FMLInjectionData.data()[6], "usernamecache.json");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger log = LogManager.getLogger(UsernameCache.class);

    private UsernameCache() {
    }

    protected static void setUsername(UUID uuid, String username) {
        Preconditions.checkNotNull((Object)uuid);
        Preconditions.checkNotNull((Object)username);
        if (username.equals(map.get(uuid))) {
            return;
        }
        map.put(uuid, username);
        UsernameCache.save();
    }

    protected static boolean removeUsername(UUID uuid) {
        Preconditions.checkNotNull((Object)uuid);
        if (map.remove(uuid) != null) {
            UsernameCache.save();
            return true;
        }
        return false;
    }

    @Nullable
    public static String getLastKnownUsername(UUID uuid) {
        Preconditions.checkNotNull((Object)uuid);
        return map.get(uuid);
    }

    public static boolean containsUUID(UUID uuid) {
        Preconditions.checkNotNull((Object)uuid);
        return map.containsKey(uuid);
    }

    public static Map<UUID, String> getMap() {
        return ImmutableMap.copyOf(map);
    }

    protected static void save() {
        new SaveThread(gson.toJson(map)).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void load() {
        if (!saveFile.exists()) {
            return;
        }
        try {
            String json = Files.toString((File)saveFile, (Charset)charset);
            Type type = new TypeToken<Map<UUID, String>>(){}.getType();
            map = (Map)gson.fromJson(json, type);
        }
        catch (JsonSyntaxException e) {
            log.error("Could not parse username cache file as valid json, deleting file", (Throwable)e);
            saveFile.delete();
        }
        catch (IOException e) {
            log.error("Failed to read username cache file from disk, deleting file", (Throwable)e);
            saveFile.delete();
        }
        finally {
            if (map == null) {
                map = Maps.newHashMap();
            }
        }
    }

    private static class SaveThread
    extends Thread {
        private final String data;

        public SaveThread(String data) {
            this.data = data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                File file = saveFile;
                synchronized (file) {
                    Files.write((CharSequence)this.data, (File)saveFile, (Charset)charset);
                }
            }
            catch (IOException e) {
                log.error("Failed to save username cache to file!", (Throwable)e);
            }
        }
    }
}

