/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.network;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public abstract class ForgeMessage {
    abstract void toBytes(ByteBuf var1);

    abstract void fromBytes(ByteBuf var1);

    public static class FluidIdMapMessage
    extends ForgeMessage {
        BiMap<String, Integer> fluidIds = HashBiMap.create();

        @Override
        void toBytes(ByteBuf bytes) {
            Map<String, Integer> ids = FluidRegistry.getRegisteredFluidIDs();
            bytes.writeInt(ids.size());
            for (Map.Entry<String, Integer> entry : ids.entrySet()) {
                ByteBufUtils.writeUTF8String(bytes, entry.getKey());
                bytes.writeInt(entry.getValue().intValue());
            }
        }

        @Override
        void fromBytes(ByteBuf bytes) {
            int listSize = bytes.readInt();
            for (int i = 0; i < listSize; ++i) {
                String fluidName = ByteBufUtils.readUTF8String(bytes);
                int fluidId = bytes.readInt();
                this.fluidIds.put((Object)fluidName, (Object)fluidId);
            }
        }
    }

    public static class DimensionRegisterMessage
    extends ForgeMessage {
        int dimensionId;
        int providerId;

        public DimensionRegisterMessage() {
        }

        public DimensionRegisterMessage(int dimensionId, int providerId) {
            this.dimensionId = dimensionId;
            this.providerId = providerId;
        }

        @Override
        void toBytes(ByteBuf bytes) {
            bytes.writeInt(this.dimensionId);
            bytes.writeInt(this.providerId);
        }

        @Override
        void fromBytes(ByteBuf bytes) {
            this.dimensionId = bytes.readInt();
            this.providerId = bytes.readInt();
        }
    }
}

