/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.eventhandler;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.IEventListener;

public class ListenerList {
    private static ImmutableList<ListenerList> allLists = ImmutableList.of();
    private static int maxSize = 0;
    private ListenerList parent;
    private ListenerListInst[] lists = new ListenerListInst[0];

    public ListenerList() {
        this(null);
    }

    public ListenerList(ListenerList parent) {
        this.parent = parent;
        ListenerList.extendMasterList(this);
        this.resizeLists(maxSize);
    }

    private static synchronized void extendMasterList(ListenerList inst) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(allLists);
        builder.add((Object)inst);
        allLists = builder.build();
    }

    public static void resize(int max) {
        if (max <= maxSize) {
            return;
        }
        for (ListenerList list : allLists) {
            list.resizeLists(max);
        }
        maxSize = max;
    }

    public void resizeLists(int max) {
        int x2;
        if (this.parent != null) {
            this.parent.resizeLists(max);
        }
        if (this.lists.length >= max) {
            return;
        }
        ListenerListInst[] newList = new ListenerListInst[max];
        for (x2 = 0; x2 < this.lists.length; ++x2) {
            newList[x2] = this.lists[x2];
        }
        while (x2 < max) {
            newList[x2] = this.parent != null ? new ListenerListInst(this.parent.getInstance(x2)) : new ListenerListInst();
            ++x2;
        }
        this.lists = newList;
    }

    public static void clearBusID(int id2) {
        for (ListenerList list : allLists) {
            list.lists[id2].dispose();
        }
    }

    protected ListenerListInst getInstance(int id2) {
        return this.lists[id2];
    }

    public IEventListener[] getListeners(int id2) {
        return this.lists[id2].getListeners();
    }

    public void register(int id2, EventPriority priority, IEventListener listener) {
        this.lists[id2].register(priority, listener);
    }

    public void unregister(int id2, IEventListener listener) {
        this.lists[id2].unregister(listener);
    }

    public static void unregisterAll(int id2, IEventListener listener) {
        for (ListenerList list : allLists) {
            list.unregister(id2, listener);
        }
    }

    private class ListenerListInst {
        private boolean rebuild = true;
        private IEventListener[] listeners;
        private ArrayList<ArrayList<IEventListener>> priorities;
        private ListenerListInst parent;

        private ListenerListInst() {
            int count = EventPriority.values().length;
            this.priorities = new ArrayList(count);
            for (int x2 = 0; x2 < count; ++x2) {
                this.priorities.add(new ArrayList());
            }
        }

        public void dispose() {
            for (ArrayList<IEventListener> listeners : this.priorities) {
                listeners.clear();
            }
            this.priorities.clear();
            this.parent = null;
            this.listeners = null;
        }

        private ListenerListInst(ListenerListInst parent) {
            this();
            this.parent = parent;
        }

        public ArrayList<IEventListener> getListeners(EventPriority priority) {
            ArrayList<IEventListener> ret = new ArrayList<IEventListener>((Collection)this.priorities.get(priority.ordinal()));
            if (this.parent != null) {
                ret.addAll(this.parent.getListeners(priority));
            }
            return ret;
        }

        public IEventListener[] getListeners() {
            if (this.shouldRebuild()) {
                this.buildCache();
            }
            return this.listeners;
        }

        protected boolean shouldRebuild() {
            return this.rebuild || this.parent != null && this.parent.shouldRebuild();
        }

        private void buildCache() {
            if (this.parent != null && this.parent.shouldRebuild()) {
                this.parent.buildCache();
            }
            ArrayList<IEventListener> ret = new ArrayList<IEventListener>();
            for (EventPriority value : EventPriority.values()) {
                ArrayList<IEventListener> listeners = this.getListeners(value);
                if (listeners.size() <= 0) continue;
                ret.add(value);
                ret.addAll(listeners);
            }
            this.listeners = ret.toArray(new IEventListener[ret.size()]);
            this.rebuild = false;
        }

        public void register(EventPriority priority, IEventListener listener) {
            this.priorities.get(priority.ordinal()).add(listener);
            this.rebuild = true;
        }

        public void unregister(IEventListener listener) {
            for (ArrayList<IEventListener> list : this.priorities) {
                if (!list.remove(listener)) continue;
                this.rebuild = true;
            }
        }
    }
}

