/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import java.lang.ref.WeakReference;
import java.text.DecimalFormat;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.server.ForgeTimeTracker;

public class ForgeCommand
extends z {
    private static final DecimalFormat timeFormatter = new DecimalFormat("########0.000");
    private WeakReference<MinecraftServer> server;

    public ForgeCommand(MinecraftServer server) {
        this.server = new WeakReference<MinecraftServer>(server);
    }

    public String c() {
        return "forge";
    }

    public String c(ae icommandsender) {
        return "commands.forge.usage";
    }

    public int a() {
        return 2;
    }

    public void a(ae sender, String[] args) throws di {
        if (args.length == 0) {
            throw new dp("commands.forge.usage", new Object[0]);
        }
        if ("help".equals(args[0])) {
            throw new dp("commands.forge.usage", new Object[0]);
        }
        if ("tps".equals(args[0])) {
            this.displayTPS(sender, args);
        } else if ("tpslog".equals(args[0])) {
            this.doTPSLog(sender, args);
        } else if ("track".equals(args[0])) {
            this.handleTracking(sender, args);
        } else {
            throw new dp("commands.forge.usage", new Object[0]);
        }
    }

    private void handleTracking(ae sender, String[] args) throws di {
        if (args.length != 3) {
            throw new dp("commands.forge.usage.tracking", new Object[0]);
        }
        String type = args[1];
        int duration = ForgeCommand.a((String)args[2], (int)1, (int)60);
        if (!"te".equals(type)) {
            throw new dp("commands.forge.usage.tracking", new Object[0]);
        }
        this.doTurnOnTileEntityTracking(sender, duration);
    }

    private void doTurnOnTileEntityTracking(ae sender, int duration) {
        ForgeTimeTracker.tileEntityTrackingDuration = duration;
        ForgeTimeTracker.tileEntityTracking = true;
        sender.a((ho)new hz("commands.forge.tracking.te.enabled", new Object[]{duration}));
    }

    private void doTPSLog(ae sender, String[] args) {
    }

    private void displayTPS(ae sender, String[] args) throws di {
        int dim = 0;
        boolean summary = true;
        if (args.length > 1) {
            dim = ForgeCommand.a((String)args[1]);
            summary = false;
        }
        if (summary) {
            for (Integer dimId : DimensionManager.getIDs()) {
                double worldTickTime = (double)ForgeCommand.mean((long[])this.getServer().worldTickTimes.get(dimId)) * 1.0E-6;
                double worldTPS = Math.min(1000.0 / worldTickTime, 20.0);
                sender.a((ho)new hz("commands.forge.tps.summary", new Object[]{String.format("Dim %d", dimId), timeFormatter.format(worldTickTime), timeFormatter.format(worldTPS)}));
            }
            double meanTickTime = (double)ForgeCommand.mean(this.getServer().g) * 1.0E-6;
            double meanTPS = Math.min(1000.0 / meanTickTime, 20.0);
            sender.a((ho)new hz("commands.forge.tps.summary", new Object[]{"Overall", timeFormatter.format(meanTickTime), timeFormatter.format(meanTPS)}));
        } else {
            double worldTickTime = (double)ForgeCommand.mean((long[])this.getServer().worldTickTimes.get(dim)) * 1.0E-6;
            double worldTPS = Math.min(1000.0 / worldTickTime, 20.0);
            sender.a((ho)new hz("commands.forge.tps.summary", new Object[]{String.format("Dim %d", dim), timeFormatter.format(worldTickTime), timeFormatter.format(worldTPS)}));
        }
    }

    private static long mean(long[] values) {
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }

    private MinecraftServer getServer() {
        return (MinecraftServer)this.server.get();
    }
}

