/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.client.model.BlockStateLoader;
import net.minecraftforge.fml.common.FMLLog;

public class ForgeBlockStateV1
extends BlockStateLoader.Marker {
    Variant defaults;
    Multimap<String, Variant> variants = HashMultimap.create();

    public static class Variant {
        public static final Object SET_VALUE = new Object();
        private oa model = null;
        private boolean modelSet = false;
        private Optional<cxf> rotation = Optional.absent();
        private Optional<Boolean> uvLock = Optional.absent();
        private Optional<Integer> weight = Optional.absent();
        private Map<String, String> textures = Maps.newHashMap();
        private Map<String, List<Variant>> submodels = Maps.newHashMap();
        private Map<String, Object> simpleSubmodels = Maps.newHashMap();
        private Map<String, String> customData = Maps.newHashMap();

        private Variant() {
        }

        private Variant(Variant other) {
            this.model = other.model;
            this.modelSet = other.modelSet;
            this.rotation = other.rotation;
            this.uvLock = other.uvLock;
            this.weight = other.weight;
            this.textures.putAll(other.textures);
            this.submodels.putAll(other.submodels);
            this.simpleSubmodels.putAll(other.simpleSubmodels);
            this.customData.putAll(other.customData);
        }

        Variant sync(Variant parent) {
            if (!this.modelSet) {
                this.model = parent.model;
            }
            if (!this.rotation.isPresent()) {
                this.rotation = parent.rotation;
            }
            if (!this.uvLock.isPresent()) {
                this.uvLock = parent.uvLock;
            }
            if (!this.weight.isPresent()) {
                this.weight = parent.weight;
            }
            for (Map.Entry<String, String> entry : parent.textures.entrySet()) {
                if (this.textures.containsKey(entry.getKey())) continue;
                this.textures.put(entry.getKey(), entry.getValue());
            }
            this.mergeModelPartVariants(this.submodels, parent.submodels);
            for (Map.Entry<String, Object> entry : parent.simpleSubmodels.entrySet()) {
                if (this.simpleSubmodels.containsKey(entry.getKey())) continue;
                this.simpleSubmodels.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : parent.customData.entrySet()) {
                if (this.customData.containsKey(entry.getKey())) continue;
                this.customData.put(entry.getKey(), (String)entry.getValue());
            }
            return this;
        }

        Map<String, List<Variant>> mergeModelPartVariants(Map<String, List<Variant>> output, Map<String, List<Variant>> input) {
            for (Map.Entry<String, List<Variant>> e : input.entrySet()) {
                String key = e.getKey();
                if (output.containsKey(key)) continue;
                List<Variant> variants = e.getValue();
                if (variants != null) {
                    ArrayList newVariants = Lists.newArrayListWithCapacity((int)variants.size());
                    for (Variant v : variants) {
                        newVariants.add(new Variant(v));
                    }
                    output.put(key, newVariants);
                    continue;
                }
                output.put(key, variants);
            }
            return output;
        }

        protected BlockStateLoader.SubModel asGenericSubModel() {
            return new BlockStateLoader.SubModel((cxf)this.rotation.or((Object)cxf.a), (Boolean)this.uvLock.or((Object)false), this.getTextures(), this.model, this.getCustomData());
        }

        public ImmutableMap<String, BlockStateLoader.SubModel> getOnlyPartsVariant() {
            if (this.submodels.size() > 0) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry<String, List<Variant>> entry : this.submodels.entrySet()) {
                    List<Variant> part = entry.getValue();
                    if (part == null) continue;
                    if (part.size() == 1) {
                        builder.put((Object)entry.getKey(), (Object)part.get(0).asGenericSubModel());
                        continue;
                    }
                    throw new RuntimeException("Something attempted to get the list of submodels for a variant with model \"" + this.model + "\", when this variant " + "contains multiple variants for submodel " + entry.getKey());
                }
                return builder.build();
            }
            return ImmutableMap.of();
        }

        public oa getModel() {
            return this.model;
        }

        public boolean isModelSet() {
            return this.modelSet;
        }

        public Optional<cxf> getRotation() {
            return this.rotation;
        }

        public Optional<Boolean> getUvLock() {
            return this.uvLock;
        }

        public Optional<Integer> getWeight() {
            return this.weight;
        }

        public ImmutableMap<String, String> getTextures() {
            return ImmutableMap.copyOf(this.textures);
        }

        public ImmutableMap<String, List<Variant>> getSubmodels() {
            return ImmutableMap.copyOf(this.submodels);
        }

        public ImmutableMap<String, String> getCustomData() {
            return ImmutableMap.copyOf(this.customData);
        }

        public static class Deserializer
        implements JsonDeserializer<Variant> {
            static Deserializer INSTANCE = new Deserializer();
            public String simpleSubmodelKey = null;

            protected oa getBlockLocation(String location) {
                oa tmp = new oa(location);
                return new oa(tmp.b(), "block/" + tmp.a());
            }

            private void throwIfNestedSubmodels(Variant submodel) {
                if (submodel.submodels.size() > 0) {
                    throw new UnsupportedOperationException("Forge BlockStateLoader V1 does not support nested submodels.");
                }
            }

            public Variant deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                Variant ret = new Variant();
                JsonObject json = element.getAsJsonObject();
                if (json.has("model")) {
                    if (json.get("model").isJsonNull()) {
                        ret.model = null;
                    } else {
                        ret.model = this.getBlockLocation(uh.h((JsonObject)json, (String)"model"));
                    }
                    ret.modelSet = true;
                }
                if (json.has("textures")) {
                    for (Map.Entry e : json.get("textures").getAsJsonObject().entrySet()) {
                        if (((JsonElement)e.getValue()).isJsonNull()) {
                            ret.textures.put(e.getKey(), null);
                            continue;
                        }
                        ret.textures.put(e.getKey(), ((JsonElement)e.getValue()).getAsString());
                    }
                }
                if (json.has("x") || json.has("y")) {
                    int x2 = uh.a((JsonObject)json, (String)"x", (int)0);
                    int y = uh.a((JsonObject)json, (String)"y", (int)0);
                    ret.rotation = Optional.of((Object)cxf.a((int)x2, (int)y));
                    if (ret.rotation == null) {
                        throw new JsonParseException("Invalid BlockModelRotation x: " + x2 + " y: " + y);
                    }
                }
                if (json.has("uvlock")) {
                    ret.uvLock = Optional.of((Object)uh.i((JsonObject)json, (String)"uvlock"));
                }
                if (json.has("weight")) {
                    ret.weight = Optional.of((Object)uh.m((JsonObject)json, (String)"weight"));
                }
                if (json.has("submodel")) {
                    JsonElement submodels = json.get("submodel");
                    if (submodels.isJsonPrimitive()) {
                        if (this.simpleSubmodelKey == null) {
                            throw new RuntimeException("Attempted to use a simple submodel declaration outside a valid state variant declaration.");
                        }
                        String key = this.simpleSubmodelKey;
                        this.simpleSubmodelKey = null;
                        ret.model = this.getBlockLocation(submodels.getAsString());
                        ret.modelSet = true;
                        Variant dummyVar = new Variant();
                        dummyVar.submodels.put(key, Collections.singletonList(ret));
                        dummyVar.simpleSubmodels = Collections.singletonMap(key, SET_VALUE);
                        return dummyVar;
                    }
                    this.simpleSubmodelKey = null;
                    for (Map.Entry submodel : submodels.getAsJsonObject().entrySet()) {
                        List<Object> submodelVariants;
                        JsonElement varEl = (JsonElement)submodel.getValue();
                        if (varEl.isJsonArray()) {
                            submodelVariants = Lists.newArrayList();
                            for (JsonElement e : varEl.getAsJsonArray()) {
                                submodelVariants.add((Variant)context.deserialize(e, Variant.class));
                            }
                        } else {
                            submodelVariants = varEl.isJsonNull() ? null : Collections.singletonList((Variant)context.deserialize(varEl, Variant.class));
                        }
                        if (submodelVariants != null) {
                            for (Variant part : submodelVariants) {
                                this.throwIfNestedSubmodels(part);
                            }
                        }
                        ret.submodels.put(submodel.getKey(), submodelVariants);
                        ret.simpleSubmodels.put(submodel.getKey(), null);
                    }
                }
                if (json.has("custom")) {
                    for (Map.Entry e : json.get("custom").getAsJsonObject().entrySet()) {
                        if (((JsonElement)e.getValue()).isJsonNull()) {
                            ret.customData.put(e.getKey(), null);
                            continue;
                        }
                        ret.customData.put(e.getKey(), ((JsonElement)e.getValue()).toString());
                    }
                }
                this.simpleSubmodelKey = null;
                return ret;
            }
        }
    }

    public static class Deserializer
    implements JsonDeserializer<ForgeBlockStateV1> {
        static Deserializer INSTANCE = new Deserializer();

        public ForgeBlockStateV1 deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = element.getAsJsonObject();
            ForgeBlockStateV1 ret = new ForgeBlockStateV1();
            ret.forge_marker = uh.m((JsonObject)json, (String)"forge_marker");
            if (json.has("defaults")) {
                ret.defaults = (Variant)context.deserialize(json.get("defaults"), Variant.class);
                if (ret.defaults.simpleSubmodels.size() > 0) {
                    throw new RuntimeException("\"defaults\" variant cannot contain a simple \"submodel\" definition.");
                }
            }
            HashMap condensed = Maps.newHashMap();
            HashMultimap specified = HashMultimap.create();
            for (Map.Entry e : uh.s((JsonObject)json, (String)"variants").entrySet()) {
                if (((JsonElement)e.getValue()).isJsonArray()) {
                    for (JsonElement a2 : ((JsonElement)e.getValue()).getAsJsonArray()) {
                        Variant.Deserializer.INSTANCE.simpleSubmodelKey = (String)e.getKey();
                        specified.put(e.getKey(), (Object)((Variant)context.deserialize(a2, Variant.class)));
                    }
                    continue;
                }
                JsonObject obj = ((JsonElement)e.getValue()).getAsJsonObject();
                if (((JsonElement)((Map.Entry)obj.entrySet().iterator().next()).getValue()).isJsonObject()) {
                    HashMap subs = Maps.newHashMap();
                    condensed.put(e.getKey(), subs);
                    for (Map.Entry entry : ((JsonElement)e.getValue()).getAsJsonObject().entrySet()) {
                        Variant.Deserializer.INSTANCE.simpleSubmodelKey = (String)e.getKey() + "=" + (String)entry.getKey();
                        subs.put(entry.getKey(), (Variant)context.deserialize((JsonElement)entry.getValue(), Variant.class));
                    }
                    continue;
                }
                Variant.Deserializer.INSTANCE.simpleSubmodelKey = (String)e.getKey();
                specified.put(e.getKey(), (Object)((Variant)context.deserialize((JsonElement)e.getValue(), Variant.class)));
            }
            Multimap<String, Variant> permutations = this.getPermutations(condensed);
            for (Map.Entry e : specified.asMap().entrySet()) {
                Collection baseVars = permutations.get(e.getKey());
                ArrayList addVars = Lists.newArrayList();
                for (Variant specVar : (Collection)e.getValue()) {
                    if (!baseVars.isEmpty()) {
                        for (Variant variant : baseVars) {
                            addVars.add(new Variant(specVar).sync(variant));
                        }
                        continue;
                    }
                    addVars.add(specVar);
                }
                baseVars.clear();
                baseVars.addAll(addVars);
            }
            for (Map.Entry e : permutations.entries()) {
                Variant v = (Variant)e.getValue();
                if (ret.defaults != null) {
                    v.sync(ret.defaults);
                    for (Map.Entry entry : v.simpleSubmodels.entrySet()) {
                        if (entry.getValue() == null) continue;
                        if (!v.submodels.containsKey(entry.getKey())) {
                            throw new RuntimeException("This should never happen! Simple submodel is not contained in the submodel map!");
                        }
                        List partList = (List)v.submodels.get(entry.getKey());
                        if (partList.size() > 1) {
                            throw new RuntimeException("This should never happen! Simple submodel has multiple variants!");
                        }
                        Variant part = (Variant)partList.get(0);
                        Optional optional = part.rotation;
                        part.sync(v);
                        part.simpleSubmodels.clear();
                        part.rotation = optional;
                    }
                }
                if (v.textures != null) {
                    for (Map.Entry entry : v.textures.entrySet()) {
                        if (entry.getValue() == null || ((String)entry.getValue()).charAt(0) != '#') continue;
                        String value = (String)v.textures.get(((String)entry.getValue()).substring(1));
                        if (value == null) {
                            FMLLog.severe("Could not resolve texture name \"" + (String)entry.getValue() + "\" for permutation \"" + (String)e.getKey() + "\"", new Object[0]);
                            for (Map.Entry entry2 : v.textures.entrySet()) {
                                FMLLog.severe((String)entry2.getKey() + "=" + (String)entry2.getValue(), new Object[0]);
                            }
                            throw new JsonParseException("Could not resolve texture name \"" + (String)entry.getValue() + "\" for permutation \"" + (String)e.getKey() + "\"");
                        }
                        v.textures.put(entry.getKey(), value);
                    }
                    for (List list : v.submodels.values()) {
                        for (Variant partVar : list) {
                            for (Map.Entry texEntry : v.textures.entrySet()) {
                                if (partVar.textures.containsKey(texEntry.getKey())) continue;
                                partVar.textures.put(texEntry.getKey(), texEntry.getValue());
                            }
                        }
                    }
                }
                if (!v.submodels.isEmpty()) {
                    ret.variants.putAll(e.getKey(), this.getSubmodelPermutations(v, v.submodels));
                    continue;
                }
                ret.variants.put(e.getKey(), (Object)v);
            }
            return ret;
        }

        private Multimap<String, Variant> getPermutations(List<String> sorted, Map<String, Map<String, Variant>> base, int depth, String prefix, Multimap<String, Variant> ret, Variant parent) {
            if (depth == sorted.size()) {
                if (parent != null) {
                    ret.put((Object)prefix, (Object)parent);
                }
                return ret;
            }
            String name = sorted.get(depth);
            for (Map.Entry<String, Variant> e : base.get(name).entrySet()) {
                Variant newHead = parent == null ? new Variant(e.getValue()) : new Variant(parent).sync(e.getValue());
                this.getPermutations(sorted, base, depth + 1, prefix + (depth == 0 ? "" : ",") + name + "=" + e.getKey(), ret, newHead);
            }
            return ret;
        }

        private Multimap<String, Variant> getPermutations(Map<String, Map<String, Variant>> base) {
            ArrayList sorted = Lists.newArrayList(base.keySet());
            Collections.sort(sorted);
            return this.getPermutations(sorted, base, 0, "", (Multimap<String, Variant>)HashMultimap.create(), null);
        }

        private List<Variant> getSubmodelPermutations(Variant baseVar, List<String> sorted, Map<String, List<Variant>> map, int depth, Map<String, Variant> parts, List<Variant> ret) {
            if (depth >= sorted.size()) {
                Variant add = new Variant(baseVar);
                for (Map.Entry<String, Variant> part : parts.entrySet()) {
                    add.submodels.put(part.getKey(), Collections.singletonList(part.getValue()));
                }
                ret.add(add);
                return ret;
            }
            String name = sorted.get(depth);
            List<Variant> vars = map.get(sorted.get(depth));
            if (vars != null) {
                for (Variant v : vars) {
                    if (v == null) continue;
                    parts.put(name, v);
                    this.getSubmodelPermutations(baseVar, sorted, map, depth + 1, parts, ret);
                    parts.remove(name);
                }
            } else {
                this.getSubmodelPermutations(baseVar, sorted, map, depth + 1, parts, ret);
            }
            return ret;
        }

        private List<Variant> getSubmodelPermutations(Variant baseVar, Map<String, List<Variant>> variants) {
            ArrayList sorted = Lists.newArrayList(variants.keySet());
            Collections.sort(sorted);
            return this.getSubmodelPermutations(baseVar, sorted, variants, 0, new HashMap<String, Variant>(), new ArrayList<Variant>());
        }
    }
}

