/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockFluidBase
extends atr
implements IFluidBlock {
    protected static final Map<atr, Boolean> defaultDisplacements = Maps.newHashMap();
    protected Map<atr, Boolean> displacements = Maps.newHashMap();
    public static final bew LEVEL;
    protected int quantaPerBlock = 8;
    protected float quantaPerBlockFloat = 8.0f;
    protected int density = 1;
    protected int densityDir = -1;
    protected int temperature = 295;
    protected int tickRate = 20;
    protected aql renderLayer = aql.d;
    protected int maxScaledLight = 0;
    protected final String fluidName;
    protected final Fluid definedFluid;

    public BlockFluidBase(Fluid fluid, bof material) {
        super(material);
        this.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.a(true);
        this.J();
        this.fluidName = fluid.getName();
        this.density = fluid.density;
        this.temperature = fluid.temperature;
        this.maxScaledLight = fluid.luminosity;
        this.tickRate = fluid.viscosity / 200;
        this.densityDir = fluid.density > 0 ? -1 : 1;
        fluid.setBlock(this);
        this.definedFluid = fluid;
        this.displacements.putAll(defaultDisplacements);
        this.j(this.L.b().a((bex)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected bed e() {
        return new bed((atr)this, new bex[]{LEVEL});
    }

    public int c(bec state) {
        return (Integer)state.b((bex)LEVEL);
    }

    public BlockFluidBase setQuantaPerBlock(int quantaPerBlock) {
        if (quantaPerBlock > 16 || quantaPerBlock < 1) {
            quantaPerBlock = 8;
        }
        this.quantaPerBlock = quantaPerBlock;
        this.quantaPerBlockFloat = quantaPerBlock;
        return this;
    }

    public BlockFluidBase setDensity(int density) {
        if (density == 0) {
            density = 1;
        }
        this.density = density;
        this.densityDir = density > 0 ? -1 : 1;
        return this;
    }

    public BlockFluidBase setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public BlockFluidBase setTickRate(int tickRate) {
        if (tickRate <= 0) {
            tickRate = 20;
        }
        this.tickRate = tickRate;
        return this;
    }

    public BlockFluidBase setRenderLayer(aql renderLayer) {
        this.renderLayer = renderLayer;
        return this;
    }

    public BlockFluidBase setMaxScaledLight(int maxScaledLight) {
        this.maxScaledLight = maxScaledLight;
        return this;
    }

    public boolean canDisplace(ard world, dt pos) {
        if (world.d(pos)) {
            return true;
        }
        atr block = world.p(pos).c();
        if (block == this) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            return this.displacements.get(block);
        }
        bof material = block.r();
        if (material.c() || material == bof.E) {
            return false;
        }
        int density = BlockFluidBase.getDensity(world, pos);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    public boolean displaceIfPossible(aqu world, dt pos) {
        if (world.d(pos)) {
            return true;
        }
        bec state = world.p(pos);
        atr block = state.c();
        if (block == this) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            if (this.displacements.get(block).booleanValue()) {
                block.b(world, pos, state, 0);
                return true;
            }
            return false;
        }
        bof material = block.r();
        if (material.c() || material == bof.E) {
            return false;
        }
        int density = BlockFluidBase.getDensity((ard)world, pos);
        if (density == Integer.MAX_VALUE) {
            block.b(world, pos, state, 0);
            return true;
        }
        return this.density > density;
    }

    public abstract int getQuantaValue(ard var1, dt var2);

    public abstract boolean a(bec var1, boolean var2);

    public abstract int getMaxRenderHeightMeta();

    public void c(aqu world, dt pos, bec state) {
        world.a(pos, (atr)this, this.tickRate);
    }

    public void a(aqu world, dt pos, bec state, atr neighborBlock) {
        world.a(pos, (atr)this, this.tickRate);
    }

    public boolean M() {
        return false;
    }

    public boolean b(ard world, dt pos) {
        return true;
    }

    public brt a(aqu world, dt pos, bec state) {
        return null;
    }

    public alq a(bec state, Random rand, int fortune) {
        return null;
    }

    public int a(Random par1Random) {
        return 0;
    }

    public int a(aqu world) {
        return this.tickRate;
    }

    public brw a(aqu world, dt pos, wv entity, brw vec) {
        if (this.densityDir > 0) {
            return vec;
        }
        brw vec_flow = this.getFlowVector((ard)world, pos);
        return vec.b(vec_flow.a * (double)(this.quantaPerBlock * 4), vec_flow.b * (double)(this.quantaPerBlock * 4), vec_flow.c * (double)(this.quantaPerBlock * 4));
    }

    public int getLightValue(ard world, dt pos) {
        if (this.maxScaledLight == 0) {
            return super.getLightValue(world, pos);
        }
        int data = (Integer)world.p(pos).b((bex)LEVEL);
        return (int)((float)data / this.quantaPerBlockFloat * (float)this.maxScaledLight);
    }

    public int b() {
        return FluidRegistry.renderIdFluid;
    }

    public boolean c() {
        return false;
    }

    public boolean d() {
        return false;
    }

    public int c(ard world, dt pos) {
        int lightThis = world.b(pos, 0);
        int lightUp = world.b(pos.a(), 0);
        int lightThisBase = lightThis & 0xFF;
        int lightUpBase = lightUp & 0xFF;
        int lightThisExt = lightThis >> 16 & 0xFF;
        int lightUpExt = lightUp >> 16 & 0xFF;
        return (lightThisBase > lightUpBase ? lightThisBase : lightUpBase) | (lightThisExt > lightUpExt ? lightThisExt : lightUpExt) << 16;
    }

    @SideOnly(value=Side.CLIENT)
    public aql k() {
        return this.renderLayer;
    }

    public boolean a(ard world, dt pos, ej side) {
        atr block = world.p(pos).c();
        if (block != this) {
            return !block.c();
        }
        return block.r() == this.r() ? false : super.a(world, pos, side);
    }

    public static final int getDensity(ard world, dt pos) {
        atr block = world.p(pos).c();
        if (!(block instanceof BlockFluidBase)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockFluidBase)block).density;
    }

    public static final int getTemperature(ard world, dt pos) {
        atr block = world.p(pos).c();
        if (!(block instanceof BlockFluidBase)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockFluidBase)block).temperature;
    }

    public static double getFlowDirection(ard world, dt pos) {
        atr block = world.p(pos).c();
        if (!block.r().d()) {
            return -1000.0;
        }
        brw vec = ((BlockFluidBase)block).getFlowVector(world, pos);
        return vec.a == 0.0 && vec.c == 0.0 ? -1000.0 : Math.atan2(vec.c, vec.a) - 1.5707963267948966;
    }

    public final int getQuantaValueBelow(ard world, dt pos, int belowThis) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        if (quantaRemaining >= belowThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final int getQuantaValueAbove(ard world, dt pos, int aboveThis) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        if (quantaRemaining <= aboveThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final float getQuantaPercentage(ard world, dt pos) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        return (float)quantaRemaining / this.quantaPerBlockFloat;
    }

    public brw getFlowVector(ard world, dt pos) {
        brw vec = new brw(0.0, 0.0, 0.0);
        int decay = this.quantaPerBlock - this.getQuantaValue(world, pos);
        for (int side = 0; side < 4; ++side) {
            int power;
            int x2 = pos.n();
            int z2 = pos.p();
            switch (side) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    --z2;
                    break;
                }
                case 2: {
                    ++x2;
                    break;
                }
                case 3: {
                    ++z2;
                }
            }
            dt pos2 = new dt(x2, pos.o(), z2);
            int otherDecay = this.quantaPerBlock - this.getQuantaValue(world, pos2);
            if (otherDecay >= this.quantaPerBlock) {
                if (world.p(pos2).c().r().c() || (otherDecay = this.quantaPerBlock - this.getQuantaValue(world, pos2.b())) < 0) continue;
                power = otherDecay - (decay - this.quantaPerBlock);
                vec = vec.b((double)((pos2.n() - pos.n()) * power), 0.0, (double)((pos2.p() - pos.p()) * power));
                continue;
            }
            if (otherDecay < 0) continue;
            power = otherDecay - decay;
            vec = vec.b((double)((pos2.n() - pos.n()) * power), 0.0, (double)((pos2.p() - pos.p()) * power));
        }
        if (world.p(pos.a()).c() == this) {
            boolean flag;
            boolean bl = flag = this.b(world, pos.a(0, 0, -1), ej.c) || this.b(world, pos.a(0, 0, 1), ej.d) || this.b(world, pos.a(-1, 0, 0), ej.e) || this.b(world, pos.a(1, 0, 0), ej.f) || this.b(world, pos.a(0, 1, -1), ej.c) || this.b(world, pos.a(0, 1, 1), ej.d) || this.b(world, pos.a(-1, 1, 0), ej.e) || this.b(world, pos.a(1, 1, 0), ej.f);
            if (flag) {
                vec = vec.a().b(0.0, -6.0, 0.0);
            }
        }
        vec = vec.a();
        return vec;
    }

    @Override
    public Fluid getFluid() {
        return FluidRegistry.getFluid(this.fluidName);
    }

    @Override
    public float getFilledPercentage(aqu world, dt pos) {
        int quantaRemaining = this.getQuantaValue((ard)world, pos) + 1;
        float remaining = (float)quantaRemaining / this.quantaPerBlockFloat;
        if (remaining > 1.0f) {
            remaining = 1.0f;
        }
        return remaining * (float)(this.density > 0 ? 1 : -1);
    }

    static {
        defaultDisplacements.put(aty.ao, false);
        defaultDisplacements.put(aty.ap, false);
        defaultDisplacements.put(aty.aq, false);
        defaultDisplacements.put(aty.ar, false);
        defaultDisplacements.put(aty.as, false);
        defaultDisplacements.put(aty.at, false);
        defaultDisplacements.put(aty.bd, false);
        defaultDisplacements.put(aty.cw, false);
        defaultDisplacements.put(aty.aO, false);
        defaultDisplacements.put(aty.aP, false);
        defaultDisplacements.put(aty.aQ, false);
        defaultDisplacements.put(aty.aR, false);
        defaultDisplacements.put(aty.aS, false);
        defaultDisplacements.put(aty.aT, false);
        defaultDisplacements.put(aty.bz, false);
        defaultDisplacements.put(aty.bo, false);
        defaultDisplacements.put(aty.bp, false);
        defaultDisplacements.put(aty.bq, false);
        defaultDisplacements.put(aty.br, false);
        defaultDisplacements.put(aty.bs, false);
        defaultDisplacements.put(aty.bt, false);
        defaultDisplacements.put(aty.aB, false);
        defaultDisplacements.put(aty.az, false);
        defaultDisplacements.put(aty.ch, false);
        defaultDisplacements.put(aty.ci, false);
        defaultDisplacements.put(aty.au, false);
        defaultDisplacements.put(aty.bi, false);
        defaultDisplacements.put(aty.bj, false);
        defaultDisplacements.put((atr)aty.cH, false);
        defaultDisplacements.put((atr)aty.aY, false);
        defaultDisplacements.put(aty.bF, false);
        defaultDisplacements.put(aty.bZ, false);
        defaultDisplacements.put(aty.cv, false);
        defaultDisplacements.put(aty.cK, false);
        defaultDisplacements.put(aty.cL, false);
        defaultDisplacements.put(aty.ba, false);
        defaultDisplacements.put(aty.aA, false);
        defaultDisplacements.put(aty.an, false);
        defaultDisplacements.put(aty.ax, false);
        defaultDisplacements.put((atr)aty.aM, false);
        LEVEL = bew.a((String)"level", (int)0, (int)15);
    }
}

