/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.Random;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BlockFluidClassic
extends BlockFluidBase {
    protected boolean[] isOptimalFlowDirection = new boolean[4];
    protected int[] flowCost = new int[4];
    protected FluidStack stack;

    public BlockFluidClassic(Fluid fluid, bof material) {
        super(fluid, material);
        this.stack = new FluidStack(fluid, 1000);
    }

    public BlockFluidClassic setFluidStack(FluidStack stack) {
        this.stack = stack;
        return this;
    }

    public BlockFluidClassic setFluidStackAmount(int amount) {
        this.stack.amount = amount;
        return this;
    }

    @Override
    public int getQuantaValue(ard world, dt pos) {
        bec state = world.p(pos);
        if (state.c() == aty.a) {
            return 0;
        }
        if (state.c() != this) {
            return -1;
        }
        int quantaRemaining = this.quantaPerBlock - (Integer)state.b((bex)LEVEL);
        return quantaRemaining;
    }

    @Override
    public boolean a(bec state, boolean fullHit) {
        return fullHit && (Integer)state.b((bex)LEVEL) == 0;
    }

    @Override
    public int getMaxRenderHeightMeta() {
        return 0;
    }

    @Override
    public int getLightValue(ard world, dt pos) {
        if (this.maxScaledLight == 0) {
            return super.getLightValue(world, pos);
        }
        int data = this.quantaPerBlock - (Integer)world.p(pos).b((bex)LEVEL) - 1;
        return (int)((float)data / this.quantaPerBlockFloat * (float)this.maxScaledLight);
    }

    public void b(aqu world, dt pos, bec state, Random rand) {
        int quantaRemaining = this.quantaPerBlock - (Integer)state.b((bex)LEVEL);
        int expQuanta = -101;
        if (quantaRemaining < this.quantaPerBlock) {
            if (world.p(pos.a(0, -this.densityDir, 0)).c() == this || world.p(pos.a(-1, -this.densityDir, 0)).c() == this || world.p(pos.a(1, -this.densityDir, 0)).c() == this || world.p(pos.a(0, -this.densityDir, -1)).c() == this || world.p(pos.a(0, -this.densityDir, 1)).c() == this) {
                expQuanta = this.quantaPerBlock - 1;
            } else {
                int maxQuanta = -100;
                maxQuanta = this.getLargerQuanta((ard)world, pos.a(-1, 0, 0), maxQuanta);
                maxQuanta = this.getLargerQuanta((ard)world, pos.a(1, 0, 0), maxQuanta);
                maxQuanta = this.getLargerQuanta((ard)world, pos.a(0, 0, -1), maxQuanta);
                maxQuanta = this.getLargerQuanta((ard)world, pos.a(0, 0, 1), maxQuanta);
                expQuanta = maxQuanta - 1;
            }
            if (expQuanta != quantaRemaining) {
                quantaRemaining = expQuanta;
                if (expQuanta <= 0) {
                    world.g(pos);
                } else {
                    world.a(pos, state.a((bex)LEVEL, (Comparable)Integer.valueOf(this.quantaPerBlock - expQuanta)), 2);
                    world.a(pos, (atr)this, this.tickRate);
                    world.c(pos, (atr)this);
                }
            }
        } else if (quantaRemaining >= this.quantaPerBlock) {
            world.a(pos, this.P(), 2);
        }
        if (this.canDisplace((ard)world, pos.b(this.densityDir))) {
            this.flowIntoBlock(world, pos.b(this.densityDir), 1);
            return;
        }
        int flowMeta = this.quantaPerBlock - quantaRemaining + 1;
        if (flowMeta >= this.quantaPerBlock) {
            return;
        }
        if (this.isSourceBlock((ard)world, pos) || !this.isFlowingVertically((ard)world, pos)) {
            boolean[] flowTo;
            if (world.p(pos.c(this.densityDir)).c() == this) {
                flowMeta = 1;
            }
            if ((flowTo = this.getOptimalFlowDirections(world, pos))[0]) {
                this.flowIntoBlock(world, pos.a(-1, 0, 0), flowMeta);
            }
            if (flowTo[1]) {
                this.flowIntoBlock(world, pos.a(1, 0, 0), flowMeta);
            }
            if (flowTo[2]) {
                this.flowIntoBlock(world, pos.a(0, 0, -1), flowMeta);
            }
            if (flowTo[3]) {
                this.flowIntoBlock(world, pos.a(0, 0, 1), flowMeta);
            }
        }
    }

    public boolean isFlowingVertically(ard world, dt pos) {
        return world.p(pos.b(this.densityDir)).c() == this || world.p(pos).c() == this && this.canFlowInto(world, pos.b(this.densityDir));
    }

    public boolean isSourceBlock(ard world, dt pos) {
        return world.p(pos) == this && (Integer)world.p(pos).b((bex)LEVEL) == 0;
    }

    protected boolean[] getOptimalFlowDirections(aqu world, dt pos) {
        int side;
        for (int side2 = 0; side2 < 4; ++side2) {
            this.flowCost[side2] = 1000;
            dt pos2 = pos;
            switch (side2) {
                case 0: {
                    pos2 = pos2.a(-1, 0, 0);
                    break;
                }
                case 1: {
                    pos2 = pos2.a(1, 0, 0);
                    break;
                }
                case 2: {
                    pos2 = pos2.a(0, 0, -1);
                    break;
                }
                case 3: {
                    pos2 = pos2.a(0, 0, 1);
                }
            }
            if (!this.canFlowInto((ard)world, pos2) || this.isSourceBlock((ard)world, pos2)) continue;
            this.flowCost[side2] = this.canFlowInto((ard)world, pos2.a(0, this.densityDir, 0)) ? 0 : this.calculateFlowCost(world, pos2, 1, side2);
        }
        int min = this.flowCost[0];
        for (side = 1; side < 4; ++side) {
            if (this.flowCost[side] >= min) continue;
            min = this.flowCost[side];
        }
        for (side = 0; side < 4; ++side) {
            this.isOptimalFlowDirection[side] = this.flowCost[side] == min;
        }
        return this.isOptimalFlowDirection;
    }

    protected int calculateFlowCost(aqu world, dt pos, int recurseDepth, int side) {
        int cost = 1000;
        for (int adjSide = 0; adjSide < 4; ++adjSide) {
            int min;
            if (adjSide == 0 && side == 1 || adjSide == 1 && side == 0 || adjSide == 2 && side == 3 || adjSide == 3 && side == 2) continue;
            dt pos2 = pos;
            switch (adjSide) {
                case 0: {
                    pos2 = pos2.a(-1, 0, 0);
                    break;
                }
                case 1: {
                    pos2 = pos2.a(1, 0, 0);
                    break;
                }
                case 2: {
                    pos2 = pos2.a(0, 0, -1);
                    break;
                }
                case 3: {
                    pos2 = pos2.a(0, 0, 1);
                }
            }
            if (!this.canFlowInto((ard)world, pos2) || this.isSourceBlock((ard)world, pos2)) continue;
            if (this.canFlowInto((ard)world, pos2.a(0, this.densityDir, 0))) {
                return recurseDepth;
            }
            if (recurseDepth >= 4 || (min = this.calculateFlowCost(world, pos2, recurseDepth + 1, adjSide)) >= cost) continue;
            cost = min;
        }
        return cost;
    }

    protected void flowIntoBlock(aqu world, dt pos, int meta) {
        if (meta < 0) {
            return;
        }
        if (this.displaceIfPossible(world, pos)) {
            world.a(pos, this.O().b().a((bex)LEVEL, (Comparable)Integer.valueOf(meta)), 3);
        }
    }

    protected boolean canFlowInto(ard world, dt pos) {
        if (world.d(pos)) {
            return true;
        }
        atr block = world.p(pos).c();
        if (block == this) {
            return true;
        }
        if (this.displacements.containsKey(block)) {
            return (Boolean)this.displacements.get(block);
        }
        bof material = block.r();
        if (material.c() || material == bof.h || material == bof.i || material == bof.E) {
            return false;
        }
        int density = BlockFluidClassic.getDensity(world, pos);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    protected int getLargerQuanta(ard world, dt pos, int compare) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        if (quantaRemaining <= 0) {
            return compare;
        }
        return quantaRemaining >= compare ? quantaRemaining : compare;
    }

    @Override
    public FluidStack drain(aqu world, dt pos, boolean doDrain) {
        if (!this.isSourceBlock((ard)world, pos)) {
            return null;
        }
        if (doDrain) {
            world.g(pos);
        }
        return this.stack.copy();
    }

    @Override
    public boolean canDrain(aqu world, dt pos) {
        return this.isSourceBlock((ard)world, pos);
    }
}

