/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import org.apache.logging.log4j.Level;

public abstract class FluidRegistry {
    static int maxID = 0;
    static BiMap<String, Fluid> fluids = HashBiMap.create();
    static BiMap<Fluid, Integer> fluidIDs = HashBiMap.create();
    static BiMap<Integer, String> fluidNames = HashBiMap.create();
    static BiMap<atr, Fluid> fluidBlocks;
    static BiMap<String, Fluid> masterFluidReference;
    static BiMap<String, String> defaultFluidName;
    static Map<Fluid, FluidDelegate> delegates;
    public static final Fluid WATER;
    public static final Fluid LAVA;
    public static int renderIdFluid;

    private FluidRegistry() {
    }

    public static void initFluidIDs(BiMap<Fluid, Integer> newfluidIDs, Set<String> defaultNames) {
        maxID = newfluidIDs.size();
        fluidIDs.clear();
        fluidIDs.putAll(newfluidIDs);
        fluidNames.clear();
        for (Map.Entry e : fluidIDs.entrySet()) {
            fluidNames.put(e.getValue(), (Object)((Fluid)e.getKey()).getName());
        }
        FluidRegistry.loadFluidDefaults(defaultNames);
    }

    private static void loadFluidDefaults(Set<String> defaultNames) {
        if (defaultNames.isEmpty()) {
            defaultNames.addAll(defaultFluidName.values());
        }
        for (String defaultName : defaultNames) {
            Fluid fluid = (Fluid)masterFluidReference.get((Object)defaultName);
            if (fluid == null) {
                String derivedName = defaultName.split(":", 2)[1];
                String localDefault = (String)defaultFluidName.get((Object)derivedName);
                if (localDefault == null) {
                    FMLLog.getLogger().log(Level.ERROR, "The fluid {} (specified as {}) is missing from this instance - it will be removed", new Object[]{derivedName, defaultName});
                    continue;
                }
                fluid = (Fluid)masterFluidReference.get((Object)localDefault);
                FMLLog.getLogger().log(Level.ERROR, "The fluid {} specified as default is not present - it will be reverted to default {}", new Object[]{defaultName, localDefault});
            }
            FMLLog.getLogger().log(Level.DEBUG, "The fluid {} has been selected as the default fluid for {}", new Object[]{defaultName, fluid.getName()});
            Fluid oldFluid = (Fluid)fluids.put((Object)fluid.getName(), (Object)fluid);
            Integer id2 = (Integer)fluidIDs.remove((Object)oldFluid);
            fluidIDs.put((Object)fluid, (Object)id2);
        }
        fluidBlocks = null;
        for (FluidDelegate fd2 : delegates.values()) {
            fd2.rebind();
        }
    }

    public static boolean registerFluid(Fluid fluid) {
        masterFluidReference.put((Object)FluidRegistry.uniqueName(fluid), (Object)fluid);
        delegates.put(fluid, new FluidDelegate(fluid, fluid.getName()));
        if (fluids.containsKey((Object)fluid.getName())) {
            return false;
        }
        fluids.put((Object)fluid.getName(), (Object)fluid);
        fluidIDs.put((Object)fluid, (Object)(++maxID));
        fluidNames.put((Object)maxID, (Object)fluid.getName());
        defaultFluidName.put((Object)fluid.getName(), (Object)FluidRegistry.uniqueName(fluid));
        MinecraftForge.EVENT_BUS.post(new FluidRegisterEvent(fluid.getName(), maxID));
        return true;
    }

    private static String uniqueName(Fluid fluid) {
        ModContainer activeModContainer = Loader.instance().activeModContainer();
        String activeModContainerName = activeModContainer == null ? "minecraft" : activeModContainer.getModId();
        return activeModContainerName + ":" + fluid.getName();
    }

    public static boolean isFluidDefault(Fluid fluid) {
        return fluids.containsValue((Object)fluid);
    }

    public static boolean isFluidRegistered(Fluid fluid) {
        return fluid != null && fluids.containsKey((Object)fluid.getName());
    }

    public static boolean isFluidRegistered(String fluidName) {
        return fluids.containsKey((Object)fluidName);
    }

    public static Fluid getFluid(String fluidName) {
        return (Fluid)fluids.get((Object)fluidName);
    }

    public static Fluid getFluid(int fluidID) {
        return (Fluid)fluidIDs.inverse().get((Object)fluidID);
    }

    public static int getFluidID(Fluid fluid) {
        return (Integer)fluidIDs.get((Object)fluid);
    }

    public static int getFluidID(String fluidName) {
        return (Integer)fluidIDs.get((Object)FluidRegistry.getFluid(fluidName));
    }

    @Deprecated
    public static String getFluidName(int fluidID) {
        return (String)fluidNames.get((Object)fluidID);
    }

    public static String getFluidName(Fluid fluid) {
        return (String)fluids.inverse().get((Object)fluid);
    }

    public static String getFluidName(FluidStack stack) {
        return FluidRegistry.getFluidName(stack.getFluid());
    }

    public static FluidStack getFluidStack(String fluidName, int amount) {
        if (!fluids.containsKey((Object)fluidName)) {
            return null;
        }
        return new FluidStack(FluidRegistry.getFluid(fluidName), amount);
    }

    public static Map<String, Fluid> getRegisteredFluids() {
        return ImmutableMap.copyOf(fluids);
    }

    @Deprecated
    public static Map<String, Integer> getRegisteredFluidIDs() {
        return ImmutableMap.copyOf((Map)fluidNames.inverse());
    }

    public static Map<Fluid, Integer> getRegisteredFluidIDsByFluid() {
        return ImmutableMap.copyOf(fluidIDs);
    }

    public static Fluid lookupFluidForBlock(atr block) {
        if (fluidBlocks == null) {
            HashBiMap tmp = HashBiMap.create();
            for (Fluid fluid : fluids.values()) {
                if (!fluid.canBePlacedInWorld() || fluid.getBlock() == null) continue;
                tmp.put((Object)fluid.getBlock(), (Object)fluid);
            }
            fluidBlocks = tmp;
        }
        return (Fluid)fluidBlocks.get((Object)block);
    }

    public static int getMaxID() {
        return maxID;
    }

    public static String getDefaultFluidName(Fluid key) {
        String name = (String)masterFluidReference.inverse().get((Object)key);
        if (Strings.isNullOrEmpty((String)name)) {
            FMLLog.getLogger().log(Level.ERROR, "The fluid registry is corrupted. A fluid {} {} is not properly registered. The mod that registered this is broken", new Object[]{key.getClass().getName(), key.getName()});
            throw new IllegalStateException("The fluid registry is corrupted");
        }
        return name;
    }

    public static void loadFluidDefaults(fn tag) {
        HashSet defaults = Sets.newHashSet();
        if (tag.b("DefaultFluidList", 9)) {
            FMLLog.getLogger().log(Level.DEBUG, "Loading persistent fluid defaults from world");
            fv tl = tag.c("DefaultFluidList", 8);
            for (int i = 0; i < tl.c(); ++i) {
                defaults.add(tl.f(i));
            }
        } else {
            FMLLog.getLogger().log(Level.DEBUG, "World is missing persistent fluid defaults - using local defaults");
        }
        FluidRegistry.loadFluidDefaults(defaults);
    }

    public static void writeDefaultFluidList(fn forgeData) {
        fv tagList = new fv();
        for (Map.Entry def : fluids.entrySet()) {
            tagList.a((gd)new gc(FluidRegistry.getDefaultFluidName((Fluid)def.getValue())));
        }
        forgeData.a("DefaultFluidList", (gd)tagList);
    }

    public static void validateFluidRegistry() {
        HashSet illegalFluids = Sets.newHashSet();
        for (Fluid f : fluids.values()) {
            if (masterFluidReference.containsValue((Object)f)) continue;
            illegalFluids.add(f);
        }
        if (!illegalFluids.isEmpty()) {
            FMLLog.getLogger().log(Level.FATAL, "The fluid registry is corrupted. Something has inserted a fluid without registering it");
            FMLLog.getLogger().log(Level.FATAL, "There is {} unregistered fluids", new Object[]{illegalFluids.size()});
            for (Fluid f : illegalFluids) {
                FMLLog.getLogger().log(Level.FATAL, "  Fluid name : {}, type: {}", new Object[]{f.getName(), f.getClass().getName()});
            }
            FMLLog.getLogger().log(Level.FATAL, "The mods that own these fluids need to register them properly");
            throw new IllegalStateException("The fluid map contains fluids unknown to the master fluid registry");
        }
    }

    static RegistryDelegate<Fluid> makeDelegate(Fluid fl) {
        return delegates.get(fl);
    }

    static {
        masterFluidReference = HashBiMap.create();
        defaultFluidName = HashBiMap.create();
        delegates = Maps.newHashMap();
        WATER = new Fluid("water"){

            @Override
            public String getLocalizedName() {
                return fi.a((String)"tile.water.name");
            }
        }.setBlock((atr)aty.j).setUnlocalizedName(aty.j.a());
        LAVA = new Fluid("lava"){

            @Override
            public String getLocalizedName() {
                return fi.a((String)"tile.lava.name");
            }
        }.setBlock((atr)aty.l).setLuminosity(15).setDensity(3000).setViscosity(6000).setTemperature(1300).setUnlocalizedName(aty.l.a());
        renderIdFluid = -1;
        FluidRegistry.registerFluid(WATER);
        FluidRegistry.registerFluid(LAVA);
    }

    private static class FluidDelegate
    implements RegistryDelegate<Fluid> {
        private String name;
        private Fluid fluid;

        FluidDelegate(Fluid fluid, String name) {
            this.fluid = fluid;
            this.name = name;
        }

        @Override
        public Fluid get() {
            return this.fluid;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Class<Fluid> type() {
            return Fluid.class;
        }

        void rebind() {
            this.fluid = (Fluid)fluids.get((Object)this.name);
        }
    }

    public static class FluidRegisterEvent
    extends Event {
        public final String fluidName;
        public final int fluidID;

        public FluidRegisterEvent(String fluidName, int fluidID) {
            this.fluidName = fluidName;
            this.fluidID = fluidID;
        }
    }
}

