/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.common.ZipperUtil;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.registry.ExistingSubstitutionException;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.ObjectHolderRegistry;
import net.minecraftforge.fml.common.registry.RegistryDelegate;

public class GameData {
    static final int MIN_BLOCK_ID = 0;
    static final int MAX_BLOCK_ID = 4095;
    static final int MIN_ITEM_ID = 4096;
    static final int MAX_ITEM_ID = 31999;
    private static final GameData mainData = new GameData();
    private static Map<GameRegistry.UniqueIdentifier, ModContainer> customOwners = Maps.newHashMap();
    private static GameData frozen;
    private final FMLControlledNamespacedRegistry<atr> iBlockRegistry;
    private final FMLControlledNamespacedRegistry<alq> iItemRegistry;
    private final BitSet availabilityMap;
    private final Set<Integer> blockedIds;
    private BiMap<String, alq> itemSubstitutions = HashBiMap.create();
    private BiMap<String, atr> blockSubstitutions = HashBiMap.create();
    private static Map<atr, alq> BLOCK_TO_ITEM;
    private static ClearableObjectIntIdentityMap BLOCKSTATE_TO_ID;
    private Map<String, FMLControlledNamespacedRegistry<?>> genericRegistries;
    private BiMap<String, Class<?>> registryTypes = HashBiMap.create((Map)ImmutableMap.builder().put((Object)"minecraft:blocks", atr.class).put((Object)"minecraft:items", alq.class).build());

    public static FMLControlledNamespacedRegistry<atr> getBlockRegistry() {
        return GameData.getMain().iBlockRegistry;
    }

    public static FMLControlledNamespacedRegistry<alq> getItemRegistry() {
        return GameData.getMain().iItemRegistry;
    }

    public static GameDataSnapshot takeSnapshot() {
        GameDataSnapshot snap = new GameDataSnapshot();
        Map<String, GameDataSnapshot.Entry> map = snap.entries;
        GameData.getMain();
        map.put("fml:blocks", new GameDataSnapshot.Entry(GameData.getBlockRegistry()));
        Map<String, GameDataSnapshot.Entry> map2 = snap.entries;
        GameData.getMain();
        map2.put("fml:items", new GameDataSnapshot.Entry(GameData.getItemRegistry()));
        for (Map.Entry<String, FMLControlledNamespacedRegistry<?>> e : GameData.getMain().genericRegistries.entrySet()) {
            snap.entries.put("fmlgr:" + e.getKey(), new GameDataSnapshot.Entry(e.getValue()));
        }
        return snap;
    }

    static alq findItem(String modId, String name) {
        return GameData.getMain().iItemRegistry.a(modId + ":" + name);
    }

    static atr findBlock(String modId, String name) {
        String key = modId + ":" + name;
        return GameData.getMain().iBlockRegistry.d(key) ? GameData.getMain().iBlockRegistry.a(key) : null;
    }

    static GameRegistry.UniqueIdentifier getUniqueName(atr block) {
        if (block == null) {
            return null;
        }
        Object name = GameData.getMain().iBlockRegistry.c(block);
        return new GameRegistry.UniqueIdentifier(name);
    }

    static GameRegistry.UniqueIdentifier getUniqueName(alq item) {
        if (item == null) {
            return null;
        }
        Object name = GameData.getMain().iItemRegistry.c(item);
        return new GameRegistry.UniqueIdentifier(name);
    }

    /*
     * WARNING - void declaration
     */
    public static void fixBrokenIds(GameDataSnapshot.Entry blocks, GameDataSnapshot.Entry items, Set<Integer> blockedIds) {
        BitSet availabilityMap = new BitSet(32000);
        for (Map.Entry<String, Integer> entry : blocks.ids.entrySet()) {
            availabilityMap.set(entry.getValue());
        }
        HashSet<Integer> newBlockedIds = new HashSet<Integer>();
        HashSet<String> itemsToRemove = new HashSet<String>();
        HashMap<String, Integer> itemsToRelocate = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry : items.ids.entrySet()) {
            int oldId = entry.getValue();
            String name = entry.getKey();
            alq alq2 = GameData.getMain().iItemRegistry.getRaw(name);
            boolean blockThisId = false;
            if (alq2 == null) {
                FMLLog.warning("Item %s (old id %d) is no longer available and thus can't be fixed.", name, oldId);
                itemsToRemove.add(name);
                blockThisId = true;
            } else if (alq2 instanceof aju) {
                if (blocks.ids.containsKey(name)) {
                    int blockId = blocks.ids.get(name);
                    if (blockId != oldId) {
                        FMLLog.warning("ItemBlock %s (old id %d) doesn't have the same id as its block (%d).", name, oldId, blockId);
                        itemsToRelocate.put(name, blockId);
                        blockThisId = true;
                    } else {
                        availabilityMap.set(oldId);
                    }
                } else {
                    FMLLog.warning("Item %s (old id %d) has been migrated to an ItemBlock and can't be fixed.", name, oldId);
                    itemsToRemove.add(name);
                    blockThisId = true;
                }
            } else if (availabilityMap.get(oldId)) {
                FMLLog.warning("Item %s (old id %d) is conflicting with another block/item and can't be fixed.", name, oldId);
                itemsToRemove.add(name);
            } else {
                availabilityMap.set(oldId);
            }
            if (!blockThisId || availabilityMap.get(oldId)) continue;
            newBlockedIds.add(oldId);
            availabilityMap.set(oldId);
        }
        if (itemsToRemove.isEmpty() && itemsToRelocate.isEmpty()) {
            return;
        }
        String text = "Forge Mod Loader detected that this save is damaged.\n\nIt's likely that an automatic repair can successfully restore\nmost of it, except some items which may get swapped with others.\n\nA world backup will be created as a zip file in your saves\ndirectory automatically.\n\n" + itemsToRemove.size() + " items need to be removed.\n" + itemsToRelocate.size() + " items need to be relocated.";
        boolean confirmed = StartupQuery.confirm(text);
        if (!confirmed) {
            StartupQuery.abort();
        }
        HashSet<String> modsMissing = new HashSet<String>();
        for (String string : itemsToRemove) {
            modsMissing.add(string.substring(0, string.indexOf(58)));
        }
        Iterator it = modsMissing.iterator();
        while (it.hasNext()) {
            String string = (String)it.next();
            if (!string.equals("minecraft") && !Loader.isModLoaded(string)) continue;
            it.remove();
        }
        if (!modsMissing.isEmpty()) {
            text = "Forge Mod Loader detected that " + modsMissing.size() + " mods are missing.\n\n" + "If you continue items previously provided by those mods will be\n" + "removed while repairing this world save.\n\n" + "Missing mods:\n";
            for (String string : modsMissing) {
                text = text + string + "\n";
            }
            confirmed = StartupQuery.confirm(text);
            if (!confirmed) {
                StartupQuery.abort();
            }
        }
        try {
            String skip = System.getProperty("fml.doNotBackup");
            if (skip == null || !"true".equals(skip)) {
                ZipperUtil.backupWorld();
            } else {
                void var11_22;
                boolean bl = false;
                while (var11_22 < 10) {
                    FMLLog.severe("!!!!!!!!!! UPDATING WORLD WITHOUT DOING BACKUP !!!!!!!!!!!!!!!!", new Object[0]);
                    ++var11_22;
                }
            }
        }
        catch (IOException e) {
            StartupQuery.notify("The world backup couldn't be created.\n\n" + e);
            StartupQuery.abort();
        }
        for (String string : itemsToRemove) {
            FMLLog.warning("Removed Item %s, old id %d.", string, items.ids.remove(string));
        }
        for (Map.Entry entry : itemsToRelocate.entrySet()) {
            int newId = (Integer)entry.getValue();
            int oldId = items.ids.put((String)entry.getKey(), newId);
            FMLLog.warning("Remapped Item %s to id %d, old id %d.", entry.getKey(), newId, oldId);
        }
        blockedIds.addAll(newBlockedIds);
    }

    public static List<String> injectSnapshot(GameDataSnapshot snapshot, boolean injectFrozenData, boolean isLocalWorld) {
        FMLLog.info("Injecting existing block and item data into this %s instance", FMLCommonHandler.instance().getEffectiveSide().isServer() ? "server" : "client");
        HashMap remapBlocks = Maps.newHashMap();
        HashMap remapItems = Maps.newHashMap();
        LinkedHashMap<String, Integer> missingBlocks = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, Integer> missingItems = new LinkedHashMap<String, Integer>();
        GameData.getMain().testConsistency();
        GameData.getMain().iBlockRegistry.dump();
        GameData.getMain().iItemRegistry.dump();
        GameDataSnapshot.Entry blocks = snapshot.entries.get("fml:blocks");
        GameDataSnapshot.Entry items = snapshot.entries.get("fml:items");
        GameData newData = new GameData();
        Iterator<Object> i$ = blocks.blocked.iterator();
        while (i$.hasNext()) {
            int n = i$.next();
            newData.block(n);
        }
        for (Map.Entry entry : blocks.aliases.entrySet()) {
            newData.iBlockRegistry.addAlias((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : items.aliases.entrySet()) {
            newData.iItemRegistry.addAlias((String)entry.getKey(), (String)entry.getValue());
        }
        for (String string : blocks.substitutions) {
            newData.iBlockRegistry.activateSubstitution(string);
        }
        for (String string : items.substitutions) {
            newData.iItemRegistry.activateSubstitution(string);
        }
        if (injectFrozenData) {
            for (String string : GameData.getMain().blockSubstitutions.keySet()) {
                if (blocks.substitutions.contains(string)) continue;
                newData.iBlockRegistry.activateSubstitution(string);
            }
            for (String string : GameData.getMain().itemSubstitutions.keySet()) {
                if (items.substitutions.contains(string)) continue;
                newData.iItemRegistry.activateSubstitution(string);
            }
        }
        GameData.BLOCKSTATE_TO_ID.clear();
        for (int pass = 0; pass < 2; ++pass) {
            boolean bl = pass == 0;
            Map<String, Integer> ids = bl ? blocks.ids : items.ids;
            for (Map.Entry<String, Integer> entry : ids.entrySet()) {
                int currId;
                String itemName = entry.getKey();
                int newId = entry.getValue();
                int n = currId = bl ? GameData.getMain().iBlockRegistry.getId(itemName) : GameData.getMain().iItemRegistry.getId(itemName);
                if (currId == -1) {
                    FMLLog.info("Found a missing id from the world %s", itemName);
                    (bl ? missingBlocks : missingItems).put(entry.getKey(), newId);
                    continue;
                }
                if (currId != newId) {
                    FMLLog.fine("Fixed %s id mismatch %s: %d (init) -> %d (map).", bl ? "block" : "item", itemName, currId, newId);
                    (bl ? remapBlocks : remapItems).put(itemName, new Integer[]{currId, newId});
                }
                if ((currId = bl ? newData.registerBlock(GameData.getMain().iBlockRegistry.getRaw(itemName), itemName, newId) : newData.registerItem(GameData.getMain().iItemRegistry.getRaw(itemName), itemName, newId)) == newId) continue;
                throw new IllegalStateException(String.format("Can't map %s %s to id %d (seen at: %d), already occupied by %s, blocked %b, ItemBlock %b", bl ? "block" : "item", itemName, newId, currId, bl ? newData.iBlockRegistry.getRaw(newId) : newData.iItemRegistry.getRaw(newId), newData.blockedIds.contains(newId), bl ? false : GameData.getMain().iItemRegistry.getRaw(currId) instanceof aju));
            }
        }
        List<String> missedMappings = Loader.instance().fireMissingMappingEvent(missingBlocks, missingItems, isLocalWorld, newData, remapBlocks, remapItems);
        if (!missedMappings.isEmpty()) {
            return missedMappings;
        }
        missedMappings = newData.loadGenericRegistries(snapshot, GameData.getMain());
        if (!missedMappings.isEmpty()) {
            return missedMappings;
        }
        if (injectFrozenData) {
            Map<String, Integer> map = GameData.frozen.iBlockRegistry.getEntriesNotIn(newData.iBlockRegistry);
            Map<String, Integer> newItems = GameData.frozen.iItemRegistry.getEntriesNotIn(newData.iItemRegistry);
            if (!map.isEmpty() || !newItems.isEmpty()) {
                FMLLog.info("Injecting new block and item data into this server instance.", new Object[0]);
                for (int pass = 0; pass < 2; ++pass) {
                    boolean isBlock = pass == 0;
                    Map<String, Integer> missing = pass == 0 ? map : newItems;
                    HashMap remaps = isBlock ? remapBlocks : remapItems;
                    for (Map.Entry<String, Integer> entry : missing.entrySet()) {
                        String itemName = entry.getKey();
                        int currId = entry.getValue();
                        int newId = isBlock ? newData.registerBlock(GameData.frozen.iBlockRegistry.getRaw(itemName), itemName, currId) : newData.registerItem(GameData.frozen.iItemRegistry.getRaw(itemName), itemName, currId);
                        FMLLog.info("Injected new block/item %s: %d (init) -> %d (map).", itemName, currId, newId);
                        if (newId == currId) continue;
                        remaps.put(itemName, new Integer[]{entry.getValue(), newId});
                    }
                }
            }
        }
        newData.testConsistency();
        GameData.getMain().set(newData);
        GameData.getMain().iBlockRegistry.dump();
        GameData.getMain().iItemRegistry.dump();
        Loader.instance().fireRemapEvent(remapBlocks, remapItems);
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
        return ImmutableList.of();
    }

    public static List<String> processIdRematches(Iterable<FMLMissingMappingsEvent.MissingMapping> missedMappings, boolean isLocalWorld, GameData gameData, Map<String, Integer[]> remapBlocks, Map<String, Integer[]> remapItems) {
        ArrayList failed = Lists.newArrayList();
        ArrayList ignored = Lists.newArrayList();
        ArrayList warned = Lists.newArrayList();
        ArrayList defaulted = Lists.newArrayList();
        for (FMLMissingMappingsEvent.MissingMapping remap : missedMappings) {
            FMLMissingMappingsEvent.Action action = remap.getAction();
            if (action == FMLMissingMappingsEvent.Action.REMAP) {
                int newId;
                String newName;
                int currId;
                if (remap.type == GameRegistry.Type.BLOCK) {
                    currId = GameData.getMain().iBlockRegistry.getId((atr)remap.getTarget());
                    newName = GameData.getMain().iBlockRegistry.c(remap.getTarget()).toString();
                    FMLLog.fine("The Block %s is being remapped to %s.", remap.name, newName);
                    newId = gameData.registerBlock((atr)remap.getTarget(), newName, remap.id);
                    gameData.iBlockRegistry.addAlias(remap.name, newName);
                } else {
                    currId = GameData.getMain().iItemRegistry.getId((alq)remap.getTarget());
                    newName = GameData.getMain().iItemRegistry.c(remap.getTarget()).toString();
                    FMLLog.fine("The Item %s is being remapped to %s.", remap.name, newName);
                    newId = gameData.registerItem((alq)remap.getTarget(), newName, remap.id);
                    gameData.iItemRegistry.addAlias(remap.name, newName);
                }
                if (newId != remap.id) {
                    throw new IllegalStateException();
                }
                if (currId == newId) continue;
                FMLLog.info("Fixed %s id mismatch %s: %d (init) -> %d (map).", remap.type == GameRegistry.Type.BLOCK ? "block" : "item", newName, currId, newId);
                (remap.type == GameRegistry.Type.BLOCK ? remapBlocks : remapItems).put(newName, new Integer[]{currId, newId});
                continue;
            }
            if (action == FMLMissingMappingsEvent.Action.BLOCKONLY) {
                FMLLog.fine("The ItemBlock %s is no longer present in the game. The residual block will remain", remap.name);
                continue;
            }
            if (action == FMLMissingMappingsEvent.Action.DEFAULT) {
                defaulted.add(remap.name);
            } else if (action == FMLMissingMappingsEvent.Action.IGNORE) {
                ignored.add(remap.name);
            } else if (action == FMLMissingMappingsEvent.Action.FAIL) {
                failed.add(remap.name);
            } else if (action == FMLMissingMappingsEvent.Action.WARN) {
                warned.add(remap.name);
            }
            gameData.block(remap.id);
        }
        if (!defaulted.isEmpty()) {
            String text = "Forge Mod Loader detected missing blocks/items.\n\nThere are " + defaulted.size() + " missing blocks and items in this save.\n" + "If you continue the missing blocks/items will get removed.\n" + "A world backup will be automatically created in your saves directory.\n\n" + "Missing Blocks/Items:\n";
            for (String s : defaulted) {
                text = text + s + "\n";
            }
            boolean confirmed = StartupQuery.confirm(text);
            if (!confirmed) {
                StartupQuery.abort();
            }
            try {
                String skip = System.getProperty("fml.doNotBackup");
                if (skip == null || !"true".equals(skip)) {
                    ZipperUtil.backupWorld();
                } else {
                    for (int x2 = 0; x2 < 10; ++x2) {
                        FMLLog.severe("!!!!!!!!!! UPDATING WORLD WITHOUT DOING BACKUP !!!!!!!!!!!!!!!!", new Object[0]);
                    }
                }
            }
            catch (IOException e) {
                StartupQuery.notify("The world backup couldn't be created.\n\n" + e);
                StartupQuery.abort();
            }
            warned.addAll(defaulted);
        }
        if (!failed.isEmpty()) {
            FMLLog.severe("This world contains blocks and items that refuse to be remapped. The world will not be loaded", new Object[0]);
            return failed;
        }
        if (!warned.isEmpty()) {
            FMLLog.severe("This world contains block and item mappings that may cause world breakage", new Object[0]);
            return failed;
        }
        if (!ignored.isEmpty()) {
            FMLLog.fine("There were %d missing mappings that have been ignored", ignored.size());
        }
        return failed;
    }

    public static void freezeData() {
        FMLLog.fine("Freezing block and item id maps", new Object[0]);
        GameData.getMain().testConsistency();
        frozen = new GameData(GameData.getMain());
        frozen.testConsistency();
    }

    public static void revertToFrozen() {
        if (frozen == null) {
            FMLLog.warning("Can't revert to frozen GameData state without freezing first.", new Object[0]);
        } else {
            FMLLog.fine("Reverting to frozen data state.", new Object[0]);
            GameData.getMain().set(frozen);
        }
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
    }

    protected static boolean isFrozen(FMLControlledNamespacedRegistry<?> registry) {
        return frozen != null && (GameData.getMain().iBlockRegistry == registry || GameData.getMain().iItemRegistry == registry);
    }

    protected static GameData getMain() {
        return mainData;
    }

    private GameData() {
        this.iBlockRegistry = new FMLControlledNamespacedRegistry<atr>(new oa("minecraft:air"), 4095, 0, atr.class);
        this.iItemRegistry = new FMLControlledNamespacedRegistry<alq>(null, 31999, 4096, alq.class);
        this.availabilityMap = new BitSet(32000);
        this.blockedIds = new HashSet<Integer>();
        this.genericRegistries = new HashMap();
    }

    private GameData(GameData data) {
        this();
        this.set(data);
    }

    private void set(GameData data) {
        this.iBlockRegistry.set(data.iBlockRegistry);
        this.iItemRegistry.set(data.iItemRegistry);
        this.availabilityMap.clear();
        this.availabilityMap.or(data.availabilityMap);
        this.blockedIds.clear();
        this.blockedIds.addAll(data.blockedIds);
        this.copyGenericRegistries(data);
    }

    private void copyGenericRegistries(GameData data) {
        for (Map.Entry<String, FMLControlledNamespacedRegistry<?>> e : data.genericRegistries.entrySet()) {
            FMLControlledNamespacedRegistry<?> orig = e.getValue();
            FMLControlledNamespacedRegistry<?> copy = orig.makeShallowCopy();
            copy.setFrom(orig);
            this.genericRegistries.put(e.getKey(), copy);
        }
    }

    int register(Object obj, String name, int idHint) {
        if (obj instanceof atr) {
            name = this.addPrefix(name);
            return this.registerBlock((atr)obj, name, idHint);
        }
        if (obj instanceof alq) {
            name = this.addPrefix(name);
            return this.registerItem((alq)obj, name, idHint);
        }
        return this.findRegistry(obj.getClass()).add(idHint, name, obj);
    }

    int registerItem(alq item, String name) {
        int index = name.indexOf(58);
        if (name.indexOf(58) != -1) {
            FMLLog.bigWarning("Illegal extra prefix %s for name %s, invalid registry invocation/invalid name?", name.substring(0, index), name);
        }
        name = this.addPrefix(name);
        return this.registerItem(item, name, -1);
    }

    private int registerItem(alq item, String name, int idHint) {
        if (item instanceof aju && !(item instanceof ajs)) {
            int id2;
            atr block = ((aju)item).a;
            if (idHint != -1 && GameData.getMain().blockSubstitutions.containsKey((Object)name)) {
                block = (atr)GameData.getMain().blockSubstitutions.get((Object)name);
            }
            if ((id2 = this.iBlockRegistry.getId(block)) == -1) {
                if (idHint < 0 || this.availabilityMap.get(idHint) || idHint > 4095) {
                    id2 = this.availabilityMap.nextClearBit(0);
                    if (id2 > 4095) {
                        throw new RuntimeException(String.format("Invalid id %d - maximum id range exceeded.", id2));
                    }
                    FMLLog.fine("Allocated id %d for ItemBlock %s in the block id range, original id requested: %d.", id2, name, idHint);
                } else {
                    id2 = idHint;
                }
            } else {
                FMLLog.fine("Found matching Block %s for ItemBlock %s at id %d, original id requested: %d", block, item, id2, idHint);
                this.freeSlot(id2, item);
            }
            idHint = id2;
        }
        int itemId = this.iItemRegistry.add(idHint, name, item, this.availabilityMap);
        if (item instanceof aju) {
            if (itemId != idHint) {
                throw new IllegalStateException(String.format("ItemBlock at block id %d insertion failed, got id %d.", idHint, itemId));
            }
            this.verifyItemBlockName((aju)item);
        }
        this.useSlot(itemId);
        ((RegistryDelegate.Delegate)item.delegate).setName(name);
        return itemId;
    }

    int registerBlock(atr block, String name) {
        int index = name.indexOf(58);
        if (name.indexOf(58) != -1) {
            FMLLog.bigWarning("Illegal extra prefix %s for name %s, invalid registry invocation/invalid name?", name.substring(0, index), name);
        }
        name = this.addPrefix(name);
        return this.registerBlock(block, name, -1);
    }

    private int registerBlock(atr block, String name, int idHint) {
        aju itemBlock = null;
        for (alq item : this.iItemRegistry.typeSafeIterable()) {
            if (!(item instanceof aju) || ((aju)item).a != block) continue;
            itemBlock = (aju)item;
            break;
        }
        if (itemBlock != null) {
            idHint = this.iItemRegistry.getId((alq)itemBlock);
            FMLLog.fine("Found matching ItemBlock %s for Block %s at id %d", itemBlock, block, idHint);
            this.freeSlot(idHint, block);
        }
        int blockId = this.iBlockRegistry.add(idHint, name, block, this.availabilityMap);
        if (itemBlock != null) {
            if (blockId != idHint) {
                throw new IllegalStateException(String.format("Block at itemblock id %d insertion failed, got id %d.", idHint, blockId));
            }
            this.verifyItemBlockName(itemBlock);
        }
        this.useSlot(blockId);
        ((RegistryDelegate.Delegate)block.delegate).setName(name);
        for (bec state : block.O().a()) {
            BLOCKSTATE_TO_ID.a(state, blockId << 4 | block.c(state));
        }
        return blockId;
    }

    private void block(int id2) {
        this.blockedIds.add(id2);
        this.useSlot(id2);
    }

    private void useSlot(int id2) {
        this.availabilityMap.set(id2);
    }

    private void freeSlot(int id2, Object obj) {
        FMLControlledNamespacedRegistry<Object> registry = obj instanceof atr ? this.iBlockRegistry : this.iItemRegistry;
        atr thing = registry.getRaw(id2);
        if (thing != null && thing != obj) {
            throw new IllegalStateException(String.format("Can't free registry slot %d occupied by %s", id2, thing));
        }
        this.availabilityMap.clear(id2);
    }

    private String addPrefix(String name) {
        ModContainer mc2;
        String prefix;
        int index = name.lastIndexOf(58);
        String oldPrefix = index == -1 ? "" : name.substring(0, index);
        if (!oldPrefix.equals(prefix = (mc2 = Loader.instance().activeModContainer()) != null ? mc2.getModId() : "minecraft")) {
            name = prefix + ":" + name;
        }
        return name;
    }

    private void verifyItemBlockName(aju item) {
        Object blockName = this.iBlockRegistry.c(item.a);
        Object itemName = this.iItemRegistry.c(item);
        if (blockName != null && !blockName.equals(itemName) && !"minecraft:standing_banner".equals(blockName.toString())) {
            FMLLog.bigWarning("Block <-> ItemBlock name mismatch, block name %s, item name %s", blockName, itemName);
        }
    }

    private void testConsistency() {
        int i = this.availabilityMap.nextSetBit(0);
        while (i >= 0) {
            if (this.iBlockRegistry.getRaw(i) == null && this.iItemRegistry.getRaw(i) == null && !this.blockedIds.contains(i)) {
                throw new IllegalStateException(String.format("availabilityMap references empty entries for id %d.", i));
            }
            i = this.availabilityMap.nextSetBit(i + 1);
        }
        for (int pass = 0; pass < 2; ++pass) {
            boolean isBlock = pass == 0;
            String type = isBlock ? "block" : "item";
            FMLControlledNamespacedRegistry<atr> registry = isBlock ? this.iBlockRegistry : this.iItemRegistry;
            registry.validateContent(isBlock ? 4095 : 31999, type, this.availabilityMap, this.blockedIds, this.iBlockRegistry);
        }
        FMLLog.fine("Registry consistency check successful", new Object[0]);
    }

    void registerSubstitutionAlias(String nameToSubstitute, GameRegistry.Type type, Object toReplace) throws ExistingSubstitutionException {
        type.getRegistry().addSubstitutionAlias(Loader.instance().activeModContainer().getModId(), nameToSubstitute, toReplace);
        type.getRegistry().activateSubstitution(nameToSubstitute);
    }

    static <T> RegistryDelegate<T> buildDelegate(T referant, Class<T> type) {
        return new RegistryDelegate.Delegate<T>(referant, type);
    }

    <T> BiMap<String, T> getPersistentSubstitutionMap(Class<T> type) {
        if (type.equals(alq.class)) {
            return this.itemSubstitutions;
        }
        if (type.equals(atr.class)) {
            return this.blockSubstitutions;
        }
        return ImmutableBiMap.of();
    }

    public static Map getBlockItemMap() {
        return BLOCK_TO_ITEM;
    }

    public static er getBlockStateIDMap() {
        return BLOCKSTATE_TO_ID;
    }

    private void findSuperTypes(Class<?> type, Set<Class<?>> types) {
        if (type == Object.class) {
            return;
        }
        types.add(type);
        for (Class<?> intf : type.getInterfaces()) {
            this.findSuperTypes(intf, types);
        }
        this.findSuperTypes(type.getSuperclass(), types);
    }

    private <T> FMLControlledNamespacedRegistry<T> getGenericRegistry(String registryName, Class<T> type) {
        FMLControlledNamespacedRegistry<?> fmlControlledNamespacedRegistry = this.genericRegistries.get(registryName);
        return fmlControlledNamespacedRegistry;
    }

    private <T> FMLControlledNamespacedRegistry<T> createGenericRegistry(String registryName, Class<T> type, int minId, int maxId) {
        HashSet parents = Sets.newHashSet();
        this.findSuperTypes(type, parents);
        Sets.SetView overlappedTypes = Sets.intersection((Set)parents, (Set)this.registryTypes.values());
        if (!overlappedTypes.isEmpty()) {
            Class foundType = (Class)overlappedTypes.iterator().next();
            FMLLog.severe("Found existing registry of type %1s named %2s, you cannot create a new registry (%3s) with type %4s, as %4s has a parent of that type", foundType, this.registryTypes.inverse().get((Object)foundType), registryName, type);
            throw new IllegalArgumentException("Duplicate registry parent type found - you can only have one registry for a particular super type");
        }
        FMLControlledNamespacedRegistry<T> fmlControlledNamespacedRegistry = new FMLControlledNamespacedRegistry<T>(null, maxId, minId, type);
        this.genericRegistries.put(registryName, fmlControlledNamespacedRegistry);
        this.registryTypes.put((Object)registryName, type);
        return fmlControlledNamespacedRegistry;
    }

    public static <T> FMLControlledNamespacedRegistry<T> createRegistry(String registryName, Class<T> type, int minId, int maxId) {
        return GameData.getMain().createGenericRegistry(registryName, type, minId, maxId);
    }

    private FMLControlledNamespacedRegistry<?> findRegistry(Class<?> type) {
        BiMap typeReg = this.registryTypes.inverse();
        String name = (String)typeReg.get(type);
        if (name == null) {
            HashSet parents = Sets.newHashSet();
            this.findSuperTypes(type, parents);
            Sets.SetView foundType = Sets.intersection((Set)parents, (Set)this.registryTypes.values());
            if (foundType.isEmpty()) {
                FMLLog.severe("Unable to find registry for type %s", type.getName());
                throw new IllegalArgumentException("Attempt to register an object without an associated registry");
            }
            Class regtype = (Class)Iterables.getOnlyElement((Iterable)foundType);
            name = (String)typeReg.get((Object)regtype);
        }
        return this.genericRegistries.get(name);
    }

    private List<String> loadGenericRegistries(GameDataSnapshot snapshot, GameData existing) {
        ArrayList result = Lists.newArrayList();
        for (Map.Entry<String, FMLControlledNamespacedRegistry<?>> e : existing.genericRegistries.entrySet()) {
            GameDataSnapshot.Entry regSnap;
            String regName = e.getKey();
            FMLControlledNamespacedRegistry<?> registry = e.getValue();
            FMLControlledNamespacedRegistry<?> newRegistry = this.genericRegistries.get(regName);
            if (newRegistry == null) {
                newRegistry = registry.makeShallowCopy();
                this.genericRegistries.put(regName, newRegistry);
            }
            if ((regSnap = snapshot.entries.get("fmlgr:" + regName)) == null) {
                FMLLog.info("Weird, there was no registry data for registry %s found in the snapshot", regName);
                continue;
            }
            for (Map.Entry<String, Integer> entry : regSnap.ids.entrySet()) {
                String entryName = entry.getKey();
                int entryId = entry.getValue();
                int currId = registry.getId(entryName);
                if (currId == -1) {
                    FMLLog.info("Found a missing id in registry %s from the world %s", regName, entryName);
                    result.add(regName + "{" + entryName + "}=" + entryId);
                    continue;
                }
                if (currId != entryId) {
                    FMLLog.fine("Fixed registry %s id mismatch %s: %d (init) -> %d (map).", regName, entryName, currId, entryId);
                }
                newRegistry.add(entryId, entryName, registry.getRaw(entryName));
            }
        }
        return result;
    }

    public static <T> FMLControlledNamespacedRegistry<T> getRegistry(String registryName, Class<T> type) {
        return GameData.getMain().getGenericRegistry(registryName, type);
    }

    static {
        BLOCK_TO_ITEM = Maps.newHashMap();
        BLOCKSTATE_TO_ID = new ClearableObjectIntIdentityMap();
    }

    private static class ClearableObjectIntIdentityMap
    extends er {
        private ClearableObjectIntIdentityMap() {
        }

        private void clear() {
            this.a.clear();
            this.b.clear();
        }
    }

    public static class GameDataSnapshot {
        public final Map<String, Entry> entries = Maps.newHashMap();

        public static class Entry {
            public final Map<String, Integer> ids;
            public final Set<String> substitutions;
            public final Map<String, String> aliases;
            public final Set<Integer> blocked;

            public Entry() {
                this(new HashMap<String, Integer>(), new HashSet<String>(), new HashMap<String, String>(), new HashSet<Integer>());
            }

            public Entry(Map<String, Integer> ids, Set<String> substitions, Map<String, String> aliases, Set<Integer> blocked) {
                this.ids = ids;
                this.substitutions = substitions;
                this.aliases = aliases;
                this.blocked = blocked;
            }

            public Entry(FMLControlledNamespacedRegistry registry) {
                this.ids = Maps.newHashMap();
                this.substitutions = Sets.newHashSet();
                this.aliases = Maps.newHashMap();
                this.blocked = Sets.newHashSet();
                registry.serializeInto(this.ids);
                registry.serializeSubstitutions(this.substitutions);
                registry.serializeAliases(this.aliases);
                if (GameData.getBlockRegistry() == registry || GameData.getItemRegistry() == registry) {
                    this.blocked.addAll(GameData.getMain().blockedIds);
                }
            }
        }
    }
}

