/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.world;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockEvent
extends Event {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockEvent", "false"));
    public final aqu world;
    public final dt pos;
    public final bec state;

    public BlockEvent(aqu world, dt pos, bec state) {
        this.pos = pos;
        this.world = world;
        this.state = state;
    }

    @Cancelable
    public static class NeighborNotifyEvent
    extends BlockEvent {
        private final EnumSet<ej> notifiedSides;

        public NeighborNotifyEvent(aqu world, dt pos, bec state, EnumSet<ej> notifiedSides) {
            super(world, pos, state);
            this.notifiedSides = notifiedSides;
        }

        public EnumSet<ej> getNotifiedSides() {
            return this.notifiedSides;
        }
    }

    @Cancelable
    public static class MultiPlaceEvent
    extends PlaceEvent {
        private final List<BlockSnapshot> blockSnapshots;

        public MultiPlaceEvent(List<BlockSnapshot> blockSnapshots, bec placedAgainst, ahd player) {
            super(blockSnapshots.get(0), placedAgainst, player);
            this.blockSnapshots = ImmutableList.copyOf(blockSnapshots);
            if (DEBUG) {
                System.out.printf("Created MultiPlaceEvent - [PlacedAgainst: %s ][ItemInHand: %s ][Player: %s ]\n", placedAgainst, this.itemInHand, player);
            }
        }

        public List<BlockSnapshot> getReplacedBlockSnapshots() {
            return this.blockSnapshots;
        }
    }

    @Cancelable
    public static class PlaceEvent
    extends BlockEvent {
        public final ahd player;
        public final amj itemInHand;
        public final BlockSnapshot blockSnapshot;
        public final bec placedBlock;
        public final bec placedAgainst;

        public PlaceEvent(BlockSnapshot blockSnapshot, bec placedAgainst, ahd player) {
            super(blockSnapshot.world, blockSnapshot.pos, blockSnapshot.getCurrentBlock());
            this.player = player;
            this.itemInHand = player.bY();
            this.blockSnapshot = blockSnapshot;
            this.placedBlock = blockSnapshot.getCurrentBlock();
            this.placedAgainst = placedAgainst;
            if (DEBUG) {
                System.out.printf("Created PlaceEvent - [PlacedBlock: %s ][PlacedAgainst: %s ][ItemStack: %s ][Player: %s ]\n", this.placedBlock, placedAgainst, player.bY(), player);
            }
        }
    }

    @Cancelable
    public static class BreakEvent
    extends BlockEvent {
        private final ahd player;
        private int exp;

        public BreakEvent(aqu world, dt pos, bec state, ahd player) {
            super(world, pos, state);
            this.player = player;
            if (state == null || !ForgeHooks.canHarvestBlock(state.c(), player, (ard)world, pos) || state.c().canSilkHarvest(world, pos, world.p(pos), player) && aph.e((xm)player)) {
                this.exp = 0;
            } else {
                int bonusLevel = aph.f((xm)player);
                this.exp = state.c().getExpDrop((ard)world, pos, bonusLevel);
            }
        }

        public ahd getPlayer() {
            return this.player;
        }

        public int getExpToDrop() {
            return this.isCanceled() ? 0 : this.exp;
        }

        public void setExpToDrop(int exp) {
            this.exp = exp;
        }
    }

    public static class HarvestDropsEvent
    extends BlockEvent {
        public final int fortuneLevel;
        public final List<amj> drops;
        public final boolean isSilkTouching;
        public float dropChance;
        public final ahd harvester;

        public HarvestDropsEvent(aqu world, dt pos, bec state, int fortuneLevel, float dropChance, List<amj> drops, ahd harvester, boolean isSilkTouching) {
            super(world, pos, state);
            this.fortuneLevel = fortuneLevel;
            this.dropChance = dropChance;
            this.drops = drops;
            this.isSilkTouching = isSilkTouching;
            this.harvester = harvester;
        }
    }
}

