/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.event;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLEvent;

public class FMLInterModComms {
    private static final ImmutableList<IMCMessage> emptyIMCList = ImmutableList.of();
    private static ArrayListMultimap<String, IMCMessage> modMessages = ArrayListMultimap.create();

    public static boolean sendMessage(String modId, String key, fn value) {
        return FMLInterModComms.enqueueStartupMessage(modId, new IMCMessage(key, value));
    }

    public static boolean sendMessage(String modId, String key, amj value) {
        return FMLInterModComms.enqueueStartupMessage(modId, new IMCMessage(key, value));
    }

    public static boolean sendMessage(String modId, String key, String value) {
        return FMLInterModComms.enqueueStartupMessage(modId, new IMCMessage(key, value));
    }

    public static void sendRuntimeMessage(Object sourceMod, String modId, String key, fn value) {
        FMLInterModComms.enqueueMessage(sourceMod, modId, new IMCMessage(key, value));
    }

    public static void sendRuntimeMessage(Object sourceMod, String modId, String key, amj value) {
        FMLInterModComms.enqueueMessage(sourceMod, modId, new IMCMessage(key, value));
    }

    public static void sendRuntimeMessage(Object sourceMod, String modId, String key, String value) {
        FMLInterModComms.enqueueMessage(sourceMod, modId, new IMCMessage(key, value));
    }

    private static boolean enqueueStartupMessage(String modTarget, IMCMessage message) {
        if (Loader.instance().activeModContainer() == null) {
            return false;
        }
        FMLInterModComms.enqueueMessage(Loader.instance().activeModContainer(), modTarget, message);
        return Loader.isModLoaded(modTarget) && !Loader.instance().hasReachedState(LoaderState.POSTINITIALIZATION);
    }

    private static void enqueueMessage(Object sourceMod, String modTarget, IMCMessage message) {
        ModContainer mc = sourceMod instanceof ModContainer ? (ModContainer)sourceMod : FMLCommonHandler.instance().findContainerFor(sourceMod);
        if (mc != null && Loader.isModLoaded(modTarget)) {
            message.setSender(mc);
            modMessages.put((Object)modTarget, (Object)message);
        }
    }

    public static ImmutableList<IMCMessage> fetchRuntimeMessages(Object forMod) {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(forMod);
        if (mc != null) {
            return ImmutableList.copyOf((Collection)modMessages.removeAll((Object)mc.getModId()));
        }
        return emptyIMCList;
    }

    public static final class IMCMessage {
        private String sender;
        public final String key;
        private Object value;

        private IMCMessage(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.sender;
        }

        public String getSender() {
            return this.sender;
        }

        void setSender(ModContainer activeModContainer) {
            this.sender = activeModContainer.getModId();
        }

        public String getStringValue() {
            return (String)this.value;
        }

        public fn getNBTValue() {
            return (fn)this.value;
        }

        public amj getItemStackValue() {
            return (amj)this.value;
        }

        public Class<?> getMessageType() {
            return this.value.getClass();
        }

        public boolean isStringMessage() {
            return String.class.isAssignableFrom(this.getMessageType());
        }

        public boolean isItemStackMessage() {
            return amj.class.isAssignableFrom(this.getMessageType());
        }

        public boolean isNBTMessage() {
            return fn.class.isAssignableFrom(this.getMessageType());
        }
    }

    public static class IMCEvent
    extends FMLEvent {
        private ModContainer activeContainer;
        private ImmutableList<IMCMessage> currentList;

        @Override
        public void applyModContainer(ModContainer activeContainer) {
            this.activeContainer = activeContainer;
            this.currentList = null;
            FMLLog.finer("Attempting to deliver %d IMC messages to mod %s", modMessages.get((Object)activeContainer.getModId()).size(), activeContainer.getModId());
        }

        public ImmutableList<IMCMessage> getMessages() {
            if (this.currentList == null) {
                this.currentList = ImmutableList.copyOf((Collection)modMessages.removeAll((Object)this.activeContainer.getModId()));
            }
            return this.currentList;
        }
    }
}

