/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import org.apache.commons.lang3.Validate;

public class ByteBufUtils {
    public static int varIntByteCount(int toCount) {
        return (toCount & 0xFFFFFF80) == 0 ? 1 : ((toCount & 0xFFFFC000) == 0 ? 2 : ((toCount & 0xFFE00000) == 0 ? 3 : ((toCount & 0xF0000000) == 0 ? 4 : 5)));
    }

    public static int readVarInt(ByteBuf buf2, int maxSize) {
        byte b0;
        Validate.isTrue((maxSize < 6 && maxSize > 0 ? 1 : 0) != 0, (String)"Varint length is between 1 and 5, not %d", (long)maxSize);
        int i = 0;
        int j2 = 0;
        do {
            b0 = buf2.readByte();
            i |= (b0 & 0x7F) << j2++ * 7;
            if (j2 <= maxSize) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b0 & 0x80) == 128);
        return i;
    }

    public static int readVarShort(ByteBuf buf2) {
        int low = buf2.readUnsignedShort();
        int high = 0;
        if ((low & 0x8000) != 0) {
            low &= Short.MAX_VALUE;
            high = buf2.readUnsignedByte();
        }
        return (high & 0xFF) << 15 | low;
    }

    public static void writeVarShort(ByteBuf buf2, int toWrite) {
        int low = toWrite & Short.MAX_VALUE;
        int high = (toWrite & 0x7F8000) >> 15;
        if (high != 0) {
            low |= 0x8000;
        }
        buf2.writeShort(low);
        if (high != 0) {
            buf2.writeByte(high);
        }
    }

    public static void writeVarInt(ByteBuf to, int toWrite, int maxSize) {
        Validate.isTrue((ByteBufUtils.varIntByteCount(toWrite) <= maxSize ? 1 : 0) != 0, (String)"Integer is too big for %d bytes", (long)maxSize);
        while ((toWrite & 0xFFFFFF80) != 0) {
            to.writeByte(toWrite & 0x7F | 0x80);
            toWrite >>>= 7;
        }
        to.writeByte(toWrite);
    }

    public static String readUTF8String(ByteBuf from) {
        int len = ByteBufUtils.readVarInt(from, 2);
        String str = from.toString(from.readerIndex(), len, Charsets.UTF_8);
        from.readerIndex(from.readerIndex() + len);
        return str;
    }

    public static void writeUTF8String(ByteBuf to, String string) {
        byte[] utf8Bytes = string.getBytes(Charsets.UTF_8);
        Validate.isTrue((ByteBufUtils.varIntByteCount(utf8Bytes.length) < 3 ? 1 : 0) != 0, (String)"The string is too long for this encoding.", (Object[])new Object[0]);
        ByteBufUtils.writeVarInt(to, utf8Bytes.length, 2);
        to.writeBytes(utf8Bytes);
    }

    public static void writeItemStack(ByteBuf to, amj stack) {
        hd pb = new hd(to);
        pb.a(stack);
    }

    public static amj readItemStack(ByteBuf from) {
        hd pb = new hd(from);
        try {
            return pb.i();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static void writeTag(ByteBuf to, fn tag) {
        hd pb = new hd(to);
        pb.a(tag);
    }

    public static fn readTag(ByteBuf from) {
        hd pb = new hd(from);
        try {
            return pb.h();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static String getContentDump(ByteBuf buffer) {
        int j2;
        int i;
        int currentLength = buffer.readableBytes();
        StringBuffer returnString = new StringBuffer(currentLength * 3 + currentLength + currentLength / 4 + 30);
        for (i = 0; i < currentLength; ++i) {
            if (i != 0 && i % 16 == 0) {
                returnString.append('\t');
                for (j2 = i - 16; j2 < i; ++j2) {
                    if (buffer.getByte(j2) < 32 || buffer.getByte(j2) > 127) {
                        returnString.append('.');
                        continue;
                    }
                    returnString.append((char)buffer.getByte(j2));
                }
                returnString.append("\n");
            }
            returnString.append(Integer.toString((buffer.getByte(i) & 0xF0) >> 4, 16) + Integer.toString((buffer.getByte(i) & 0xF) >> 0, 16));
            returnString.append(' ');
        }
        if (i != 0 && i % 16 != 0) {
            for (j2 = 0; j2 < (16 - i % 16) * 3; ++j2) {
                returnString.append(' ');
            }
        }
        returnString.append('\t');
        for (j2 = i > 0 && i % 16 == 0 ? i - 16 : i - i % 16; i >= 0 && j2 < i; ++j2) {
            if (buffer.getByte(j2) < 32 || buffer.getByte(j2) > 127) {
                returnString.append('.');
                continue;
            }
            returnString.append((char)buffer.getByte(j2));
        }
        returnString.append('\n');
        returnString.append("Length: " + currentLength);
        return returnString.toString();
    }
}

