/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IPerspectiveState;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import org.apache.commons.lang3.tuple.Pair;

public class ItemLayerModel
implements IRetexturableModel {
    public static final ItemLayerModel instance = new ItemLayerModel((ImmutableList<oa>)ImmutableList.of());
    private final ImmutableList<oa> textures;

    public ItemLayerModel(ImmutableList<oa> textures) {
        this.textures = textures;
    }

    public ItemLayerModel(cmc model) {
        this(ItemLayerModel.getTextures(model));
    }

    private static ImmutableList<oa> getTextures(cmc model) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int i = 0;
        while (model.b("layer" + i)) {
            builder.add((Object)new oa(model.c("layer" + i)));
            ++i;
        }
        return builder.build();
    }

    @Override
    public Collection<oa> getDependencies() {
        return ImmutableList.of();
    }

    @Override
    public Collection<oa> getTextures() {
        return this.textures;
    }

    @Override
    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    @Override
    public IModel retexture(ImmutableMap<String, String> textures) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < textures.size(); ++i) {
            if (!textures.containsKey((Object)("layer" + i))) continue;
            builder.add((Object)new oa((String)textures.get((Object)("layer" + i))));
        }
        return new ItemLayerModel((ImmutableList<oa>)builder.build());
    }

    @Override
    public IFlexibleBakedModel bake(IModelState state, cus format, Function<oa, cue> bakedTextureGetter) {
        ImmutableList.Builder builder = ImmutableList.builder();
        TRSRTransformation transform = state.apply(this);
        for (int i = 0; i < this.textures.size(); ++i) {
            cue sprite = (cue)bakedTextureGetter.apply(this.textures.get(i));
            builder.addAll(this.getQuadsForSprite(i, sprite, format, transform));
        }
        cue particle = (cue)bakedTextureGetter.apply((Object)(this.textures.isEmpty() ? new oa("missingno") : (oa)this.textures.get(0)));
        if (state instanceof IPerspectiveState) {
            IPerspectiveState ps = (IPerspectiveState)state;
            ImmutableMap<cmz, TRSRTransformation> map = IPerspectiveAwareModel.MapWrapper.getTransforms(ps, this);
            return new BakedModel((ImmutableList<clt>)builder.build(), particle, format, (ImmutableMap<cmz, TRSRTransformation>)Maps.immutableEnumMap(map));
        }
        return new BakedModel((ImmutableList<clt>)builder.build(), particle, format);
    }

    public ImmutableList<clt> getQuadsForSprite(int tint, cue sprite, cus format, TRSRTransformation transform) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int uMax = sprite.c();
        int vMax = sprite.d();
        for (int f = 0; f < sprite.k(); ++f) {
            int[] pixels = sprite.a(f)[0];
            boolean[] ptv = new boolean[uMax];
            Arrays.fill(ptv, true);
            for (int v = 0; v < vMax; ++v) {
                boolean ptu = true;
                for (int u = 0; u < uMax; ++u) {
                    boolean t = this.isTransparent(pixels, uMax, vMax, u, v);
                    if (ptu && !t) {
                        builder.add((Object)ItemLayerModel.buildSideQuad(format, transform, ej.e, tint, sprite, u, v));
                    }
                    if (!ptu && t) {
                        builder.add((Object)ItemLayerModel.buildSideQuad(format, transform, ej.f, tint, sprite, u, v));
                    }
                    if (ptv[u] && !t) {
                        builder.add((Object)ItemLayerModel.buildSideQuad(format, transform, ej.b, tint, sprite, u, v));
                    }
                    if (!ptv[u] && t) {
                        builder.add((Object)ItemLayerModel.buildSideQuad(format, transform, ej.a, tint, sprite, u, v));
                    }
                    ptu = t;
                    ptv[u] = t;
                }
                if (ptu) continue;
                builder.add((Object)ItemLayerModel.buildSideQuad(format, transform, ej.f, tint, sprite, uMax, v));
            }
            for (int u = 0; u < uMax; ++u) {
                if (ptv[u]) continue;
                builder.add((Object)ItemLayerModel.buildSideQuad(format, transform, ej.a, tint, sprite, u, vMax));
            }
        }
        builder.add((Object)ItemLayerModel.buildQuad(format, transform, ej.d, tint, 0.0f, 0.0f, 0.46875f, sprite.e(), sprite.h(), 0.0f, 1.0f, 0.46875f, sprite.e(), sprite.g(), 1.0f, 1.0f, 0.46875f, sprite.f(), sprite.g(), 1.0f, 0.0f, 0.46875f, sprite.f(), sprite.h()));
        builder.add((Object)ItemLayerModel.buildQuad(format, transform, ej.c, tint, 0.0f, 0.0f, 0.53125f, sprite.e(), sprite.h(), 1.0f, 0.0f, 0.53125f, sprite.f(), sprite.h(), 1.0f, 1.0f, 0.53125f, sprite.f(), sprite.g(), 0.0f, 1.0f, 0.53125f, sprite.e(), sprite.g()));
        return builder.build();
    }

    protected boolean isTransparent(int[] pixels, int uMax, int vMax, int u, int v) {
        return (pixels[u + (vMax - 1 - v) * uMax] >> 24 & 0xFF) == 0;
    }

    private static clt buildSideQuad(cus format, TRSRTransformation transform, ej side, int tint, cue sprite, int u, int v) {
        float x0 = (float)u / (float)sprite.c();
        float y0 = (float)v / (float)sprite.d();
        float x1 = x0;
        float y1 = y0;
        float z1 = 0.46875f;
        float z2 = 0.53125f;
        switch (side) {
            case e: {
                z1 = 0.53125f;
                z2 = 0.46875f;
            }
            case f: {
                y1 = ((float)v + 1.0f) / (float)sprite.d();
                break;
            }
            case a: {
                z1 = 0.53125f;
                z2 = 0.46875f;
            }
            case b: {
                x1 = ((float)u + 1.0f) / (float)sprite.c();
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        float u0 = 16.0f * (x0 - (float)side.m().n() * 0.01f / (float)sprite.c());
        float u1 = 16.0f * (x1 - (float)side.m().n() * 0.01f / (float)sprite.c());
        float v0 = 16.0f * (1.0f - y0 - (float)side.m().o() * 0.01f / (float)sprite.d());
        float v1 = 16.0f * (1.0f - y1 - (float)side.m().o() * 0.01f / (float)sprite.d());
        return ItemLayerModel.buildQuad(format, transform, side.d(), tint, x0, y0, z1, sprite.a((double)u0), sprite.b((double)v0), x1, y1, z1, sprite.a((double)u1), sprite.b((double)v1), x1, y1, z2, sprite.a((double)u1), sprite.b((double)v1), x0, y0, z2, sprite.a((double)u0), sprite.b((double)v0));
    }

    private static final clt buildQuad(cus format, TRSRTransformation transform, ej side, int tint, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setQuadTint(tint);
        builder.setQuadOrientation(side);
        ItemLayerModel.putVertex(builder, format, transform, side, x0, y0, z0, u0, v0);
        ItemLayerModel.putVertex(builder, format, transform, side, x1, y1, z1, u1, v1);
        ItemLayerModel.putVertex(builder, format, transform, side, x2, y2, z2, u2, v2);
        ItemLayerModel.putVertex(builder, format, transform, side, x3, y3, z3, u3, v3);
        return builder.build();
    }

    private static void putVertex(UnpackedBakedQuad.Builder builder, cus format, TRSRTransformation transform, ej side, float x2, float y, float z, float u, float v) {
        Vector4f vec = new Vector4f();
        block6: for (int e = 0; e < format.h(); ++e) {
            switch (format.c(e).c()) {
                case a: {
                    vec.x = x2;
                    vec.y = y;
                    vec.z = z;
                    vec.w = 1.0f;
                    transform.getMatrix().transform((Tuple4f)vec);
                    builder.put(e, vec.x, vec.y, vec.z, vec.w);
                    continue block6;
                }
                case c: {
                    builder.put(e, 1.0f, 1.0f, 1.0f, 1.0f);
                    continue block6;
                }
                case d: {
                    if (format.c(e).e() == 0) {
                        builder.put(e, u, v, 0.0f, 1.0f);
                        continue block6;
                    }
                }
                case b: {
                    builder.put(e, side.g(), side.h(), side.i(), 0.0f);
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    public static enum Loader implements ICustomModelLoader
    {
        instance;


        public void a(cvk resourceManager) {
        }

        @Override
        public boolean accepts(oa modelLocation) {
            return modelLocation.b().equals("forge") && (modelLocation.a().equals("item-layer") || modelLocation.a().equals("models/block/item-layer") || modelLocation.a().equals("models/item/item-layer"));
        }

        @Override
        public IModel loadModel(oa modelLocation) {
            return instance;
        }
    }

    public static class BakedModel
    implements IFlexibleBakedModel,
    IPerspectiveAwareModel {
        private final ImmutableList<clt> quads;
        private final cue particle;
        private final cus format;
        private final ImmutableMap<cmz, TRSRTransformation> transforms;

        public BakedModel(ImmutableList<clt> quads, cue particle, cus format) {
            this(quads, particle, format, (ImmutableMap<cmz, TRSRTransformation>)ImmutableMap.of());
        }

        public BakedModel(ImmutableList<clt> quads, cue particle, cus format, ImmutableMap<cmz, TRSRTransformation> transforms) {
            this.quads = quads;
            this.particle = particle;
            this.format = format;
            this.transforms = transforms;
        }

        public boolean b() {
            return true;
        }

        public boolean c() {
            return false;
        }

        public boolean d() {
            return false;
        }

        public cue e() {
            return this.particle;
        }

        public cmx f() {
            return cmx.a;
        }

        @Override
        public List<clt> a(ej side) {
            return ImmutableList.of();
        }

        @Override
        public List<clt> a() {
            return this.quads;
        }

        @Override
        public cus getFormat() {
            return this.format;
        }

        @Override
        public Pair<cxe, Matrix4f> handlePerspective(cmz cameraTransformType) {
            TRSRTransformation tr = (TRSRTransformation)this.transforms.get((Object)cameraTransformType);
            Matrix4f mat = null;
            if (tr != null && tr != TRSRTransformation.identity()) {
                mat = TRSRTransformation.blockCornerToCenter(tr).getMatrix();
            }
            return Pair.of((Object)this, mat);
        }
    }
}

