/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Objects;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraftforge.client.model.IModelPart;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.ITransformation;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class TRSRTransformation
implements IModelState,
ITransformation {
    private final Matrix4f matrix;
    private boolean full;
    private Vector3f translation;
    private Quat4f leftRot;
    private Vector3f scale;
    private Quat4f rightRot;
    private static final TRSRTransformation identity;
    private static final float eps = 1.0E-7f;
    private static final float g;
    private static final float cs;
    private static final float ss;
    private static final float sq2;

    public TRSRTransformation(Matrix4f matrix) {
        this.matrix = matrix == null ? TRSRTransformation.identity.matrix : matrix;
    }

    public TRSRTransformation(Vector3f translation, Quat4f leftRot, Vector3f scale, Quat4f rightRot) {
        this.matrix = TRSRTransformation.mul(translation, leftRot, scale, rightRot);
        this.translation = translation != null ? translation : new Vector3f();
        this.leftRot = leftRot != null ? leftRot : new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        this.scale = scale != null ? scale : new Vector3f(1.0f, 1.0f, 1.0f);
        this.rightRot = rightRot != null ? rightRot : new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        this.full = true;
    }

    public TRSRTransformation(cmv transform) {
        this(TRSRTransformation.getMatrix(transform));
    }

    public static Matrix4f getMatrix(cmv transform) {
        TRSRTransformation ret = new TRSRTransformation(transform.c, TRSRTransformation.quatFromYXZDegrees(transform.b), transform.d, null);
        return TRSRTransformation.blockCenterToCorner(ret).getMatrix();
    }

    public TRSRTransformation(cxf rotation) {
        this(rotation.getMatrix());
    }

    public TRSRTransformation(ej facing) {
        this(TRSRTransformation.getMatrix(facing));
    }

    public static Matrix4f getMatrix(ej facing) {
        switch (facing) {
            case a: {
                return cxf.e.getMatrix();
            }
            case b: {
                return cxf.m.getMatrix();
            }
            case c: {
                return TRSRTransformation.identity.matrix;
            }
            case d: {
                return cxf.c.getMatrix();
            }
            case e: {
                return cxf.d.getMatrix();
            }
            case f: {
                return cxf.b.getMatrix();
            }
        }
        return new Matrix4f();
    }

    public static TRSRTransformation identity() {
        return identity;
    }

    public TRSRTransformation compose(TRSRTransformation b) {
        Matrix4f m = this.getMatrix();
        m.mul(b.getMatrix());
        return new TRSRTransformation(m);
    }

    private void genCheck() {
        if (!this.full) {
            Pair<Matrix3f, Vector3f> pair = TRSRTransformation.toAffine(this.matrix);
            Triple<Quat4f, Vector3f, Quat4f> triple = TRSRTransformation.svdDecompose((Matrix3f)pair.getLeft());
            this.translation = (Vector3f)pair.getRight();
            this.leftRot = (Quat4f)triple.getLeft();
            this.scale = (Vector3f)triple.getMiddle();
            this.rightRot = (Quat4f)triple.getRight();
            this.full = true;
        }
    }

    public static Quat4f quatFromYXZDegrees(Vector3f yxz) {
        return TRSRTransformation.quatFromYXZ((float)Math.toRadians(yxz.y), (float)Math.toRadians(yxz.x), (float)Math.toRadians(yxz.z));
    }

    public static Quat4f quatFromYXZ(Vector3f yxz) {
        return TRSRTransformation.quatFromYXZ(yxz.y, yxz.x, yxz.z);
    }

    public static Quat4f quatFromYXZ(float y, float x2, float z) {
        Quat4f ret = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        Quat4f t = new Quat4f();
        t.set(0.0f, (float)Math.sin(y / 2.0f), 0.0f, (float)Math.cos(y / 2.0f));
        ret.mul(t);
        t.set((float)Math.sin(x2 / 2.0f), 0.0f, 0.0f, (float)Math.cos(x2 / 2.0f));
        ret.mul(t);
        t.set(0.0f, 0.0f, (float)Math.sin(z / 2.0f), (float)Math.cos(z / 2.0f));
        ret.mul(t);
        return ret;
    }

    public static Vector3f toYXZ(Quat4f q) {
        float w2 = q.w * q.w;
        float x2 = q.x * q.x;
        float y2 = q.y * q.y;
        float z2 = q.z * q.z;
        float l = w2 + x2 + y2 + z2;
        float sx = 2.0f * q.y * q.z - 2.0f * q.w * q.x;
        float x3 = (float)Math.asin(sx / l);
        if (Math.abs(sx) > 0.999f * l) {
            return new Vector3f(2.0f * (float)Math.atan2(q.y, q.w), x3, 0.0f);
        }
        return new Vector3f((float)Math.atan2(2.0f * q.x * q.z + 2.0f * q.y * q.w, w2 - x2 - y2 + z2), x3, (float)Math.atan2(2.0f * q.x * q.y + 2.0f * q.w * q.z, w2 - x2 + y2 - z2));
    }

    public static Matrix4f mul(Vector3f translation, Quat4f leftRot, Vector3f scale, Quat4f rightRot) {
        Matrix4f res = new Matrix4f();
        Matrix4f t = new Matrix4f();
        res.setIdentity();
        if (translation != null) {
            res.setTranslation(translation);
        }
        if (leftRot != null) {
            t.set(leftRot);
            res.mul(t);
        }
        if (scale != null) {
            t.setIdentity();
            t.m00 = scale.x;
            t.m11 = scale.y;
            t.m22 = scale.z;
            res.mul(t);
        }
        if (rightRot != null) {
            t.set(rightRot);
            res.mul(t);
        }
        return res;
    }

    public static Triple<Quat4f, Vector3f, Quat4f> svdDecompose(Matrix3f m) {
        Quat4f u = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        Quat4f v = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        Quat4f qt = new Quat4f();
        Matrix3f b = new Matrix3f(m);
        Matrix3f t = new Matrix3f();
        t.transpose(m);
        b.mul(t, b);
        for (int i = 0; i < 5; ++i) {
            v.mul(TRSRTransformation.stepJacobi(b));
        }
        v.normalize();
        t.set(v);
        b.set(m);
        b.mul(t);
        TRSRTransformation.sortSingularValues(b, v);
        float ul = 1.0f;
        Pair<Float, Float> p = TRSRTransformation.qrGivensQuat(b.m00, b.m10);
        qt.set(0.0f, 0.0f, ((Float)p.getLeft()).floatValue(), ((Float)p.getRight()).floatValue());
        u.mul(qt);
        t.setIdentity();
        t.m11 = t.m00 = qt.w * qt.w - qt.z * qt.z;
        t.m10 = -2.0f * qt.z * qt.w;
        t.m01 = -t.m10;
        t.m22 = qt.w * qt.w + qt.z * qt.z;
        ul *= t.m22;
        b.mul(t, b);
        p = TRSRTransformation.qrGivensQuat(b.m00, b.m20);
        qt.set(0.0f, -((Float)p.getLeft()).floatValue(), 0.0f, ((Float)p.getRight()).floatValue());
        u.mul(qt);
        t.setIdentity();
        t.m22 = t.m00 = qt.w * qt.w - qt.y * qt.y;
        t.m20 = 2.0f * qt.y * qt.w;
        t.m02 = -t.m20;
        t.m11 = qt.w * qt.w + qt.y * qt.y;
        ul *= t.m11;
        b.mul(t, b);
        p = TRSRTransformation.qrGivensQuat(b.m11, b.m21);
        qt.set(((Float)p.getLeft()).floatValue(), 0.0f, 0.0f, ((Float)p.getRight()).floatValue());
        u.mul(qt);
        t.setIdentity();
        t.m22 = t.m11 = qt.w * qt.w - qt.x * qt.x;
        t.m21 = -2.0f * qt.x * qt.w;
        t.m12 = -t.m21;
        t.m00 = qt.w * qt.w + qt.x * qt.x;
        ul *= t.m00;
        b.mul(t, b);
        ul = 1.0f / ul;
        u.scale((float)Math.sqrt(ul));
        Vector3f s = new Vector3f(b.m00 * ul, b.m11 * ul, b.m22 * ul);
        return Triple.of((Object)u, (Object)s, (Object)v);
    }

    private static float rsqrt(float f) {
        float f2 = 0.5f * f;
        int i = Float.floatToIntBits(f);
        i = 1597463007 - (i >> 1);
        f = Float.intBitsToFloat(i);
        f *= 1.5f - f2 * f * f;
        return f;
    }

    private static Pair<Float, Float> approxGivensQuat(float a11, float a12, float a22) {
        float sh = a12;
        float ch = 2.0f * (a11 - a22);
        boolean b = g * sh * sh < ch * ch;
        float w2 = TRSRTransformation.rsqrt(sh * sh + ch * ch);
        ch = b ? w2 * ch : cs;
        sh = b ? w2 * sh : ss;
        return Pair.of((Object)Float.valueOf(sh), (Object)Float.valueOf(ch));
    }

    private static final void swapNeg(Matrix3f m, int i, int j) {
        float[] t = new float[3];
        m.getColumn(j, t);
        for (int k = 0; k < 3; ++k) {
            m.setElement(k, j, -m.getElement(k, i));
        }
        m.setColumn(i, t);
    }

    private static void sortSingularValues(Matrix3f b, Quat4f v) {
        float f;
        float p0 = b.m00 * b.m00 + b.m10 * b.m10 + b.m20 * b.m20;
        float p1 = b.m01 * b.m01 + b.m11 * b.m11 + b.m21 * b.m21;
        float p2 = b.m02 * b.m02 + b.m12 * b.m12 + b.m22 * b.m22;
        Quat4f t = new Quat4f();
        if (p0 < p1) {
            TRSRTransformation.swapNeg(b, 0, 1);
            t.set(0.0f, 0.0f, sq2, sq2);
            v.mul(t);
            f = p0;
            p0 = p1;
            p1 = f;
        }
        if (p0 < p2) {
            TRSRTransformation.swapNeg(b, 0, 2);
            t.set(0.0f, sq2, 0.0f, sq2);
            v.mul(t);
            f = p0;
            p0 = p2;
            p2 = f;
        }
        if (p1 < p2) {
            TRSRTransformation.swapNeg(b, 1, 2);
            t.set(sq2, 0.0f, 0.0f, sq2);
            v.mul(t);
        }
    }

    private static Pair<Float, Float> qrGivensQuat(float a1, float a2) {
        float p = (float)Math.sqrt(a1 * a1 + a2 * a2);
        float sh = p > 1.0E-7f ? a2 : 0.0f;
        float ch = Math.abs(a1) + Math.max(p, 1.0E-7f);
        if (a1 < 0.0f) {
            float f = sh;
            sh = ch;
            ch = f;
        }
        float w2 = TRSRTransformation.rsqrt(ch * ch + sh * sh);
        return Pair.of((Object)Float.valueOf(sh *= w2), (Object)Float.valueOf(ch *= w2));
    }

    private static Quat4f stepJacobi(Matrix3f m) {
        Matrix3f t = new Matrix3f();
        Quat4f qt = new Quat4f();
        Quat4f ret = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        Pair<Float, Float> p = TRSRTransformation.approxGivensQuat(m.m00, 0.5f * (m.m01 + m.m10), m.m11);
        qt.set(0.0f, 0.0f, ((Float)p.getLeft()).floatValue(), ((Float)p.getRight()).floatValue());
        ret.mul(qt);
        t.setIdentity();
        t.m11 = t.m00 = qt.w * qt.w - qt.z * qt.z;
        t.m10 = 2.0f * qt.z * qt.w;
        t.m01 = -t.m10;
        t.m22 = qt.w * qt.w + qt.z * qt.z;
        m.mul(m, t);
        t.transpose();
        m.mul(t, m);
        p = TRSRTransformation.approxGivensQuat(m.m00, 0.5f * (m.m02 + m.m20), m.m22);
        qt.set(0.0f, -((Float)p.getLeft()).floatValue(), 0.0f, ((Float)p.getRight()).floatValue());
        ret.mul(qt);
        t.setIdentity();
        t.m22 = t.m00 = qt.w * qt.w - qt.y * qt.y;
        t.m20 = -2.0f * qt.y * qt.w;
        t.m02 = -t.m20;
        t.m11 = qt.w * qt.w + qt.y * qt.y;
        m.mul(m, t);
        t.transpose();
        m.mul(t, m);
        p = TRSRTransformation.approxGivensQuat(m.m11, 0.5f * (m.m12 + m.m21), m.m22);
        qt.set(((Float)p.getLeft()).floatValue(), 0.0f, 0.0f, ((Float)p.getRight()).floatValue());
        ret.mul(qt);
        t.setIdentity();
        t.m22 = t.m11 = qt.w * qt.w - qt.x * qt.x;
        t.m21 = 2.0f * qt.x * qt.w;
        t.m12 = -t.m21;
        t.m00 = qt.w * qt.w + qt.x * qt.x;
        m.mul(m, t);
        t.transpose();
        m.mul(t, m);
        return ret;
    }

    public static Pair<Matrix3f, Vector3f> toAffine(Matrix4f m) {
        m.mul(1.0f / m.m33);
        Vector3f trans = new Vector3f(m.m03, m.m13, m.m23);
        Matrix3f linear = new Matrix3f(m.m00, m.m01, m.m02, m.m10, m.m11, m.m12, m.m20, m.m21, m.m22);
        return Pair.of((Object)linear, (Object)trans);
    }

    public cmv toItemTransform() {
        return new cmv(this.getTranslation(), TRSRTransformation.toYXZ(this.getLeftRot()), this.getScale());
    }

    @Override
    public Matrix4f getMatrix() {
        return (Matrix4f)this.matrix.clone();
    }

    public Vector3f getTranslation() {
        this.genCheck();
        return (Vector3f)this.translation.clone();
    }

    public Quat4f getLeftRot() {
        this.genCheck();
        return (Quat4f)this.leftRot.clone();
    }

    public Vector3f getScale() {
        this.genCheck();
        return (Vector3f)this.scale.clone();
    }

    public Quat4f getRightRot() {
        this.genCheck();
        return (Quat4f)this.rightRot.clone();
    }

    @Override
    public TRSRTransformation apply(IModelPart part) {
        return this;
    }

    @Override
    public ej rotate(ej facing) {
        return TRSRTransformation.rotate(this.matrix, facing);
    }

    public static ej rotate(Matrix4f matrix, ej facing) {
        fd dir = facing.m();
        Vector4f vec = new Vector4f((float)dir.n(), (float)dir.o(), (float)dir.p(), 0.0f);
        matrix.transform((Tuple4f)vec);
        return ej.a((float)vec.x, (float)vec.y, (float)vec.z);
    }

    public static boolean isInteger(Matrix4f matrix) {
        Matrix4f m = new Matrix4f();
        m.setIdentity();
        m.m32 = 1.0f;
        m.m31 = 1.0f;
        m.m30 = 1.0f;
        m.m33 = 0.0f;
        m.mul(matrix, m);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                float v = m.getElement(i, j) / m.getElement(3, j);
                if (!((double)Math.abs(v - (float)Math.round(v)) > 1.0E-5)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int rotate(ej facing, int vertexIndex) {
        return vertexIndex;
    }

    public String toString() {
        this.genCheck();
        return Objects.toStringHelper(this.getClass()).add("matrix", (Object)this.matrix).add("translation", (Object)this.translation).add("leftRot", (Object)this.leftRot).add("scale", (Object)this.scale).add("rightRot", (Object)this.rightRot).toString();
    }

    public static TRSRTransformation blockCenterToCorner(TRSRTransformation transform) {
        Matrix4f ret = new Matrix4f(transform.getMatrix());
        Matrix4f tmp = new Matrix4f();
        tmp.setIdentity();
        tmp.m23 = 0.5f;
        tmp.m13 = 0.5f;
        tmp.m03 = 0.5f;
        ret.mul(tmp, ret);
        tmp.m23 = -0.5f;
        tmp.m13 = -0.5f;
        tmp.m03 = -0.5f;
        ret.mul(tmp);
        return new TRSRTransformation(ret);
    }

    public static TRSRTransformation blockCornerToCenter(TRSRTransformation transform) {
        Matrix4f ret = new Matrix4f(transform.getMatrix());
        Matrix4f tmp = new Matrix4f();
        tmp.setIdentity();
        tmp.m23 = -0.5f;
        tmp.m13 = -0.5f;
        tmp.m03 = -0.5f;
        ret.mul(tmp, ret);
        tmp.m23 = 0.5f;
        tmp.m13 = 0.5f;
        tmp.m03 = 0.5f;
        ret.mul(tmp);
        return new TRSRTransformation(ret);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.matrix == null ? 0 : this.matrix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TRSRTransformation other = (TRSRTransformation)obj;
        return !(this.matrix == null ? other.matrix != null : !this.matrix.equals(other.matrix));
    }

    static {
        Matrix4f m = new Matrix4f();
        m.setIdentity();
        identity = new TRSRTransformation(m);
        identity.getLeftRot();
        g = 3.0f + 2.0f * (float)Math.sqrt(2.0);
        cs = (float)Math.cos(0.39269908169872414);
        ss = (float)Math.sin(0.39269908169872414);
        sq2 = 1.0f / (float)Math.sqrt(2.0);
    }
}

