/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

public class BlockInfo {
    private ard world;
    private atr block;
    private dt blockPos;
    private final boolean[][][] translucent = new boolean[3][3][3];
    private final int[][][] s = new int[3][3][3];
    private final int[][][] b = new int[3][3][3];
    private final float[][][][] skyLight = new float[3][2][2][2];
    private final float[][][][] blockLight = new float[3][2][2][2];
    private final float[][][] ao = new float[3][3][3];
    private float shx = 0.0f;
    private float shy = 0.0f;
    private float shz = 0.0f;
    private int cachedTint = -1;
    private int cachedMultiplier = -1;

    public int getColorMultiplier(int tint) {
        if (this.cachedTint == tint) {
            return this.cachedMultiplier;
        }
        this.cachedTint = tint;
        this.cachedMultiplier = this.block.a(this.world, this.blockPos, tint);
        return this.cachedMultiplier;
    }

    public void updateShift() {
        this.shz = 0.0f;
        this.shy = 0.0f;
        this.shx = 0.0f;
        long rand = 0L;
        switch (this.block.Q()) {
            case c: {
                rand = uv.a((fd)this.blockPos);
                this.shy = ((float)(rand >> 20 & 0xFL) / 15.0f - 1.0f) * 0.2f;
            }
            case b: {
                this.shx = ((float)(rand >> 16 & 0xFL) / 15.0f - 0.5f) * 0.5f;
                this.shz = ((float)(rand >> 24 & 0xFL) / 15.0f - 0.5f) * 0.5f;
            }
        }
    }

    public void setWorld(ard world) {
        this.world = world;
        this.cachedTint = -1;
        this.cachedMultiplier = -1;
    }

    public void setBlock(atr block) {
        this.block = block;
        this.cachedTint = -1;
        this.cachedMultiplier = -1;
    }

    public void setBlockPos(dt blockPos) {
        this.blockPos = blockPos;
        this.cachedTint = -1;
        this.cachedMultiplier = -1;
    }

    private float combine(int c, int s1, int s2, int s3) {
        if (c == 0) {
            c = Math.max(0, Math.max(s1, s2) - 1);
        }
        if (s1 == 0) {
            s1 = Math.max(0, c - 1);
        }
        if (s2 == 0) {
            s2 = Math.max(0, c - 1);
        }
        if (s3 == 0) {
            s3 = Math.max(0, Math.max(s1, s2) - 1);
        }
        return (float)(c + s1 + s2 + s3) * 32.0f / 262140.0f;
    }

    public void updateLightMatrix() {
        int z;
        int y;
        int x2;
        boolean full = false;
        for (x2 = 0; x2 <= 2; ++x2) {
            for (y = 0; y <= 2; ++y) {
                for (z = 0; z <= 2; ++z) {
                    dt pos = this.blockPos.a(x2 - 1, y - 1, z - 1);
                    atr block = this.world.p(pos).c();
                    this.translucent[x2][y][z] = block.o();
                    int brightness = this.block.c(this.world, pos);
                    this.s[x2][y][z] = brightness >> 20 & 0xF;
                    this.b[x2][y][z] = brightness >> 4 & 0xF;
                    this.ao[x2][y][z] = block.f();
                    if (x2 != 1 || y != 1 || z != 1) continue;
                    full = block.d();
                }
            }
        }
        if (!full) {
            for (ej side : ej.values()) {
                int x3 = side.g() + 1;
                int y2 = side.h() + 1;
                int z2 = side.i() + 1;
                this.s[x3][y2][z2] = Math.max(this.s[1][1][1] - 1, this.s[x3][y2][z2]);
                this.b[x3][y2][z2] = Math.max(this.b[1][1][1] - 1, this.b[x3][y2][z2]);
            }
        }
        for (x2 = 0; x2 < 2; ++x2) {
            for (y = 0; y < 2; ++y) {
                for (z = 0; z < 2; ++z) {
                    int x1 = x2 * 2;
                    int y1 = y * 2;
                    int z1 = z * 2;
                    boolean tx = this.translucent[x1][1][z1] || this.translucent[x1][y1][1];
                    this.skyLight[0][x2][y][z] = this.combine(this.s[x1][1][1], this.s[x1][1][z1], this.s[x1][y1][1], tx ? this.s[x1][y1][z1] : this.s[x1][1][1]);
                    this.blockLight[0][x2][y][z] = this.combine(this.b[x1][1][1], this.b[x1][1][z1], this.b[x1][y1][1], tx ? this.b[x1][y1][z1] : this.b[x1][1][1]);
                    boolean ty = this.translucent[x1][y1][1] || this.translucent[1][y1][z1];
                    this.skyLight[1][x2][y][z] = this.combine(this.s[1][y1][1], this.s[x1][y1][1], this.s[1][y1][z1], ty ? this.s[x1][y1][z1] : this.s[1][y1][1]);
                    this.blockLight[1][x2][y][z] = this.combine(this.b[1][y1][1], this.b[x1][y1][1], this.b[1][y1][z1], ty ? this.b[x1][y1][z1] : this.b[1][y1][1]);
                    boolean tz = this.translucent[1][y1][z1] || this.translucent[1][y1][z1];
                    this.skyLight[2][x2][y][z] = this.combine(this.s[1][1][z1], this.s[1][y1][z1], this.s[x1][1][z1], tz ? this.s[x1][y1][z1] : this.s[1][1][z1]);
                    this.blockLight[2][x2][y][z] = this.combine(this.b[1][1][z1], this.b[1][y1][z1], this.b[x1][1][z1], tz ? this.b[x1][y1][z1] : this.b[1][1][z1]);
                }
            }
        }
    }

    public ard getWorld() {
        return this.world;
    }

    public atr getBlock() {
        return this.block;
    }

    public dt getBlockPos() {
        return this.blockPos;
    }

    public boolean[][][] getTranslucent() {
        return this.translucent;
    }

    public float[][][][] getSkyLight() {
        return this.skyLight;
    }

    public float[][][][] getBlockLight() {
        return this.blockLight;
    }

    public float[][][] getAo() {
        return this.ao;
    }

    public float getShx() {
        return this.shx;
    }

    public float getShy() {
        return this.shy;
    }

    public float getShz() {
        return this.shz;
    }

    public int getCachedTint() {
        return this.cachedTint;
    }

    public int getCachedMultiplier() {
        return this.cachedMultiplier;
    }
}

