/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.IColoredBakedQuad;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import net.minecraftforge.client.model.pipeline.WorldRendererConsumer;

public class LightUtil {
    private static final LoadingCache<cus, int[]> formatMaps = CacheBuilder.newBuilder().maximumSize(10L).build((CacheLoader)new CacheLoader<cus, int[]>(){

        public int[] load(cus format) {
            return LightUtil.mapFormats(format, cuq.b);
        }
    });
    private static IVertexConsumer tessellator = null;
    private static ItemConsumer itemConsumer = null;

    public static float diffuseLight(float x2, float y, float z) {
        float s2 = (float)Math.pow(2.0, 0.5);
        float y1 = y + 3.0f - 2.0f * s2;
        return x2 * x2 * 0.6f + y1 * y1 * (3.0f + 2.0f * s2) / 8.0f + z * z * 0.8f;
    }

    public static float diffuseLight(ej side) {
        switch (side) {
            case a: {
                return 0.5f;
            }
            case b: {
                return 1.0f;
            }
            case c: 
            case d: {
                return 0.8f;
            }
        }
        return 0.6f;
    }

    public static ej toSide(float x2, float y, float z) {
        if (Math.abs(x2) > Math.abs(y)) {
            if (Math.abs(x2) > Math.abs(z)) {
                if (x2 < 0.0f) {
                    return ej.e;
                }
                return ej.f;
            }
            if (z < 0.0f) {
                return ej.c;
            }
            return ej.d;
        }
        if (Math.abs(y) > Math.abs(z)) {
            if (y < 0.0f) {
                return ej.a;
            }
            return ej.b;
        }
        if (z < 0.0f) {
            return ej.c;
        }
        return ej.d;
    }

    public static void putBakedQuad(IVertexConsumer consumer, clt quad) {
        consumer.setQuadOrientation(quad.d());
        if (quad.b()) {
            consumer.setQuadTint(quad.c());
        }
        if (quad instanceof IColoredBakedQuad) {
            consumer.setQuadColored();
        }
        float[] data = new float[4];
        int[] eMap = (int[])formatMaps.getUnchecked((Object)consumer.getVertexFormat());
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < consumer.getVertexFormat().h(); ++e) {
                if (eMap[e] != cuq.b.h()) {
                    LightUtil.unpack(quad.a(), data, cuq.b, v, eMap[e]);
                    consumer.put(e, data);
                    continue;
                }
                consumer.put(e, new float[0]);
            }
        }
    }

    public static int[] mapFormats(cus from, cus to) {
        int[] eMap = new int[from.h()];
        for (int e = 0; e < from.h(); ++e) {
            int e2;
            cuu expected = from.c(e);
            for (e2 = 0; e2 < to.h(); ++e2) {
                cuu current = to.c(e2);
                if (expected.c() == current.c() && expected.e() == current.e()) break;
            }
            eMap[e] = e2;
        }
        return eMap;
    }

    public static void unpack(int[] from, float[] to, cus formatFrom, int v, int e) {
        cuu element = formatFrom.c(e);
        for (int i = 0; i < 4; ++i) {
            if (i < element.d()) {
                int pos = v * formatFrom.f() + element.a() + element.b().a() * i;
                int index = pos >> 2;
                int offset = pos & 3;
                int bits = from[index];
                bits >>>= offset * 8;
                if ((pos + element.b().a() - 1) / 4 != index) {
                    bits |= from[index + 1] << (4 - offset) * 8;
                }
                int mask = (256 << 8 * (element.b().a() - 1)) - 1;
                bits &= mask;
                switch (element.b()) {
                    case a: {
                        to[i] = Float.intBitsToFloat(bits);
                        break;
                    }
                    case b: 
                    case d: {
                        to[i] = (float)bits / (float)mask;
                        break;
                    }
                    case f: {
                        to[i] = (float)((double)((long)bits & 0xFFFFFFFFL) / 4.294967295E9);
                        break;
                    }
                    case c: {
                        to[i] = (float)((byte)bits) / (float)mask * 2.0f;
                        break;
                    }
                    case e: {
                        to[i] = (float)((short)bits) / (float)mask * 2.0f;
                        break;
                    }
                    case g: {
                        to[i] = (float)((long)bits & 0xFFFFFFFFL) / 4.2949673E9f * 2.0f;
                    }
                }
                continue;
            }
            to[i] = 0.0f;
        }
    }

    public static void pack(float[] from, int[] to, cus formatTo, int v, int e) {
        cuu element = formatTo.c(e);
        for (int i = 0; i < 4; ++i) {
            if (i >= element.d()) continue;
            int pos = v * formatTo.f() + element.a() + element.b().a() * i;
            int index = pos >> 2;
            int offset = pos & 3;
            int bits = 0;
            int mask = (256 << 8 * (element.b().a() - 1)) - 1;
            switch (element.b()) {
                case a: {
                    bits = Float.floatToRawIntBits(from[i]);
                    break;
                }
                case b: 
                case d: 
                case f: {
                    bits = (int)(from[i] * (float)mask);
                    break;
                }
                case c: 
                case e: 
                case g: {
                    bits = (int)(from[i] * (float)mask / 2.0f);
                }
            }
            int n = index;
            to[n] = to[n] & ~(mask << offset * 8);
            int n2 = index;
            to[n2] = to[n2] | (bits & mask) << offset * 8;
        }
    }

    public static IVertexConsumer getTessellator() {
        if (tessellator == null) {
            ckx tes = ckx.a();
            civ wr = tes.c();
            tessellator = new WorldRendererConsumer(wr);
        }
        return tessellator;
    }

    public static ItemConsumer getItemConsumer() {
        if (itemConsumer == null) {
            itemConsumer = new ItemConsumer(LightUtil.getTessellator());
        }
        return itemConsumer;
    }

    public static void renderQuadColorSlow(civ wr, clt quad, int auxColor) {
        ItemConsumer cons = wr == ckx.a().c() ? LightUtil.getItemConsumer() : new ItemConsumer(new WorldRendererConsumer(wr));
        float b = (float)(auxColor & 0xFF) / 255.0f;
        float g = (float)(auxColor >>> 8 & 0xFF) / 255.0f;
        float r = (float)(auxColor >>> 16 & 0xFF) / 255.0f;
        float a2 = (float)(auxColor >>> 24 & 0xFF) / 255.0f;
        cons.setAuxColor(r, g, b, a2);
        quad.pipe((IVertexConsumer)cons);
    }

    public static void renderQuadColor(civ wr, clt quad, int auxColor) {
        wr.a(quad.a());
        if (quad instanceof IColoredBakedQuad) {
            ForgeHooksClient.putQuadColor(wr, quad, auxColor);
        } else {
            wr.d(auxColor);
        }
    }

    public static class ItemConsumer
    extends VertexTransformer {
        private boolean colored = false;
        private int vertices = 0;
        private float[] auxColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        private float[] buf = new float[4];

        public ItemConsumer(IVertexConsumer parent) {
            super(parent);
        }

        public void setAuxColor(float ... auxColor) {
            System.arraycopy(auxColor, 0, this.auxColor, 0, this.auxColor.length);
        }

        @Override
        public void setQuadColored() {
            this.colored = true;
        }

        @Override
        public void put(int element, float ... data) {
            if (this.getVertexFormat().c(element).c() == cuw.c) {
                System.arraycopy(this.auxColor, 0, this.buf, 0, this.buf.length);
                if (this.colored) {
                    for (int i = 0; i < 4; ++i) {
                        int n = i;
                        this.buf[n] = this.buf[n] * data[i];
                    }
                }
                super.put(element, this.buf);
            } else {
                super.put(element, data);
            }
            if (element == this.getVertexFormat().h() - 1) {
                ++this.vertices;
                if (this.vertices == 4) {
                    this.vertices = 0;
                    this.colored = false;
                }
            }
        }
    }
}

