/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import net.minecraftforge.client.model.pipeline.IVertexConsumer;

public abstract class QuadGatheringTransformer
implements IVertexConsumer {
    protected IVertexConsumer parent;
    protected cus format;
    protected int vertices = 0;
    protected float[][][] quadData = null;

    public void setParent(IVertexConsumer parent) {
        this.parent = parent;
    }

    public void setVertexFormat(cus format) {
        this.format = format;
        this.quadData = new float[format.h()][4][4];
    }

    @Override
    public cus getVertexFormat() {
        return this.format;
    }

    @Override
    public void put(int element, float ... data) {
        System.arraycopy(data, 0, this.quadData[element][this.vertices], 0, data.length);
        if (element == this.getVertexFormat().h() - 1) {
            ++this.vertices;
        }
        if (this.vertices == 4) {
            this.vertices = 0;
            this.processQuad();
        }
    }

    protected abstract void processQuad();
}

