/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import net.minecraftforge.client.model.pipeline.VertexLighterFlat;

public class VertexLighterSmoothAo
extends VertexLighterFlat {
    @Override
    protected void updateLightmap(float[] normal, float[] lightmap, float x2, float y, float z) {
        lightmap[0] = this.calcLightmap(this.blockInfo.getBlockLight(), x2, y, z);
        lightmap[1] = this.calcLightmap(this.blockInfo.getSkyLight(), x2, y, z);
    }

    @Override
    protected void updateColor(float[] normal, float[] color, float x2, float y, float z, float tint, int multiplier) {
        if (tint != -1.0f) {
            color[0] = color[0] * ((float)(multiplier >> 16 & 0xFF) / 255.0f);
            color[1] = color[1] * ((float)(multiplier >> 8 & 0xFF) / 255.0f);
            color[2] = color[2] * ((float)(multiplier & 0xFF) / 255.0f);
        }
        float a2 = this.getAo(x2, y, z);
        color[0] = color[0] * a2;
        color[1] = color[1] * a2;
        color[2] = color[2] * a2;
    }

    protected float calcLightmap(float[][][][] light, float x2, float y, float z) {
        float s;
        float l2;
        if ((l2 = (x2 *= 2.0f) * x2 + (y *= 2.0f) * y + (z *= 2.0f) * z) > 5.98f) {
            float s2 = (float)Math.sqrt(5.98f / l2);
            x2 *= s2;
            y *= s2;
            z *= s2;
        }
        float ax = Math.abs(x2);
        float ay = Math.abs(y);
        float az = Math.abs(z);
        float e1 = 1.0001f;
        if (ax > 1.9999f && ay <= e1 && az <= e1) {
            x2 = uv.a((float)x2, (float)-1.9999f, (float)1.9999f);
        } else if (ay > 1.9999f && az <= e1 && ax <= e1) {
            y = uv.a((float)y, (float)-1.9999f, (float)1.9999f);
        } else if (az > 1.9999f && ax <= e1 && ay <= e1) {
            z = uv.a((float)z, (float)-1.9999f, (float)1.9999f);
        }
        ax = Math.abs(x2);
        ay = Math.abs(y);
        az = Math.abs(z);
        if (ax <= e1 && ay + az > 2.9999f) {
            s = 2.9999f / (ay + az);
            y *= s;
            z *= s;
        } else if (ay <= e1 && az + ax > 2.9999f) {
            s = 2.9999f / (az + ax);
            z *= s;
            x2 *= s;
        } else if (az <= e1 && ax + ay > 2.9999f) {
            s = 2.9999f / (ax + ay);
            x2 *= s;
            y *= s;
        } else if (ax + ay + az > 3.9999f) {
            s = 3.9999f / (ax + ay + az);
            x2 *= s;
            y *= s;
            z *= s;
        }
        float l = 0.0f;
        float s3 = 0.0f;
        for (int ix = 0; ix <= 1; ++ix) {
            for (int iy = 0; iy <= 1; ++iy) {
                for (int iz = 0; iz <= 1; ++iz) {
                    float vx = x2 * (float)(1 - ix * 2);
                    float vy = y * (float)(1 - iy * 2);
                    float vz = z * (float)(1 - iz * 2);
                    float s32 = vx + vy + vz + 4.0f;
                    float sx = vy + vz + 3.0f;
                    float sy = vz + vx + 3.0f;
                    float sz = vx + vy + 3.0f;
                    float bx = (2.0f * vx + vy + vz + 6.0f) / (s32 * sy * sz * (vx + 2.0f));
                    s3 += bx;
                    l += bx * light[0][ix][iy][iz];
                    float by = (2.0f * vy + vz + vx + 6.0f) / (s32 * sz * sx * (vy + 2.0f));
                    s3 += by;
                    l += by * light[1][ix][iy][iz];
                    float bz = (2.0f * vz + vx + vy + 6.0f) / (s32 * sx * sy * (vz + 2.0f));
                    s3 += bz;
                    l += bz * light[2][ix][iy][iz];
                }
            }
        }
        if ((l /= s3) > 0.0073243305f) {
            l = 0.0073243305f;
        }
        if (l < 0.0f) {
            l = 0.0f;
        }
        return l;
    }

    protected float getAo(float x2, float y, float z) {
        int sz;
        int sx = x2 < 0.0f ? 1 : 2;
        int sy = y < 0.0f ? 1 : 2;
        int n = sz = z < 0.0f ? 1 : 2;
        if (x2 < 0.0f) {
            x2 += 1.0f;
        }
        if (y < 0.0f) {
            y += 1.0f;
        }
        if (z < 0.0f) {
            z += 1.0f;
        }
        float a2 = 0.0f;
        float[][][] ao = this.blockInfo.getAo();
        a2 += ao[sx - 1][sy - 1][sz - 1] * (1.0f - x2) * (1.0f - y) * (1.0f - z);
        a2 += ao[sx - 1][sy - 1][sz - 0] * (1.0f - x2) * (1.0f - y) * (0.0f + z);
        a2 += ao[sx - 1][sy - 0][sz - 1] * (1.0f - x2) * (0.0f + y) * (1.0f - z);
        a2 += ao[sx - 1][sy - 0][sz - 0] * (1.0f - x2) * (0.0f + y) * (0.0f + z);
        a2 += ao[sx - 0][sy - 1][sz - 1] * (0.0f + x2) * (1.0f - y) * (1.0f - z);
        a2 += ao[sx - 0][sy - 1][sz - 0] * (0.0f + x2) * (1.0f - y) * (0.0f + z);
        a2 += ao[sx - 0][sy - 0][sz - 1] * (0.0f + x2) * (0.0f + y) * (1.0f - z);
        a2 += ao[sx - 0][sy - 0][sz - 0] * (0.0f + x2) * (0.0f + y) * (0.0f + z);
        a2 = uv.a((float)a2, (float)0.0f, (float)1.0f);
        return a2;
    }

    @Override
    public void updateBlockInfo() {
        super.updateBlockInfo();
        this.blockInfo.updateLightMatrix();
    }
}

