/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.brewing;

import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.oredict.OreDictionary;

public abstract class AbstractBrewingRecipe<T>
implements IBrewingRecipe {
    public final amj input;
    public final T ingredient;
    public final amj output;

    protected AbstractBrewingRecipe(amj input, T ingredient, amj output) {
        this.input = input;
        this.ingredient = ingredient;
        this.output = output;
        if (this.input == null || this.ingredient == null || this.output == null) {
            throw new IllegalArgumentException("A brewing recipe cannot have a null parameter.");
        }
        if (this.input.c() != 1) {
            throw new IllegalArgumentException("Inputs must have a max size of 1 just like water bottles. Brewing Stands override the input with the output when the brewing is done, items that stack would end up getting lost.");
        }
    }

    @Override
    public boolean isInput(amj stack) {
        return OreDictionary.itemMatches(this.input, stack, false);
    }

    @Override
    public amj getOutput(amj input, amj ingredient) {
        return this.isInput(input) && this.isIngredient(ingredient) ? amj.b((amj)this.output) : null;
    }
}

