/*
 * Decompiled with CFR 0.152.
 */
package forge;

import forge.IHighlightHandler;
import forge.IItemRenderer;
import forge.IMultipassRender;
import forge.IRenderContextHandler;
import forge.IRenderWorldLastHandler;
import forge.ITextureLoadHandler;
import forge.ITextureProvider;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TreeSet;
import org.lwjgl.opengl.GL11;

public class ForgeHooksClient {
    public static LinkedList<IHighlightHandler> highlightHandlers = new LinkedList();
    public static LinkedList<IRenderWorldLastHandler> renderWorldLastHandlers = new LinkedList();
    public static LinkedList<ITextureLoadHandler> textureLoadHandlers = new LinkedList();
    public static HashMap<TesKey, adz> tessellators = new HashMap();
    public static HashMap<String, Integer> textures = new HashMap();
    public static boolean inWorld = false;
    public static TreeSet<TesKey> renderTextures = new TreeSet();
    public static adz defaultTessellator = null;
    public static HashMap<TesKey, IRenderContextHandler> renderHandlers = new HashMap();
    public static IRenderContextHandler unbindContext = null;
    static int renderPass = -1;

    public static boolean onBlockHighlight(l render, yw player, pl target, int i, aan itemstack, float partialTicks) {
        for (IHighlightHandler handler : highlightHandlers) {
            if (!handler.onBlockHighlight(render, player, target, i, itemstack, partialTicks)) continue;
            return true;
        }
        return false;
    }

    public static void onRenderWorldLast(l render, float partialTicks) {
        for (IRenderWorldLastHandler handler : renderWorldLastHandlers) {
            handler.onRenderWorldLast(render, partialTicks);
        }
    }

    public static void onTextureLoad(String textureName, int textureID) {
        for (ITextureLoadHandler handler : textureLoadHandlers) {
            handler.onTextureLoad(textureName, textureID);
        }
    }

    public static boolean canRenderInPass(pb block, int pass) {
        if (block instanceof IMultipassRender) {
            return ((IMultipassRender)((Object)block)).canRenderInPass(pass);
        }
        return pass == block.c();
    }

    protected static void registerRenderContextHandler(String texture, int subID, IRenderContextHandler handler) {
        Integer texID = textures.get(texture);
        if (texID == null) {
            texID = ModLoader.getMinecraftInstance().p.b(texture);
            textures.put(texture, texID);
        }
        renderHandlers.put(new TesKey(texID, subID), handler);
    }

    protected static void bindTessellator(int texture, int subID) {
        TesKey key = new TesKey(texture, subID);
        adz tess = tessellators.get(key);
        if (tess == null) {
            tess = new adz();
            tessellators.put(key, tess);
        }
        if (inWorld && !renderTextures.contains(key)) {
            renderTextures.add(key);
            tess.b();
            tess.b(ForgeHooksClient.defaultTessellator.v, ForgeHooksClient.defaultTessellator.w, ForgeHooksClient.defaultTessellator.x);
        }
        adz.a = tess;
    }

    protected static void bindTexture(String texture, int subID) {
        Integer texID = textures.get(texture);
        if (texID == null) {
            texID = ModLoader.getMinecraftInstance().p.b(texture);
            textures.put(texture, texID);
        }
        if (!inWorld) {
            if (unbindContext != null) {
                unbindContext.afterRenderContext();
                unbindContext = null;
            }
            if (adz.a.z) {
                int mode = adz.a.u;
                adz.a.a();
                adz.a.a(mode);
            }
            GL11.glBindTexture((int)3553, (int)texID);
            unbindContext = renderHandlers.get(new TesKey(texID, subID));
            if (unbindContext != null) {
                unbindContext.beforeRenderContext();
            }
            return;
        }
        ForgeHooksClient.bindTessellator(texID, subID);
    }

    protected static void unbindTexture() {
        if (!inWorld) {
            if (adz.a.z) {
                int mode = adz.a.u;
                adz.a.a();
                if (unbindContext != null) {
                    unbindContext.afterRenderContext();
                    unbindContext = null;
                }
                adz.a.a(mode);
            }
            GL11.glBindTexture((int)3553, (int)ModLoader.getMinecraftInstance().p.b("/terrain.png"));
            return;
        }
        adz.a = defaultTessellator;
    }

    public static void beforeRenderPass(int pass) {
        renderPass = pass;
        defaultTessellator = adz.a;
        adz.renderingWorldRenderer = true;
        GL11.glBindTexture((int)3553, (int)ModLoader.getMinecraftInstance().p.b("/terrain.png"));
        renderTextures.clear();
        inWorld = true;
    }

    public static void afterRenderPass(int pass) {
        renderPass = -1;
        inWorld = false;
        for (TesKey info : renderTextures) {
            IRenderContextHandler handler = renderHandlers.get(info);
            GL11.glBindTexture((int)3553, (int)info.tex);
            adz tess = tessellators.get(info);
            if (handler == null) {
                tess.a();
                continue;
            }
            adz.a = tess;
            handler.beforeRenderContext();
            tess.a();
            handler.afterRenderContext();
        }
        GL11.glBindTexture((int)3553, (int)ModLoader.getMinecraftInstance().p.b("/terrain.png"));
        adz.renderingWorldRenderer = false;
        adz.a = defaultTessellator;
    }

    public static void beforeBlockRender(pb block, vl render) {
        if (block instanceof ITextureProvider && render.d == -1) {
            ForgeHooksClient.bindTexture(((ITextureProvider)((Object)block)).getTextureFile(), 0);
        }
    }

    public static void afterBlockRender(pb block, vl render) {
        if (block instanceof ITextureProvider && render.d == -1) {
            ForgeHooksClient.unbindTexture();
        }
    }

    public static void overrideTexture(Object obj) {
        if (obj instanceof ITextureProvider) {
            GL11.glBindTexture((int)3553, (int)ModLoader.getMinecraftInstance().p.b(((ITextureProvider)obj).getTextureFile()));
        }
    }

    public static String getTexture(String def, Object obj) {
        if (obj instanceof ITextureProvider) {
            return ((ITextureProvider)obj).getTextureFile();
        }
        return def;
    }

    public static void renderEquippedItem(IItemRenderer customRenderer, vl renderBlocks, acq entity, aan item) {
        if (customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.EQUIPPED, item, IItemRenderer.ItemRendererHelper.EQUIPPED_BLOCK)) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            customRenderer.renderItem(IItemRenderer.ItemRenderType.EQUIPPED, item, renderBlocks, entity);
            GL11.glPopMatrix();
        } else {
            GL11.glPushMatrix();
            GL11.glEnable((int)32826);
            GL11.glTranslatef((float)0.0f, (float)-0.3f, (float)0.0f);
            GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
            GL11.glRotatef((float)50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)335.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.9375f, (float)-0.0625f, (float)0.0f);
            customRenderer.renderItem(IItemRenderer.ItemRenderType.EQUIPPED, item, renderBlocks, entity);
            GL11.glDisable((int)32826);
            GL11.glPopMatrix();
        }
    }

    private static class TesKey
    implements Comparable<TesKey> {
        public int tex;
        public int sub;

        public TesKey(int textureID, int subID) {
            this.tex = textureID;
            this.sub = subID;
        }

        @Override
        public int compareTo(TesKey key) {
            if (this.sub == key.sub) {
                return this.tex - key.tex;
            }
            return this.sub - key.sub;
        }

        public boolean equals(Object obj) {
            return this.compareTo((TesKey)obj) == 0;
        }

        public int hashCode() {
            int c1 = Integer.valueOf(this.tex).hashCode();
            int c2 = Integer.valueOf(this.sub).hashCode();
            return c1 + 31 * c2;
        }
    }
}

