/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import cpw.mods.fml.common.IFMLSidedHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class FMLCommonHandler {
    private static final FMLCommonHandler INSTANCE = new FMLCommonHandler();
    private Map<ModContainer, Set<String>> channelList = new HashMap<ModContainer, Set<String>>();
    private Map<String, ModContainer> modChannels = new HashMap<String, ModContainer>();
    private Map<Object, Set<String>> activeChannels = new HashMap<Object, Set<String>>();
    private IFMLSidedHandler sidedDelegate;

    public void registerSidedDelegate(IFMLSidedHandler handler) {
        this.sidedDelegate = handler;
    }

    public void gameTickStart() {
        for (ModContainer mod : Loader.getModList()) {
            mod.tickStart();
        }
    }

    public void gameTickEnd() {
        for (ModContainer mod : Loader.getModList()) {
            mod.tickEnd();
        }
    }

    public static FMLCommonHandler instance() {
        return INSTANCE;
    }

    public ModContainer getModForChannel(String channel) {
        return this.modChannels.get(channel);
    }

    public Set<String> getChannelListFor(ModContainer container) {
        return this.channelList.get(container);
    }

    public void registerChannel(ModContainer container, String channelName) {
        Set<String> list;
        if (this.modChannels.containsKey(channelName)) {
            // empty if block
        }
        if ((list = this.channelList.get(container)) == null) {
            list = new HashSet<String>();
            this.channelList.put(container, list);
        }
        list.add(channelName);
        this.modChannels.put(channelName, container);
    }

    public void activateChannel(Object player, String channel) {
        Set<String> active = this.activeChannels.get(player);
        if (active == null) {
            active = new HashSet<String>();
            this.activeChannels.put(player, active);
        }
        active.add(channel);
    }

    public void deactivateChannel(Object player, String channel) {
        Set<String> active = this.activeChannels.get(player);
        if (active == null) {
            active = new HashSet<String>();
            this.activeChannels.put(player, active);
        }
        active.remove(channel);
    }

    public byte[] getPacketRegistry() {
        StringBuffer sb2 = new StringBuffer();
        for (String chan : this.modChannels.keySet()) {
            sb2.append(chan).append("\u0000");
        }
        try {
            return sb2.toString().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            Loader.log.warning("Error building registration list");
            Loader.log.throwing("FMLHooks", "getPacketRegistry", e);
            return new byte[0];
        }
    }

    public boolean isChannelActive(String channel, Object player) {
        return this.activeChannels.get(player).contains(channel);
    }

    public Logger getFMLLogger() {
        return Loader.log;
    }

    public Logger getMinecraftLogger() {
        return this.sidedDelegate.getMinecraftLogger();
    }

    public boolean isModLoaderMod(Class<?> clazz) {
        return this.sidedDelegate.isModLoaderMod(clazz);
    }

    public ModContainer loadBaseModMod(Class<?> clazz, String canonicalPath) {
        return this.sidedDelegate.loadBaseModMod(clazz, canonicalPath);
    }

    public File getMinecraftRootDirectory() {
        return this.sidedDelegate.getMinecraftRootDirectory();
    }
}

