/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLModContainer;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModClassLoader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.toposort.ModSorter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Loader {
    private static Pattern zipJar = Pattern.compile("(.+).(zip|jar)$");
    private static Pattern modClass = Pattern.compile("(.+/|)(mod\\_[^\\s$]+).class$");
    private static Loader instance;
    public static Logger log;
    private static String major;
    private static String minor;
    private static String rev;
    private static String build;
    private static String mcversion;
    private State state;
    private ModClassLoader modClassLoader;
    private List<ModContainer> mods;
    private Map<String, ModContainer> namedMods;
    private File canonicalConfigDir;
    private File canonicalMinecraftDir;

    public static Loader instance() {
        if (instance == null) {
            instance = new Loader();
        }
        return instance;
    }

    private Loader() {
        log.setParent(FMLCommonHandler.instance().getMinecraftLogger());
        log.setLevel(Level.ALL);
        try {
            FileHandler fileHandler = new FileHandler("ForgeModLoader-%g.log", 0, 3);
            fileHandler.setFormatter(FMLCommonHandler.instance().getMinecraftLogger().getHandlers()[0].getFormatter());
            fileHandler.setLevel(Level.ALL);
            log.addHandler(fileHandler);
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.info(String.format("Forge Mod Loader version %s.%s.%s.%s for Minecraft %s loading", major, minor, rev, build, mcversion));
    }

    private void sortModList() {
        log.fine("Verifying mod dependencies are satisfied");
        for (ModContainer mod : this.mods) {
            if (this.namedMods.keySet().containsAll(mod.getDependencies())) continue;
            log.severe(String.format("The mod %s requires mods %s to be available, one or more are not", mod.getName(), mod.getDependencies()));
            LoaderException le2 = new LoaderException();
            log.throwing("Loader", "sortModList", le2);
            throw new LoaderException();
        }
        log.fine("All dependencies are satisfied");
        ModSorter sorter = new ModSorter(this.mods, this.namedMods);
        try {
            log.fine("Sorting mods into an ordered list");
            this.mods = sorter.sort();
            log.fine(String.format("Sorted mod list %s", this.mods));
        }
        catch (IllegalArgumentException iae) {
            log.severe("A dependency cycle was detected in the input mod set so they cannot be loaded in order");
            log.throwing("Loader", "sortModList", iae);
            throw new LoaderException(iae);
        }
    }

    private void preModInit() {
        this.state = State.PREINIT;
        log.fine("Beginning mod pre-initialization");
        for (ModContainer mod : this.mods) {
            if (!mod.wantsPreInit()) continue;
            log.finer(String.format("Pre-initializing %s", mod.getSource()));
            mod.preInit();
            this.namedMods.put(mod.getName(), mod);
        }
        log.fine("Mod pre-initialization complete");
    }

    private void modInit() {
        this.state = State.INIT;
        log.fine("Beginning mod initialization");
        for (ModContainer mod : this.mods) {
            log.finer(String.format("Initializing %s", mod.getName()));
            mod.init();
        }
        log.fine("Mod initialization complete");
    }

    private void postModInit() {
        this.state = State.POSTINIT;
        log.fine("Beginning mod post-initialization");
        for (ModContainer mod : this.mods) {
            if (!mod.wantsPostInit()) continue;
            log.finer(String.format("Post-initializing %s", mod.getName()));
            mod.postInit();
        }
        log.fine("Mod post-initialization complete");
    }

    private void load() {
        String canonicalConfigPath;
        String canonicalModsPath;
        File minecraftDir = FMLCommonHandler.instance().getMinecraftRootDirectory();
        File modsDir = new File(minecraftDir, "mods");
        File configDir = new File(minecraftDir, "config");
        try {
            this.canonicalMinecraftDir = minecraftDir.getCanonicalFile();
            canonicalModsPath = modsDir.getCanonicalPath();
            canonicalConfigPath = configDir.getCanonicalPath();
            this.canonicalConfigDir = configDir.getCanonicalFile();
        }
        catch (IOException ioe) {
            log.severe(String.format("Failed to resolve mods directory mods %s", modsDir.getAbsolutePath()));
            log.throwing("fml.server.Loader", "initialize", ioe);
            throw new LoaderException(ioe);
        }
        if (!modsDir.exists()) {
            log.fine(String.format("No mod directory found, creating one: %s", canonicalModsPath));
            try {
                modsDir.mkdir();
            }
            catch (Exception e) {
                log.throwing("fml.server.Loader", "initialize", e);
                throw new LoaderException(e);
            }
        }
        if (!configDir.exists()) {
            log.fine(String.format("No config directory found, creating one: %s", canonicalConfigPath));
            try {
                configDir.mkdir();
            }
            catch (Exception e) {
                log.throwing("fml.server.Loader", "initialize", e);
                throw new LoaderException(e);
            }
        }
        if (!modsDir.isDirectory()) {
            log.severe(String.format("Attempting to load mods from %s, which is not a directory", canonicalModsPath));
            LoaderException loaderException = new LoaderException();
            log.throwing("fml.server.Loader", "initialize", loaderException);
            throw loaderException;
        }
        if (!configDir.isDirectory()) {
            log.severe(String.format("Attempting to load configuration from %s, which is not a directory", canonicalConfigPath));
            LoaderException loaderException = new LoaderException();
            log.throwing("fml.server.Loader", "initialize", loaderException);
            throw loaderException;
        }
        this.state = State.LOADING;
        this.modClassLoader = new ModClassLoader();
        log.fine("Attempting to load mods contained in the minecraft jar file and associated classes");
        File[] minecraftSources = this.modClassLoader.getParentSources();
        if (minecraftSources.length == 1 && minecraftSources[0].isFile()) {
            log.fine(String.format("Minecraft is a file at %s, loading", minecraftSources[0].getAbsolutePath()));
            this.attemptFileLoad(minecraftSources[0]);
        } else {
            for (int i = 0; i < minecraftSources.length; ++i) {
                if (minecraftSources[i].isFile()) {
                    log.fine(String.format("Found a minecraft related file at %s, loading", minecraftSources[i].getAbsolutePath()));
                    this.attemptFileLoad(minecraftSources[i]);
                    continue;
                }
                if (!minecraftSources[i].isDirectory()) continue;
                log.fine(String.format("Found a minecraft related directory at %s, loading", minecraftSources[i].getAbsolutePath()));
                this.attemptDirLoad(minecraftSources[i], "");
            }
        }
        log.fine("Minecraft jar mods loaded successfully");
        log.info(String.format("Loading mods from %s", canonicalModsPath));
        Object[] modList = modsDir.listFiles();
        Arrays.sort(modList);
        for (Object modFile : modList) {
            if (((File)modFile).isDirectory()) {
                log.fine(String.format("Found a directory %s, attempting to load it", ((File)modFile).getName()));
                boolean modFound = this.attemptDirLoad((File)modFile, "");
                if (modFound) {
                    log.fine(String.format("Directory %s loaded successfully", ((File)modFile).getName()));
                    continue;
                }
                log.info(String.format("Directory %s contained no mods", ((File)modFile).getName()));
                continue;
            }
            Matcher matcher = zipJar.matcher(((File)modFile).getName());
            if (!matcher.matches()) continue;
            log.fine(String.format("Found a zip or jar file %s, attempting to load it", matcher.group(0)));
            boolean modFound = this.attemptFileLoad((File)modFile);
            if (modFound) {
                log.fine(String.format("File %s loaded successfully", matcher.group(0)));
                continue;
            }
            log.info(String.format("File %s contained no mods", matcher.group(0)));
        }
        if (this.state == State.ERRORED) {
            log.severe("A problem has occured during mod loading, giving up now");
            throw new RuntimeException("Giving up please");
        }
        log.info(String.format("Forge Mod Loader has loaded %d mods", this.mods.size()));
    }

    private boolean attemptDirLoad(File modDir, String path) {
        if (path.length() == 0) {
            this.extendClassLoader(modDir);
        }
        boolean foundAModClass = false;
        Object[] content = modDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && modClass.matcher(file.getName()).find() || file.isDirectory();
            }
        });
        Arrays.sort(content);
        for (Object file : content) {
            if (((File)file).isDirectory()) {
                log.finest(String.format("Recursing into package %s", path + ((File)file).getName()));
                foundAModClass |= this.attemptDirLoad((File)file, path + ((File)file).getName() + ".");
                continue;
            }
            Matcher fname = modClass.matcher(((File)file).getName());
            if (!fname.find()) continue;
            String clazzName = path + fname.group(2);
            log.fine(String.format("Found a mod class %s in directory %s, attempting to load it", clazzName, modDir.getName()));
            this.loadModClass(modDir, ((File)file).getName(), clazzName);
            log.fine(String.format("Successfully loaded mod class %s", ((File)file).getName()));
            foundAModClass = true;
        }
        return foundAModClass;
    }

    private void loadModClass(File classSource, String classFileName, String clazzName) {
        try {
            Class<?> clazz = Class.forName(clazzName, false, this.modClassLoader);
            if (clazz.isAnnotationPresent(Mod.class)) {
                this.mods.add(FMLModContainer.buildFor(clazz));
            } else if (FMLCommonHandler.instance().isModLoaderMod(clazz)) {
                log.fine(String.format("ModLoader BaseMod class %s found, loading", clazzName));
                ModContainer mc = FMLCommonHandler.instance().loadBaseModMod(clazz, classSource.getCanonicalPath());
                this.mods.add(mc);
                log.fine(String.format("ModLoader BaseMod class %s loaded", clazzName));
            }
        }
        catch (Exception e) {
            log.warning(String.format("Failed to load mod class %s in %s", classFileName, classSource.getAbsoluteFile()));
            log.throwing("fml.server.Loader", "attemptLoad", e);
            this.state = State.ERRORED;
        }
    }

    private void extendClassLoader(File file) {
        try {
            this.modClassLoader.addFile(file);
        }
        catch (MalformedURLException e) {
            throw new LoaderException(e);
        }
    }

    private boolean attemptFileLoad(File modFile) {
        this.extendClassLoader(modFile);
        boolean foundAModClass = false;
        try {
            ZipFile jar = new ZipFile(modFile);
            for (ZipEntry zipEntry : Collections.list(jar.entries())) {
                Matcher match = modClass.matcher(zipEntry.getName());
                if (!match.matches()) continue;
                String pkg = match.group(1).replace('/', '.');
                String clazzName = pkg + match.group(2);
                log.fine(String.format("Found a mod class %s in file %s, attempting to load it", clazzName, modFile.getName()));
                this.loadModClass(modFile, zipEntry.getName(), clazzName);
                log.fine(String.format("Mod class %s loaded successfully", clazzName, modFile.getName()));
                foundAModClass = true;
            }
        }
        catch (Exception e) {
            log.warning(String.format("Zip file %s failed to read properly", modFile.getName()));
            log.throwing("fml.server.Loader", "attemptFileLoad", e);
            this.state = State.ERRORED;
        }
        return foundAModClass;
    }

    public static List<ModContainer> getModList() {
        return Loader.instance().mods;
    }

    public void loadMods() {
        this.state = State.NOINIT;
        this.mods = new ArrayList<ModContainer>();
        this.namedMods = new HashMap<String, ModContainer>();
        this.load();
        this.preModInit();
        this.sortModList();
        this.mods = Collections.unmodifiableList(this.mods);
    }

    public void initializeMods() {
        this.modInit();
        this.postModInit();
        this.state = State.UP;
        log.info(String.format("Forge Mod Loader load complete, %d mods loaded", this.mods.size()));
    }

    public static boolean isModLoaded(String modname) {
        return Loader.instance().namedMods.containsKey(modname);
    }

    public File getConfigDir() {
        return this.canonicalConfigDir;
    }

    static {
        log = Logger.getLogger("ForgeModLoader");
        major = "1";
        minor = "0";
        rev = "0";
        build = "68";
        mcversion = "1.2.5";
    }

    private static enum State {
        NOINIT,
        LOADING,
        PREINIT,
        INIT,
        POSTINIT,
        UP,
        ERRORED;

    }
}

