/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.server;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IFMLSidedHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.server.ModLoaderModContainer;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;

public class FMLServerHandler
implements IFMLSidedHandler {
    private static final FMLServerHandler INSTANCE = new FMLServerHandler();
    private MinecraftServer server;
    private lt[] defaultOverworldBiomes;

    public void onPreLoad(MinecraftServer minecraftServer) {
        this.server = minecraftServer;
        FMLCommonHandler.instance().registerSidedDelegate(this);
        CommonRegistry.registerRegistry(new ServerRegistry());
        Loader.instance().loadMods();
    }

    public void onLoadComplete() {
        Loader.instance().initializeMods();
    }

    public void onPreTick() {
        FMLCommonHandler.instance().gameTickStart();
    }

    public void onPostTick() {
        FMLCommonHandler.instance().gameTickEnd();
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    @Override
    public Logger getMinecraftLogger() {
        return MinecraftServer.a;
    }

    public void onChunkPopulate(df chunkProvider, int chunkX, int chunkZ, ge world, df generator) {
        Random fmlRandom = new Random(world.n());
        long xSeed = fmlRandom.nextLong() >> 3;
        long zSeed = fmlRandom.nextLong() >> 3;
        fmlRandom.setSeed(xSeed * (long)chunkX + zSeed * (long)chunkZ ^ world.n());
        for (ModContainer mod : Loader.getModList()) {
            if (!mod.generatesWorld()) continue;
            mod.getWorldGenerator().generate(fmlRandom, chunkX, chunkZ, world, generator, chunkProvider);
        }
    }

    public int fuelLookup(int itemId, int itemDamage) {
        int fv = 0;
        for (ModContainer mod : Loader.getModList()) {
            fv = Math.max(fv, mod.lookupFuelValue(itemId, itemDamage));
        }
        return fv;
    }

    @Override
    public boolean isModLoaderMod(Class<?> clazz) {
        return BaseMod.class.isAssignableFrom(clazz);
    }

    @Override
    public ModContainer loadBaseModMod(Class<?> clazz, String canonicalPath) {
        Class<?> bmClazz = clazz;
        return new ModLoaderModContainer(bmClazz, canonicalPath);
    }

    public void notifyItemPickup(ja entityItem, ih entityPlayer) {
        for (ModContainer mod : Loader.getModList()) {
            if (!mod.wantsPickupNotification()) continue;
            mod.getPickupNotifier().notifyPickup(entityItem, entityPlayer);
        }
    }

    public void raiseException(Throwable exception, String message, boolean stopGame) {
        FMLCommonHandler.instance().getFMLLogger().throwing("FMLHandler", "raiseException", exception);
        throw new RuntimeException(exception);
    }

    public boolean tryDispensingEntity(ge world, double x2, double y, double z, byte xVelocity, byte zVelocity, kp item) {
        for (ModContainer mod : Loader.getModList()) {
            if (!mod.wantsToDispense() || !mod.getDispenseHandler().dispense(x2, y, z, xVelocity, zVelocity, world, item)) continue;
            return true;
        }
        return false;
    }

    public static FMLServerHandler instance() {
        return INSTANCE;
    }

    public lt[] getDefaultOverworldBiomes() {
        if (this.defaultOverworldBiomes == null) {
            ArrayList<lt> biomes = new ArrayList<lt>(20);
            for (int i = 0; i < 23; ++i) {
                if ("Sky".equals(lt.a[i].y) || "Hell".equals(lt.a[i].y)) continue;
                biomes.add(lt.a[i]);
            }
            this.defaultOverworldBiomes = new lt[biomes.size()];
            biomes.toArray(this.defaultOverworldBiomes);
        }
        return this.defaultOverworldBiomes;
    }

    public void onItemCrafted(ih player, kp craftedItem, ni craftingGrid) {
        for (ModContainer mod : Loader.getModList()) {
            if (!mod.wantsCraftingNotification()) continue;
            mod.getCraftingHandler().onCrafting(player, craftedItem, craftingGrid);
        }
    }

    public void onItemSmelted(ih player, kp smeltedItem) {
        for (ModContainer mod : Loader.getModList()) {
            if (!mod.wantsCraftingNotification()) continue;
            mod.getCraftingHandler().onSmelting(player, smeltedItem);
        }
    }

    public boolean handleChatPacket(qr chat, ih player) {
        for (ModContainer mod : Loader.getModList()) {
            if (!mod.wantsNetworkPackets() || !mod.getNetworkHandler().onChat(chat, player)) continue;
            return true;
        }
        return false;
    }

    public void handlePacket250(gl packet, ih player) {
        if ("REGISTER".equals(packet.a) || "UNREGISTER".equals(packet.a)) {
            this.handleClientRegistration(packet, player);
            return;
        }
        ModContainer mod = FMLCommonHandler.instance().getModForChannel(packet.a);
        if (mod != null) {
            mod.getNetworkHandler().onPacket250Packet(packet, player);
        }
    }

    private void handleClientRegistration(gl packet, ih player) {
        if (packet.c == null) {
            return;
        }
        try {
            for (String channel : new String(packet.c, "UTF8").split("\u0000")) {
                if (FMLCommonHandler.instance().getModForChannel(channel) == null) continue;
                if ("REGISTER".equals(packet.a)) {
                    FMLCommonHandler.instance().activateChannel(player, channel);
                    continue;
                }
                FMLCommonHandler.instance().deactivateChannel(player, channel);
            }
        }
        catch (UnsupportedEncodingException e) {
            this.getMinecraftLogger().warning("Received invalid registration packet");
        }
    }

    public void handleLogin(pk loginPacket, qq networkManager) {
        gl packet = new gl();
        packet.a = "REGISTER";
        packet.c = FMLCommonHandler.instance().getPacketRegistry();
        packet.b = packet.c.length;
        if (packet.b > 0) {
            networkManager.a((lx)packet);
        }
    }

    public void announceLogin(ih player) {
        for (ModContainer mod : Loader.getModList()) {
            if (!mod.wantsPlayerTracking()) continue;
            mod.getPlayerTracker().onPlayerLogin(player);
        }
    }

    @Override
    public boolean isServer() {
        return true;
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public File getMinecraftRootDirectory() {
        try {
            return this.server.a(".").getCanonicalFile();
        }
        catch (IOException ioe) {
            return new File(".");
        }
    }

    public boolean handleServerCommand(String command, String player, um listener) {
        for (ModContainer mod : Loader.getModList()) {
            if (!mod.wantsConsoleCommands() || !mod.getConsoleHandler().handleCommand(command, player, listener)) continue;
            return true;
        }
        return false;
    }

    public void announceLogout(ih player) {
        for (ModContainer mod : Loader.getModList()) {
            if (!mod.wantsPlayerTracking()) continue;
            mod.getPlayerTracker().onPlayerLogout(player);
        }
    }

    public void announceDimensionChange(ih player) {
        for (ModContainer mod : Loader.getModList()) {
            if (!mod.wantsPlayerTracking()) continue;
            mod.getPlayerTracker().onPlayerChangedDimension(player);
        }
    }
}

