/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.server;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IConsoleHandler;
import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.IDispenseHandler;
import cpw.mods.fml.common.INetworkHandler;
import cpw.mods.fml.common.IPickupNotifier;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.server.FMLServerHandler;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class ModLoaderModContainer
implements ModContainer {
    private Class<? extends BaseMod> modClazz;
    private BaseMod mod;
    private boolean isTicking;
    private String modSource;
    private ArrayList<String> dependencies;
    private ArrayList<String> preDependencies;
    private ArrayList<String> postDependencies;

    public ModLoaderModContainer(Class<? extends BaseMod> modClazz, String modSource) {
        this.modClazz = modClazz;
        this.modSource = modSource;
    }

    @Override
    public boolean wantsPreInit() {
        return true;
    }

    @Override
    public boolean wantsPostInit() {
        return true;
    }

    @Override
    public void preInit() {
        try {
            this.configureMod();
            this.mod = this.modClazz.newInstance();
        }
        catch (Exception e) {
            throw new LoaderException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureMod() {
        File configDir = Loader.instance().getConfigDir();
        File modConfig = new File(configDir, String.format("%s.cfg", this.modClazz.getSimpleName()));
        Properties props = new Properties();
        if (modConfig.exists()) {
            try {
                FileReader configReader = new FileReader(modConfig);
                props.load(configReader);
                configReader.close();
            }
            catch (Exception e) {
                Loader.log.severe(String.format("Error occured reading mod configuration file %s", modConfig.getName()));
                Loader.log.throwing("ModLoaderModContainer", "configureMod", e);
                throw new LoaderException(e);
            }
        }
        StringBuffer comments = new StringBuffer();
        comments.append("MLProperties: name (type:default) min:max -- information\n");
        try {
            for (Field f2 : this.modClazz.getDeclaredFields()) {
                Object defaultValue;
                String propertyValue;
                String propertyName;
                MLProp property;
                block21: {
                    if (!Modifier.isStatic(f2.getModifiers()) || !f2.isAnnotationPresent(MLProp.class)) continue;
                    property = f2.getAnnotation(MLProp.class);
                    propertyName = property.name().length() > 0 ? property.name() : f2.getName();
                    propertyValue = null;
                    defaultValue = null;
                    try {
                        defaultValue = f2.get(null);
                        propertyValue = props.getProperty(propertyName, this.extractValue(defaultValue));
                        Object currentValue = this.parseValue(propertyValue, property, f2.getType());
                        if (currentValue == null || currentValue.equals(defaultValue)) break block21;
                        f2.set(null, currentValue);
                    }
                    catch (Exception e) {
                        try {
                            Loader.log.severe(String.format("Invalid configuration found for %s in %s", propertyName, modConfig.getName()));
                            Loader.log.throwing("ModLoaderModContainer", "configureMod", e);
                            throw new LoaderException(e);
                        }
                        catch (Throwable throwable) {
                            comments.append(String.format("MLProp : %s (%s:%s", propertyName, f2.getType().getName(), defaultValue));
                            if (property.min() != Double.MIN_VALUE) {
                                comments.append(",>=").append(String.format("%.1f", property.min()));
                            }
                            if (property.max() != Double.MAX_VALUE) {
                                comments.append(",<=").append(String.format("%.1f", property.max()));
                            }
                            comments.append(")");
                            if (property.info().length() > 0) {
                                comments.append(" -- ").append(property.info());
                            }
                            if (propertyValue != null) {
                                props.setProperty(propertyName, this.extractValue(propertyValue));
                            }
                            throw throwable;
                        }
                    }
                }
                comments.append(String.format("MLProp : %s (%s:%s", propertyName, f2.getType().getName(), defaultValue));
                if (property.min() != Double.MIN_VALUE) {
                    comments.append(",>=").append(String.format("%.1f", property.min()));
                }
                if (property.max() != Double.MAX_VALUE) {
                    comments.append(",<=").append(String.format("%.1f", property.max()));
                }
                comments.append(")");
                if (property.info().length() > 0) {
                    comments.append(" -- ").append(property.info());
                }
                if (propertyValue == null) continue;
                props.setProperty(propertyName, this.extractValue(propertyValue));
            }
        }
        catch (Throwable throwable) {
            try {
                FileWriter configWriter = new FileWriter(modConfig);
                props.store(configWriter, comments.toString());
                configWriter.close();
            }
            catch (IOException e) {
                Loader.log.warning(String.format("Error trying to write the config file %s", modConfig.getName()));
                Loader.log.throwing("ModLoaderModContainer", "configureMod", e);
                throw new LoaderException(e);
            }
            throw throwable;
        }
        try {
            FileWriter configWriter = new FileWriter(modConfig);
            props.store(configWriter, comments.toString());
            configWriter.close();
        }
        catch (IOException e) {
            Loader.log.warning(String.format("Error trying to write the config file %s", modConfig.getName()));
            Loader.log.throwing("ModLoaderModContainer", "configureMod", e);
            throw new LoaderException(e);
        }
    }

    private Object parseValue(String val, MLProp property, Class<?> type) {
        if (type.isAssignableFrom(String.class)) {
            return val;
        }
        if (type.isAssignableFrom(Boolean.TYPE) || type.isAssignableFrom(Boolean.class)) {
            return Boolean.parseBoolean(val);
        }
        if (Number.class.isAssignableFrom(type)) {
            Number n = null;
            if (Double.class.isAssignableFrom(type)) {
                n = Double.parseDouble(val);
            }
            if (Float.class.isAssignableFrom(type)) {
                n = Float.valueOf(Float.parseFloat(val));
            }
            if (Long.class.isAssignableFrom(type)) {
                n = Long.parseLong(val);
            }
            if (Integer.class.isAssignableFrom(type)) {
                n = Integer.parseInt(val);
            }
            if (Short.class.isAssignableFrom(type)) {
                n = Short.parseShort(val);
            }
            if (!Byte.class.isAssignableFrom(type)) {
                throw new IllegalArgumentException("MLProp declared on non-standard type");
            }
            n = Byte.parseByte(val);
            if (n.doubleValue() < property.min() || n.doubleValue() > property.max()) {
                return null;
            }
            return n;
        }
        return null;
    }

    private String extractValue(Object value) {
        if (String.class.isInstance(value)) {
            return (String)value;
        }
        if (Number.class.isInstance(value) || Boolean.class.isInstance(value)) {
            return String.valueOf(value);
        }
        throw new IllegalArgumentException("MLProp declared on non-standard type");
    }

    @Override
    public void init() {
        this.mod.load();
    }

    @Override
    public void postInit() {
        this.mod.modsLoaded();
    }

    @Override
    public void tickStart() {
        if (this.isTicking) {
            this.isTicking = this.mod.onTickInGame(FMLServerHandler.instance().getServer());
        }
    }

    @Override
    public void tickEnd() {
    }

    @Override
    public String getName() {
        return this.mod != null ? this.mod.getName() : null;
    }

    public static ModContainer findContainerFor(BaseMod mod) {
        for (ModContainer mc : Loader.getModList()) {
            if (!mc.matches(mod)) continue;
            return mc;
        }
        return null;
    }

    @Override
    public boolean matches(Object mod) {
        return this.modClazz.isInstance(mod);
    }

    public void setTicking(boolean enable) {
        this.isTicking = enable;
    }

    public static List<BaseMod> findAll() {
        ArrayList<BaseMod> modList = new ArrayList<BaseMod>();
        for (ModContainer mc : Loader.getModList()) {
            if (!(mc instanceof ModLoaderModContainer)) continue;
            modList.add(((ModLoaderModContainer)mc).mod);
        }
        return modList;
    }

    @Override
    public String getSource() {
        return this.modSource;
    }

    @Override
    public Object getMod() {
        return this.mod;
    }

    @Override
    public boolean generatesWorld() {
        return true;
    }

    @Override
    public IWorldGenerator getWorldGenerator() {
        return this.mod;
    }

    @Override
    public int lookupFuelValue(int itemId, int itemDamage) {
        return this.mod.addFuel(itemId, itemDamage);
    }

    @Override
    public boolean wantsPickupNotification() {
        return true;
    }

    @Override
    public IPickupNotifier getPickupNotifier() {
        return this.mod;
    }

    @Override
    public boolean wantsToDispense() {
        return true;
    }

    @Override
    public IDispenseHandler getDispenseHandler() {
        return this.mod;
    }

    @Override
    public boolean wantsCraftingNotification() {
        return true;
    }

    @Override
    public ICraftingHandler getCraftingHandler() {
        return this.mod;
    }

    private void computeDependencies() {
        this.dependencies = new ArrayList();
        this.preDependencies = new ArrayList();
        this.postDependencies = new ArrayList();
        if (this.mod.getPriorities() == null || this.mod.getPriorities().length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(this.mod.getPriorities(), ";");
        while (st.hasMoreTokens()) {
            String dep = st.nextToken();
            String[] depparts = dep.split(":");
            if (depparts.length < 2) {
                throw new LoaderException();
            }
            if ("required-before".equals(depparts[0]) || "required-after".equals(depparts[0])) {
                this.dependencies.add(depparts[1]);
            }
            if ("required-before".equals(depparts[0]) || "before".equals(depparts[0])) {
                this.postDependencies.add(depparts[1]);
            }
            if (!"required-after".equals(depparts[0]) && !"after".equals(depparts[0])) continue;
            this.preDependencies.add(depparts[1]);
        }
    }

    @Override
    public List<String> getDependencies() {
        if (this.dependencies == null) {
            this.computeDependencies();
        }
        return this.dependencies;
    }

    @Override
    public List<String> getPostDepends() {
        if (this.dependencies == null) {
            this.computeDependencies();
        }
        return this.postDependencies;
    }

    @Override
    public List<String> getPreDepends() {
        if (this.dependencies == null) {
            this.computeDependencies();
        }
        return this.preDependencies;
    }

    public String toString() {
        return this.modSource;
    }

    @Override
    public boolean wantsNetworkPackets() {
        return true;
    }

    @Override
    public INetworkHandler getNetworkHandler() {
        return this.mod;
    }

    @Override
    public boolean ownsNetworkChannel(String channel) {
        return FMLCommonHandler.instance().getChannelListFor(this).contains(channel);
    }

    @Override
    public boolean wantsConsoleCommands() {
        return true;
    }

    @Override
    public IConsoleHandler getConsoleHandler() {
        return this.mod;
    }

    @Override
    public boolean wantsPlayerTracking() {
        return true;
    }

    @Override
    public IPlayerTracker getPlayerTracker() {
        return this.mod;
    }
}

