/*
 * Decompiled with CFR 0.152.
 */
package forge.packets;

import forge.packets.ForgePacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;

public class PacketModList
extends ForgePacket {
    private boolean isServer = false;
    public String[] Mods;
    public Hashtable<Integer, String> ModIDs = new Hashtable();
    public int Length = -1;

    public PacketModList(boolean server) {
        this.isServer = server;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        if (!this.isServer) {
            data.writeInt(this.Mods.length);
            for (String mod : this.Mods) {
                data.writeUTF(mod);
            }
        } else {
            data.writeInt(this.ModIDs.size());
            for (Map.Entry<Integer, String> entry : this.ModIDs.entrySet()) {
                data.writeInt(entry.getKey());
                data.writeUTF(entry.getValue());
            }
        }
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        block3: {
            block2: {
                if (!this.isServer) break block2;
                this.Length = data.readInt();
                if (this.Length < 0) break block3;
                this.Mods = new String[this.Length];
                for (int x = 0; x < this.Length; ++x) {
                    this.Mods[x] = data.readUTF();
                }
                break block3;
            }
            this.Length = data.readInt();
            for (int x = 0; x < this.Length; ++x) {
                this.ModIDs.put(data.readInt(), data.readUTF());
            }
        }
    }

    @Override
    public int getID() {
        return 2;
    }

    @Override
    public String toString(boolean full) {
        if (full) {
            StringBuilder ret = new StringBuilder();
            ret.append(this.toString()).append('\n');
            if (this.Mods != null) {
                for (String mod : this.Mods) {
                    ret.append("    " + mod + '\n');
                }
            } else if (this.ModIDs.size() != 0) {
                for (Map.Entry<Integer, String> mod : this.ModIDs.entrySet()) {
                    ret.append(String.format("    %03d ", mod.getKey()) + mod.getValue() + '\n');
                }
            }
            return ret.toString();
        }
        return this.toString();
    }
}

