/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import cpw.mods.fml.common.FMLModContainer;
import cpw.mods.fml.common.ModContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ModMetadata {
    public ModContainer mod;
    public ModType type;
    public String name;
    public String description;
    public String url = "";
    public String updateUrl = "";
    public String logoFile = "";
    public String version = "";
    public List<String> authorList = new ArrayList<String>(1);
    public String credits = "";
    public String parent = "";
    public String[] screenshots;
    public ModContainer parentMod;
    public List<ModContainer> childMods = new ArrayList<ModContainer>(1);

    public ModMetadata(ModContainer mod) {
        this.mod = mod;
        this.type = mod instanceof FMLModContainer ? ModType.FML : ModType.MODLOADER;
    }

    public void associate(Map<String, ModContainer> mods) {
        ModContainer mc;
        if (this.parent != null && this.parent.length() > 0 && (mc = mods.get(this.parent)) != null && mc.getMetadata() != null) {
            mc.getMetadata().childMods.add(this.mod);
            this.parentMod = mc;
        }
    }

    public String getChildModCountString() {
        return String.format("%d child mod%s", this.childMods.size(), this.childMods.size() != 1 ? "s" : "");
    }

    public String getAuthorList() {
        StringBuilder sb2 = new StringBuilder();
        for (int i2 = 0; i2 < this.authorList.size(); ++i2) {
            sb2.append(this.authorList.get(i2));
            if (i2 >= this.authorList.size() - 1) continue;
            sb2.append(", ");
        }
        return sb2.toString();
    }

    public String getChildModList() {
        StringBuilder sb2 = new StringBuilder();
        for (int i2 = 0; i2 < this.childMods.size(); ++i2) {
            sb2.append(this.childMods.get((int)i2).getMetadata().name);
            if (i2 >= this.childMods.size() - 1) continue;
            sb2.append(", ");
        }
        return sb2.toString();
    }

    public static enum ModType {
        MODLOADER,
        FML;

    }
}

