/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.modloader;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IConsoleHandler;
import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.IDispenseHandler;
import cpw.mods.fml.common.IFMLSidedHandler;
import cpw.mods.fml.common.IKeyHandler;
import cpw.mods.fml.common.INetworkHandler;
import cpw.mods.fml.common.IPickupNotifier;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.ProxyInjector;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.modloader.BaseMod;
import cpw.mods.fml.common.modloader.BaseModTicker;
import cpw.mods.fml.common.modloader.ModProperty;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class ModLoaderModContainer
implements ModContainer {
    private static final ProxyInjector NULLPROXY = new ProxyInjector("", "", "", null);
    private Class<? extends BaseMod> modClazz;
    private BaseMod mod;
    private File modSource;
    private ArrayList<String> dependencies;
    private ArrayList<String> preDependencies;
    private ArrayList<String> postDependencies;
    private ArrayList<IKeyHandler> keyHandlers;
    private ModContainer.ModState state;
    private ModContainer.SourceType sourceType;
    private ModMetadata metadata;
    private ProxyInjector sidedProxy;
    private BaseModTicker tickHandler;

    public ModLoaderModContainer(Class<? extends BaseMod> modClazz, File modSource) {
        this.modClazz = modClazz;
        this.modSource = modSource;
        this.nextState();
    }

    ModLoaderModContainer(BaseMod instance) {
        FMLCommonHandler.instance().addAuxilliaryModContainer(this);
        this.mod = instance;
        this.tickHandler = new BaseModTicker(instance);
    }

    @Override
    public boolean wantsPreInit() {
        return true;
    }

    @Override
    public boolean wantsPostInit() {
        return true;
    }

    @Override
    public void preInit() {
        try {
            EnumSet<TickType> ticks = EnumSet.noneOf(TickType.class);
            this.tickHandler = new BaseModTicker(ticks);
            this.configureMod();
            this.mod = this.modClazz.newInstance();
            this.tickHandler.setMod(this.mod);
            FMLCommonHandler.instance().registerTickHandler(this.tickHandler);
            FMLCommonHandler.instance().registerWorldGenerator(this.mod);
        }
        catch (Exception e) {
            throw new LoaderException(e);
        }
    }

    @Override
    public ModContainer.ModState getModState() {
        return this.state;
    }

    @Override
    public void nextState() {
        if (this.state == null) {
            this.state = ModContainer.ModState.UNLOADED;
            return;
        }
        if (this.state.ordinal() + 1 < ModContainer.ModState.values().length) {
            this.state = ModContainer.ModState.values()[this.state.ordinal() + 1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureMod() {
        IFMLSidedHandler sideHandler = FMLCommonHandler.instance().getSidedDelegate();
        File configDir = Loader.instance().getConfigDir();
        String modConfigName = this.modClazz.getSimpleName();
        File modConfig = new File(configDir, String.format("%s.cfg", modConfigName));
        Properties props = new Properties();
        if (modConfig.exists()) {
            try {
                Loader.log.fine(String.format("Reading existing configuration file for %s : %s", modConfigName, modConfig.getName()));
                FileReader configReader = new FileReader(modConfig);
                props.load(configReader);
                configReader.close();
            }
            catch (Exception e) {
                Loader.log.severe(String.format("Error occured reading mod configuration file %s", modConfig.getName()));
                Loader.log.throwing("ModLoaderModContainer", "configureMod", e);
                throw new LoaderException(e);
            }
        }
        StringBuffer comments = new StringBuffer();
        comments.append("MLProperties: name (type:default) min:max -- information\n");
        try {
            for (Field f : this.modClazz.getDeclaredFields()) {
                Object defaultValue;
                String propertyValue;
                String propertyName;
                ModProperty property;
                block22: {
                    if (!Modifier.isStatic(f.getModifiers()) || (property = sideHandler.getModLoaderPropertyFor(f)) == null) continue;
                    propertyName = property.name().length() > 0 ? property.name() : f.getName();
                    propertyValue = null;
                    defaultValue = null;
                    try {
                        defaultValue = f.get(null);
                        propertyValue = props.getProperty(propertyName, this.extractValue(defaultValue));
                        Object currentValue = this.parseValue(propertyValue, property, f.getType(), propertyName, modConfigName);
                        Loader.log.finest(String.format("Configuration for %s.%s found values default: %s, configured: %s, interpreted: %s", modConfigName, propertyName, defaultValue, propertyValue, currentValue));
                        if (currentValue == null || currentValue.equals(defaultValue)) break block22;
                        Loader.log.finest(String.format("Configuration for %s.%s value set to: %s", modConfigName, propertyName, currentValue));
                        f.set(null, currentValue);
                    }
                    catch (Exception e) {
                        try {
                            Loader.log.severe(String.format("Invalid configuration found for %s in %s", propertyName, modConfig.getName()));
                            Loader.log.throwing("ModLoaderModContainer", "configureMod", e);
                            throw new LoaderException(e);
                        }
                        catch (Throwable throwable) {
                            comments.append(String.format("MLProp : %s (%s:%s", propertyName, f.getType().getName(), defaultValue));
                            if (property.min() != Double.MIN_VALUE) {
                                comments.append(",>=").append(String.format("%.1f", property.min()));
                            }
                            if (property.max() != Double.MAX_VALUE) {
                                comments.append(",<=").append(String.format("%.1f", property.max()));
                            }
                            comments.append(")");
                            if (property.info().length() > 0) {
                                comments.append(" -- ").append(property.info());
                            }
                            if (propertyValue != null) {
                                props.setProperty(propertyName, this.extractValue(propertyValue));
                            }
                            comments.append("\n");
                            throw throwable;
                        }
                    }
                }
                comments.append(String.format("MLProp : %s (%s:%s", propertyName, f.getType().getName(), defaultValue));
                if (property.min() != Double.MIN_VALUE) {
                    comments.append(",>=").append(String.format("%.1f", property.min()));
                }
                if (property.max() != Double.MAX_VALUE) {
                    comments.append(",<=").append(String.format("%.1f", property.max()));
                }
                comments.append(")");
                if (property.info().length() > 0) {
                    comments.append(" -- ").append(property.info());
                }
                if (propertyValue != null) {
                    props.setProperty(propertyName, this.extractValue(propertyValue));
                }
                comments.append("\n");
            }
        }
        catch (Throwable throwable) {
            try {
                FileWriter configWriter = new FileWriter(modConfig);
                props.store(configWriter, comments.toString());
                configWriter.close();
                Loader.log.fine(String.format("Configuration for %s written to %s", modConfigName, modConfig.getName()));
            }
            catch (IOException e) {
                Loader.log.warning(String.format("Error trying to write the config file %s", modConfig.getName()));
                Loader.log.throwing("ModLoaderModContainer", "configureMod", e);
                throw new LoaderException(e);
            }
            throw throwable;
        }
        try {
            FileWriter configWriter = new FileWriter(modConfig);
            props.store(configWriter, comments.toString());
            configWriter.close();
            Loader.log.fine(String.format("Configuration for %s written to %s", modConfigName, modConfig.getName()));
        }
        catch (IOException e) {
            Loader.log.warning(String.format("Error trying to write the config file %s", modConfig.getName()));
            Loader.log.throwing("ModLoaderModContainer", "configureMod", e);
            throw new LoaderException(e);
        }
    }

    private Object parseValue(String val, ModProperty property, Class<?> type, String propertyName, String modConfigName) {
        if (type.isAssignableFrom(String.class)) {
            return val;
        }
        if (type.isAssignableFrom(Boolean.TYPE) || type.isAssignableFrom(Boolean.class)) {
            return Boolean.parseBoolean(val);
        }
        if (Number.class.isAssignableFrom(type) || type.isPrimitive()) {
            Number n = null;
            if (type.isAssignableFrom(Double.TYPE) || Double.class.isAssignableFrom(type)) {
                n = Double.parseDouble(val);
            } else if (type.isAssignableFrom(Float.TYPE) || Float.class.isAssignableFrom(type)) {
                n = Float.valueOf(Float.parseFloat(val));
            } else if (type.isAssignableFrom(Long.TYPE) || Long.class.isAssignableFrom(type)) {
                n = Long.parseLong(val);
            } else if (type.isAssignableFrom(Integer.TYPE) || Integer.class.isAssignableFrom(type)) {
                n = Integer.parseInt(val);
            } else if (type.isAssignableFrom(Short.TYPE) || Short.class.isAssignableFrom(type)) {
                n = Short.parseShort(val);
            } else if (type.isAssignableFrom(Byte.TYPE) || Byte.class.isAssignableFrom(type)) {
                n = Byte.parseByte(val);
            } else {
                throw new IllegalArgumentException(String.format("MLProp declared on %s of type %s, an unsupported type", propertyName, type.getName()));
            }
            if (n.doubleValue() < property.min() || n.doubleValue() > property.max()) {
                Loader.log.warning(String.format("Configuration for %s.%s found value %s outside acceptable range %s,%s", modConfigName, propertyName, n, property.min(), property.max()));
                return null;
            }
            return n;
        }
        throw new IllegalArgumentException(String.format("MLProp declared on %s of type %s, an unsupported type", propertyName, type.getName()));
    }

    private String extractValue(Object value) {
        if (String.class.isInstance(value)) {
            return (String)value;
        }
        if (Number.class.isInstance(value) || Boolean.class.isInstance(value)) {
            return String.valueOf(value);
        }
        throw new IllegalArgumentException("MLProp declared on non-standard type");
    }

    @Override
    public void init() {
        this.mod.load();
    }

    @Override
    public void postInit() {
        this.mod.modsLoaded();
    }

    @Override
    public String getName() {
        return this.mod != null ? this.mod.getName() : this.modClazz.getSimpleName();
    }

    public static ModContainer findContainerFor(BaseMod mod) {
        for (ModContainer mc : Loader.getModList()) {
            if (!mc.matches(mod)) continue;
            return mc;
        }
        return null;
    }

    @Override
    public String getSortingRules() {
        if (this.mod != null) {
            return this.mod.getPriorities();
        }
        return "";
    }

    @Override
    public boolean matches(Object mod) {
        return this.modClazz.isInstance(mod);
    }

    public static <A extends BaseMod> List<A> findAll(Class<A> clazz) {
        ArrayList<BaseMod> modList = new ArrayList<BaseMod>();
        for (ModContainer mc : Loader.getModList()) {
            if (!(mc instanceof ModLoaderModContainer) || mc.getMod() == null) continue;
            modList.add(((ModLoaderModContainer)mc).mod);
        }
        return modList;
    }

    @Override
    public File getSource() {
        return this.modSource;
    }

    @Override
    public Object getMod() {
        return this.mod;
    }

    @Override
    public int lookupFuelValue(int itemId, int itemDamage) {
        return this.mod.addFuel(itemId, itemDamage);
    }

    @Override
    public boolean wantsPickupNotification() {
        return true;
    }

    @Override
    public IPickupNotifier getPickupNotifier() {
        return this.mod;
    }

    @Override
    public boolean wantsToDispense() {
        return true;
    }

    @Override
    public IDispenseHandler getDispenseHandler() {
        return this.mod;
    }

    @Override
    public boolean wantsCraftingNotification() {
        return true;
    }

    @Override
    public ICraftingHandler getCraftingHandler() {
        return this.mod;
    }

    private void computeDependencies() {
        this.dependencies = new ArrayList();
        this.preDependencies = new ArrayList();
        this.postDependencies = new ArrayList();
        if (this.mod.getPriorities() == null || this.mod.getPriorities().length() == 0) {
            return;
        }
        boolean parseFailure = false;
        StringTokenizer st2 = new StringTokenizer(this.mod.getPriorities(), ";");
        while (st2.hasMoreTokens()) {
            String dep = st2.nextToken();
            String[] depparts = dep.split(":");
            if (depparts.length < 2) {
                parseFailure = true;
                continue;
            }
            if ("required-before".equals(depparts[0]) || "required-after".equals(depparts[0])) {
                if (!depparts[1].trim().equals("*")) {
                    this.dependencies.add(depparts[1]);
                    continue;
                }
                parseFailure = true;
                continue;
            }
            if ("required-before".equals(depparts[0]) || "before".equals(depparts[0])) {
                this.postDependencies.add(depparts[1]);
                continue;
            }
            if ("required-after".equals(depparts[0]) || "after".equals(depparts[0])) {
                this.preDependencies.add(depparts[1]);
                continue;
            }
            parseFailure = true;
        }
        if (parseFailure) {
            FMLCommonHandler.instance().getFMLLogger().warning(String.format("The mod %s has an incorrect dependency string {%s}", this.mod.getName(), this.mod.getPriorities()));
        }
    }

    @Override
    public List<String> getDependencies() {
        if (this.dependencies == null) {
            this.computeDependencies();
        }
        return this.dependencies;
    }

    @Override
    public List<String> getPostDepends() {
        if (this.dependencies == null) {
            this.computeDependencies();
        }
        return this.postDependencies;
    }

    @Override
    public List<String> getPreDepends() {
        if (this.dependencies == null) {
            this.computeDependencies();
        }
        return this.preDependencies;
    }

    public String toString() {
        return this.modClazz.getSimpleName();
    }

    @Override
    public boolean wantsNetworkPackets() {
        return true;
    }

    @Override
    public INetworkHandler getNetworkHandler() {
        return this.mod;
    }

    @Override
    public boolean ownsNetworkChannel(String channel) {
        return FMLCommonHandler.instance().getChannelListFor(this).contains(channel);
    }

    @Override
    public boolean wantsConsoleCommands() {
        return true;
    }

    @Override
    public IConsoleHandler getConsoleHandler() {
        return this.mod;
    }

    @Override
    public boolean wantsPlayerTracking() {
        return true;
    }

    @Override
    public IPlayerTracker getPlayerTracker() {
        return this.mod;
    }

    public void addKeyHandler(IKeyHandler handler) {
        if (this.keyHandlers == null) {
            this.keyHandlers = new ArrayList();
        }
        Iterator<IKeyHandler> itr = this.keyHandlers.iterator();
        while (itr.hasNext()) {
            IKeyHandler old = itr.next();
            if (old.getKeyBinding() != handler.getKeyBinding()) continue;
            itr.remove();
        }
        this.keyHandlers.add(handler);
    }

    @Override
    public List<IKeyHandler> getKeys() {
        if (this.keyHandlers == null) {
            return Collections.emptyList();
        }
        return this.keyHandlers;
    }

    @Override
    public void setSourceType(ModContainer.SourceType type) {
        this.sourceType = type;
    }

    @Override
    public ModContainer.SourceType getSourceType() {
        return this.sourceType;
    }

    @Override
    public ModMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(ModMetadata meta) {
        this.metadata = meta;
    }

    @Override
    public void gatherRenderers(Map renderers) {
        this.mod.onRenderHarvest(renderers);
    }

    @Override
    public void requestAnimations() {
        this.mod.onRegisterAnimations();
    }

    @Override
    public String getVersion() {
        if (this.mod == null || this.mod.getVersion() == null) {
            return "Not available";
        }
        return this.mod.getVersion();
    }

    @Override
    public ProxyInjector findSidedProxy() {
        if (this.sidedProxy == null) {
            this.sidedProxy = FMLCommonHandler.instance().getSidedDelegate().findSidedProxyOn(this.mod);
            if (this.sidedProxy == null) {
                this.sidedProxy = NULLPROXY;
            }
        }
        return this.sidedProxy == NULLPROXY ? null : this.sidedProxy;
    }

    @Override
    public void keyBindEvent(Object keybinding) {
        this.mod.keyBindingEvent(keybinding);
    }

    public BaseModTicker getTickHandler() {
        return this.tickHandler;
    }
}

