/*
 * Decompiled with CFR 0.152.
 */
package forge;

import forge.ForgeHooks;
import forge.GuiMissingMods;
import forge.ISpawnHandler;
import forge.IThrowableEntity;
import forge.MinecraftForge;
import forge.NetworkMod;
import forge.packets.ForgePacket;
import forge.packets.PacketEntitySpawn;
import forge.packets.PacketHandlerBase;
import forge.packets.PacketMissingMods;
import forge.packets.PacketModList;
import forge.packets.PacketOpenGUI;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.minecraft.client.Minecraft;

public class PacketHandlerClient
extends PacketHandlerBase {
    @Override
    public void onPacketData(lg network, String channel, byte[] bytes) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            ForgePacket pkt = null;
            adl net = (adl)network.getNetHandler();
            int packetID = data.read();
            switch (packetID) {
                case 1: {
                    pkt = new PacketEntitySpawn();
                    pkt.readData(data);
                    this.onEntitySpawnPacket((PacketEntitySpawn)pkt, data, ModLoader.getMinecraftInstance().f);
                    break;
                }
                case 2: {
                    pkt = new PacketModList(false);
                    pkt.readData(data);
                    this.onModListCheck(net, (PacketModList)pkt);
                    break;
                }
                case 3: {
                    pkt = new PacketMissingMods(false);
                    pkt.readData(data);
                    this.onMissingMods((PacketMissingMods)pkt, net);
                    break;
                }
                case 5: {
                    pkt = new PacketOpenGUI();
                    pkt.readData(data);
                    this.onOpenGui((PacketOpenGUI)pkt);
                }
            }
        }
        catch (IOException e) {
            ModLoader.getLogger().log(Level.SEVERE, "Exception in PacketHandlerClient.onPacketData", e);
            e.printStackTrace();
        }
    }

    public void onEntitySpawnPacket(PacketEntitySpawn packet, DataInputStream data, xd world) {
        Class cls;
        if (DEBUG) {
            System.out.println("S->C: " + packet.toString(true));
        }
        if ((cls = MinecraftForge.getEntityClass(packet.modID, packet.typeID)) == null) {
            System.out.println("Could not find entity info for " + Integer.toHexString(packet.modID) + " : " + packet.typeID);
            return;
        }
        double posX = (double)packet.posX / 32.0;
        double posY = (double)packet.posY / 32.0;
        double posZ = (double)packet.posZ / 32.0;
        float yaw = (float)(packet.yaw * 360) / 256.0f;
        float pitch = (float)(packet.pitch * 360) / 256.0f;
        float yawHead = (float)(packet.yawHead * 360) / 256.0f;
        try {
            nn entity = (nn)cls.getConstructor(xd.class).newInstance(world);
            if (entity instanceof IThrowableEntity) {
                Minecraft mc2 = ModLoader.getMinecraftInstance();
                vq thrower = mc2.h.f == packet.throwerID ? mc2.h : ((je)world).a(packet.throwerID);
                ((IThrowableEntity)((Object)entity)).setThrower((nn)thrower);
            }
            entity.ah = packet.posX;
            entity.ai = packet.posY;
            entity.aj = packet.posZ;
            nn[] parts = entity.Z();
            if (parts != null) {
                int i2 = packet.entityID - entity.f;
                for (int j2 = 0; j2 < parts.length; ++j2) {
                    parts[j2].f += i2;
                }
            }
            entity.f = packet.entityID;
            entity.b(posX, posY, posZ, yaw, pitch);
            if (entity instanceof acq) {
                ((acq)entity).bf = yawHead;
            }
            if (packet.metadata != null) {
                entity.y().a((List)packet.metadata);
            }
            if (packet.throwerID > 0) {
                entity.a((double)packet.speedX / 8000.0, (double)packet.speedY / 8000.0, (double)packet.speedZ / 8000.0);
            }
            if (entity instanceof ISpawnHandler) {
                ((ISpawnHandler)((Object)entity)).readSpawnData(data);
            }
            ((je)world).a(packet.entityID, entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            ModLoader.getLogger().throwing("ForgeHooksClient", "onEntitySpawnPacket", e);
            ModLoader.throwException(String.format("Error spawning entity of type %d for %s.", packet.typeID, MinecraftForge.getModByID(packet.modID)), e);
        }
    }

    private void onModListCheck(adl net, PacketModList packet) {
        NetworkMod[] mods;
        if (DEBUG) {
            System.out.println("S->C: " + packet.toString(true));
        }
        ForgeHooks.networkMods.clear();
        for (NetworkMod mod : mods = MinecraftForge.getNetworkMods()) {
            for (Map.Entry<Integer, String> entry : packet.ModIDs.entrySet()) {
                if (!mod.toString().equals(entry.getValue())) continue;
                ForgeHooks.networkMods.put(entry.getKey(), mod);
            }
        }
        ArrayList<NetworkMod> missing = new ArrayList<NetworkMod>();
        for (NetworkMod networkMod : mods) {
            if (MinecraftForge.getModID(networkMod) != -1 || !networkMod.serverSideRequired()) continue;
            missing.add(networkMod);
        }
        PacketModList pkt = new PacketModList(false);
        pkt.Mods = new String[ModLoader.getLoadedMods().size()];
        int x = 0;
        for (BaseMod baseMod : ModLoader.getLoadedMods()) {
            pkt.Mods[x++] = baseMod.toString();
        }
        net.c(pkt.getPacket());
        if (DEBUG) {
            System.out.println("C->S: " + pkt.toString(true));
        }
    }

    private void onMissingMods(PacketMissingMods pkt, adl net) {
        if (DEBUG) {
            System.out.println("S->C: " + pkt.toString(true));
        }
        net.c();
        Minecraft mc2 = ModLoader.getMinecraftInstance();
        mc2.a((xd)null);
        mc2.a(new GuiMissingMods(pkt));
    }

    private void onOpenGui(PacketOpenGUI pkt) {
        NetworkMod mod;
        if (DEBUG) {
            System.out.println("S->C: " + pkt.toString(true));
        }
        if ((mod = MinecraftForge.getModByID(pkt.ModID)) != null) {
            vq player = ModLoader.getMinecraftInstance().h;
            player.openGui((BaseMod)mod, pkt.GuiID, player.k, pkt.X, pkt.Y, pkt.Z);
            player.ar.f = pkt.WindowID;
        }
    }

    @Override
    public void sendPacket(lg network, abs packet) {
        adl net = (adl)network.getNetHandler();
        net.c(packet);
    }
}

