/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.Side;
import java.lang.reflect.Field;

public class ProxyInjector {
    private String clientName;
    private String serverName;
    private String bukkitName;
    private Field target;

    public ProxyInjector(String clientName, String serverName, String bukkitName, Field target) {
        this.clientName = clientName;
        this.serverName = serverName;
        this.bukkitName = bukkitName;
        this.target = target;
    }

    public boolean isValidFor(Side type) {
        if (type == Side.CLIENT) {
            return !this.clientName.isEmpty();
        }
        if (type == Side.SERVER) {
            return !this.serverName.isEmpty();
        }
        if (type == Side.BUKKIT) {
            return this.bukkitName.isEmpty();
        }
        return false;
    }

    public void inject(ModContainer mod, Side side) {
        String targetType = side == Side.CLIENT ? this.clientName : this.serverName;
        try {
            Object proxy = Class.forName(targetType, false, Loader.instance().getModClassLoader()).newInstance();
            if (!this.target.getType().isAssignableFrom(proxy.getClass())) {
                FMLCommonHandler.instance().getFMLLogger().severe(String.format("Attempted to load a proxy type %s into %s, but the types don't match", targetType, this.target.getName()));
                throw new LoaderException();
            }
            this.target.set(mod.getMod(), proxy);
        }
        catch (Exception e) {
            FMLCommonHandler.instance().getFMLLogger().severe(String.format("An error occured trying to load a proxy type %s into %s", targetType, this.target.getName()));
            FMLCommonHandler.instance().getFMLLogger().throwing("ProxyInjector", "inject", e);
            throw new LoaderException(e);
        }
    }
}

