/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.server;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IFMLSidedHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.ProxyInjector;
import cpw.mods.fml.common.ReflectionHelper;
import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.modloader.ModLoaderModContainer;
import cpw.mods.fml.common.modloader.ModProperty;
import cpw.mods.fml.common.registry.FMLRegistry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;

public class FMLServerHandler
implements IFMLSidedHandler {
    private static final FMLServerHandler INSTANCE = new FMLServerHandler();
    private MinecraftServer server;
    private lt[] defaultOverworldBiomes;

    public void onPreLoad(MinecraftServer minecraftServer) {
        try {
            Class.forName("BaseModMp", false, this.getClass().getClassLoader());
            MinecraftServer.a.severe("Forge Mod Loader has detected that this server has an ModLoaderMP installed alongside Forge Mod Loader.\nThis will cause a serious problem with compatibility. To protect your worlds, this minecraft server will now shutdown.\nYou should follow the installation instructions of either Minecraft Forge of Forge Mod Loader and NOT install ModLoaderMP \ninto the minecraft_server.jar file before this server will be allowed to start up.\n\nFailure to do so will simply result in more startup failures.\n\nThe authors of Minecraft Forge and Forge Mod Loader strongly suggest you talk to your mod's authors and get them to\nupdate their requirements. ModLoaderMP is not compatible with Minecraft Forge on the server and they will need to update their mod\nfor Minecraft Forge and other server compatibility, unless they are Minecraft Forge mods, in which case they already\ndon't need ModLoaderMP and the mod author simply has failed to update his requirements and should be informed appropriately.\n\nThe authors of Forge Mod Loader would like to be compatible with ModLoaderMP but it is closed source and owned by SDK.\nSDK, the author of ModLoaderMP, has a standing invitation to submit compatibility patches \nto the open source community project that is Forge Mod Loader so that this incompatibility doesn't last. \nUsers who wish to enjoy mods of both types are encouraged to request of SDK that he submit a\ncompatibility patch to the Forge Mod Loader project at \nhttp://github.com/cpw/FML.\nPosting on the minecraft forums at\nhttp://www.minecraftforum.net/topic/86765- (the MLMP thread)\nmay encourage him in this effort. However, I ask that your requests be polite.\nNow, the server has to shutdown so you can reinstall your minecraft_server.jar\nproperly, until such time as we can work together.");
            throw new RuntimeException("This FML based server has detected an installation of ModLoaderMP alongside. This will cause serious compatibility issues, so the server will now shut down.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.server = minecraftServer;
            ReflectionHelper.detectObfuscation(ge.class);
            FMLCommonHandler.instance().beginLoading(this);
            FMLRegistry.registerRegistry(new ServerRegistry());
            Loader.instance().loadMods();
            return;
        }
    }

    public void onLoadComplete() {
        Loader.instance().initializeMods();
    }

    public void onPreServerTick() {
        FMLCommonHandler.instance().tickStart(EnumSet.of(TickType.GAME), new Object[0]);
    }

    public void onPostServerTick() {
        FMLCommonHandler.instance().tickEnd(EnumSet.of(TickType.GAME), new Object[0]);
    }

    public void onPreWorldTick(ge world) {
        FMLCommonHandler.instance().tickStart(EnumSet.of(TickType.WORLD), world);
    }

    public void onPostWorldTick(ge world) {
        FMLCommonHandler.instance().tickEnd(EnumSet.of(TickType.WORLD), world);
    }

    public void onWorldLoadTick() {
        FMLCommonHandler.instance().tickStart(EnumSet.of(TickType.WORLDLOAD), new Object[0]);
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    @Override
    public Logger getMinecraftLogger() {
        return MinecraftServer.a;
    }

    public void onChunkPopulate(df chunkProvider, int chunkX, int chunkZ, ge world, df generator) {
        FMLCommonHandler.instance().handleWorldGeneration(chunkX, chunkZ, world.n(), world, generator, chunkProvider);
    }

    public int fuelLookup(int itemId, int itemDamage) {
        int fv = 0;
        for (ModContainer mod : Loader.getModList()) {
            fv = Math.max(fv, mod.lookupFuelValue(itemId, itemDamage));
        }
        return fv;
    }

    @Override
    public boolean isModLoaderMod(Class<?> clazz) {
        return BaseMod.class.isAssignableFrom(clazz);
    }

    @Override
    public ModContainer loadBaseModMod(Class<?> clazz, File canonicalFile) {
        Class<?> bmClazz = clazz;
        return new ModLoaderModContainer(bmClazz, canonicalFile);
    }

    public void notifyItemPickup(ja entityItem, ih entityPlayer) {
        for (ModContainer mod : Loader.getModList()) {
            if (!mod.wantsPickupNotification()) continue;
            mod.getPickupNotifier().notifyPickup(entityItem, entityPlayer);
        }
    }

    public void raiseException(Throwable exception, String message, boolean stopGame) {
        FMLCommonHandler.instance().getFMLLogger().throwing("FMLHandler", "raiseException", exception);
        throw new RuntimeException(exception);
    }

    public boolean tryDispensingEntity(ge world, double x2, double y, double z, byte xVelocity, byte zVelocity, kp item) {
        for (ModContainer mod : Loader.getModList()) {
            if (!mod.wantsToDispense() || !mod.getDispenseHandler().dispense(x2, y, z, xVelocity, zVelocity, world, item)) continue;
            return true;
        }
        return false;
    }

    public static FMLServerHandler instance() {
        return INSTANCE;
    }

    public lt[] getDefaultOverworldBiomes() {
        if (this.defaultOverworldBiomes == null) {
            ArrayList<lt> biomes = new ArrayList<lt>(20);
            for (int i = 0; i < 23; ++i) {
                if ("Sky".equals(lt.a[i].y) || "Hell".equals(lt.a[i].y)) continue;
                biomes.add(lt.a[i]);
            }
            this.defaultOverworldBiomes = new lt[biomes.size()];
            biomes.toArray(this.defaultOverworldBiomes);
        }
        return this.defaultOverworldBiomes;
    }

    public void onItemCrafted(ih player, kp craftedItem, ni craftingGrid) {
        for (ModContainer mod : Loader.getModList()) {
            if (!mod.wantsCraftingNotification()) continue;
            mod.getCraftingHandler().onCrafting(player, craftedItem, craftingGrid);
        }
    }

    public void onItemSmelted(ih player, kp smeltedItem) {
        for (ModContainer mod : Loader.getModList()) {
            if (!mod.wantsCraftingNotification()) continue;
            mod.getCraftingHandler().onSmelting(player, smeltedItem);
        }
    }

    public boolean handleChatPacket(qr chat, ih player) {
        for (ModContainer mod : Loader.getModList()) {
            if (!mod.wantsNetworkPackets() || !mod.getNetworkHandler().onChat(chat, player)) continue;
            return true;
        }
        return false;
    }

    public void handlePacket250(gl packet, ih player) {
        if ("REGISTER".equals(packet.a) || "UNREGISTER".equals(packet.a)) {
            this.handleClientRegistration(packet, player);
            return;
        }
        ModContainer mod = FMLCommonHandler.instance().getModForChannel(packet.a);
        if (mod != null) {
            mod.getNetworkHandler().onPacket250Packet(packet, player);
        }
    }

    private void handleClientRegistration(gl packet, ih player) {
        if (packet.c == null) {
            return;
        }
        try {
            for (String channel : new String(packet.c, "UTF8").split("\u0000")) {
                if (FMLCommonHandler.instance().getModForChannel(channel) == null) continue;
                if ("REGISTER".equals(packet.a)) {
                    FMLCommonHandler.instance().activateChannel(player, channel);
                    continue;
                }
                FMLCommonHandler.instance().deactivateChannel(player, channel);
            }
        }
        catch (UnsupportedEncodingException e) {
            this.getMinecraftLogger().warning("Received invalid registration packet");
        }
    }

    public void handleLogin(pk loginPacket, qq networkManager) {
        gl packet = new gl();
        packet.a = "REGISTER";
        packet.c = FMLCommonHandler.instance().getPacketRegistry();
        packet.b = packet.c.length;
        if (packet.b > 0) {
            networkManager.a((lx)packet);
        }
    }

    public void announceLogin(ih player) {
        for (ModContainer mod : Loader.getModList()) {
            if (!mod.wantsPlayerTracking()) continue;
            mod.getPlayerTracker().onPlayerLogin(player);
        }
    }

    @Override
    public File getMinecraftRootDirectory() {
        try {
            return this.server.a(".").getCanonicalFile();
        }
        catch (IOException ioe) {
            return new File(".");
        }
    }

    public boolean handleServerCommand(String command, String player, um listener) {
        for (ModContainer mod : Loader.getModList()) {
            if (!mod.wantsConsoleCommands() || !mod.getConsoleHandler().handleCommand(command, player, listener)) continue;
            return true;
        }
        return false;
    }

    public void announceLogout(ih player) {
        for (ModContainer mod : Loader.getModList()) {
            if (!mod.wantsPlayerTracking()) continue;
            mod.getPlayerTracker().onPlayerLogout(player);
        }
    }

    public void announceDimensionChange(ih player) {
        for (ModContainer mod : Loader.getModList()) {
            if (!mod.wantsPlayerTracking()) continue;
            mod.getPlayerTracker().onPlayerChangedDimension(player);
        }
    }

    public void addBiomeToDefaultWorldGenerator(lt biome) {
        ej.b.addNewBiome(biome);
    }

    public void removeBiomeFromDefaultWorldGenerator(lt biome) {
        ej.b.removeBiome(biome);
    }

    @Override
    public Object getMinecraftInstance() {
        return this.server;
    }

    @Override
    public String getCurrentLanguage() {
        return op.a().getCurrentLanguage();
    }

    @Override
    public Properties getCurrentLanguageTable() {
        return op.a().getCurrentLanguageTable();
    }

    @Override
    public String getObjectName(Object instance) {
        String objectName;
        if (instance instanceof id) {
            objectName = ((id)instance).b();
        } else if (instance instanceof vz) {
            objectName = ((vz)instance).q();
        } else if (instance instanceof kp) {
            objectName = id.d[((kp)instance).c].a((kp)instance);
        } else {
            throw new IllegalArgumentException(String.format("Illegal object for naming %s", instance));
        }
        objectName = objectName + ".name";
        return objectName;
    }

    @Override
    public ModMetadata readMetadataFrom(InputStream input, ModContainer mod) throws Exception {
        return null;
    }

    @Override
    public void profileStart(String profileLabel) {
        rj.a((String)profileLabel);
    }

    @Override
    public void profileEnd() {
        rj.a();
    }

    @Override
    public ModProperty getModLoaderPropertyFor(Field f2) {
        if (f2.isAnnotationPresent(MLProp.class)) {
            MLProp prop = f2.getAnnotation(MLProp.class);
            return new ModProperty(prop.info(), prop.min(), prop.max(), prop.name());
        }
        return null;
    }

    @Override
    public List<String> getAdditionalBrandingInformation() {
        return null;
    }

    @Override
    public Side getSide() {
        return Side.SERVER;
    }

    @Override
    public ProxyInjector findSidedProxyOn(cpw.mods.fml.common.modloader.BaseMod mod) {
        for (Field f2 : mod.getClass().getDeclaredFields()) {
            if (!f2.isAnnotationPresent(SidedProxy.class)) continue;
            SidedProxy sp = f2.getAnnotation(SidedProxy.class);
            return new ProxyInjector(sp.clientSide(), sp.serverSide(), sp.bukkitSide(), f2);
        }
        return null;
    }
}

