/*
 * Decompiled with CFR 0.152.
 */
package forge;

import forge.EntityTrackerInfo;
import forge.IArrowLooseHandler;
import forge.IArrowNockHandler;
import forge.IBonemealHandler;
import forge.IChatHandler;
import forge.IChunkLoadHandler;
import forge.IConnectionHandler;
import forge.ICraftingHandler;
import forge.IDestroyToolHandler;
import forge.IEntityInteractHandler;
import forge.IFuelHandler;
import forge.IGuiHandler;
import forge.IHoeHandler;
import forge.IMinecartHandler;
import forge.IPickupHandler;
import forge.ISaveEventHandler;
import forge.ISleepHandler;
import forge.ISpecialMobSpawnHandler;
import forge.MinecraftForge;
import forge.NetworkMod;
import forge.packets.PacketEntitySpawn;
import forge.packets.PacketHandlerBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class ForgeHooks {
    static LinkedList<ICraftingHandler> craftingHandlers = new LinkedList();
    static LinkedList<IDestroyToolHandler> destroyToolHandlers = new LinkedList();
    static LinkedList<IBonemealHandler> bonemealHandlers = new LinkedList();
    static LinkedList<IHoeHandler> hoeHandlers = new LinkedList();
    static LinkedList<ISleepHandler> sleepHandlers = new LinkedList();
    static LinkedList<IMinecartHandler> minecartHandlers = new LinkedList();
    static LinkedList<IConnectionHandler> connectionHandlers = new LinkedList();
    static LinkedList<IPickupHandler> pickupHandlers = new LinkedList();
    static LinkedList<IChunkLoadHandler> chunkLoadHandlers = new LinkedList();
    static LinkedList<IEntityInteractHandler> entityInteractHandlers = new LinkedList();
    static LinkedList<IChatHandler> chatHandlers = new LinkedList();
    static LinkedList<ISaveEventHandler> saveHandlers = new LinkedList();
    static LinkedList<IFuelHandler> fuelHandlers = new LinkedList();
    static LinkedList<ISpecialMobSpawnHandler> specialMobSpawnHandlers = new LinkedList();
    static List<ProbableItem> plantGrassList;
    static int plantGrassWeight;
    static List<ProbableItem> seedGrassList;
    static int seedGrassWeight;
    public static HashMap<Class, EntityTrackerInfo> entityTrackerMap;
    public static Hashtable<Integer, NetworkMod> networkMods;
    public static Hashtable<BaseMod, IGuiHandler> guiHandlers;
    public static ArrayList<IArrowLooseHandler> arrowLooseHandlers;
    public static ArrayList<IArrowNockHandler> arrowNockHandlers;
    public static final int majorVersion = 3;
    public static final int minorVersion = 2;
    public static final int revisionVersion = 6;
    public static final int buildVersion = 129;
    static boolean toolInit;
    static HashMap toolClasses;
    static HashMap toolHarvestLevels;
    static HashSet toolEffectiveness;
    private static PacketHandlerBase forgePacketHandler;

    public static void onTakenFromCrafting(ih player, kp stack, ni craftMatrix) {
        for (ICraftingHandler handler : craftingHandlers) {
            handler.onTakenFromCrafting(player, stack, craftMatrix);
        }
    }

    public static void onDestroyCurrentItem(ih player, kp orig) {
        for (IDestroyToolHandler handler : destroyToolHandlers) {
            handler.onDestroyCurrentItem(player, orig);
        }
    }

    public static boolean onUseBonemeal(ge world, int blockID, int x2, int y, int z) {
        for (IBonemealHandler handler : bonemealHandlers) {
            if (!handler.onUseBonemeal(world, blockID, x2, y, z)) continue;
            return true;
        }
        return false;
    }

    public static boolean onUseHoe(kp hoe, ih player, ge world, int x2, int y, int z) {
        for (IHoeHandler handler : hoeHandlers) {
            if (!handler.onUseHoe(hoe, player, world, x2, y, z)) continue;
            return true;
        }
        return false;
    }

    public static dv sleepInBedAt(ih player, int x2, int y, int z) {
        for (ISleepHandler handler : sleepHandlers) {
            dv status = handler.sleepInBedAt(player, x2, y, z);
            if (status == null) continue;
            return status;
        }
        return null;
    }

    public static void onMinecartUpdate(aaw minecart, int x2, int y, int z) {
        for (IMinecartHandler handler : minecartHandlers) {
            handler.onMinecartUpdate(minecart, x2, y, z);
        }
    }

    public static void onMinecartEntityCollision(aaw minecart, tv entity) {
        for (IMinecartHandler handler : minecartHandlers) {
            handler.onMinecartEntityCollision(minecart, entity);
        }
    }

    public static boolean onMinecartInteract(aaw minecart, ih player) {
        boolean canceled = true;
        for (IMinecartHandler handler : minecartHandlers) {
            boolean tmp = handler.onMinecartInteract(minecart, player, canceled);
            canceled = canceled && tmp;
        }
        return canceled;
    }

    public static void onConnect(qq network) {
        for (IConnectionHandler handler : connectionHandlers) {
            handler.onConnect(network);
        }
    }

    public static void onLogin(qq network, pk login) {
        for (IConnectionHandler handler : connectionHandlers) {
            handler.onLogin(network, login);
        }
    }

    public static void onDisconnect(qq network, String message, Object[] args) {
        for (IConnectionHandler handler : connectionHandlers) {
            handler.onDisconnect(network, message, args);
        }
    }

    public static boolean onItemPickup(ih player, ja item) {
        boolean cont = true;
        for (IPickupHandler handler : pickupHandlers) {
            boolean bl = cont = cont && handler.onItemPickup(player, item);
            if (cont && item.a.a > 0) continue;
            return false;
        }
        return cont;
    }

    public static void addActiveChunks(ge world, Set<abl> chunkList) {
        for (IChunkLoadHandler loader : chunkLoadHandlers) {
            loader.addActiveChunks(world, chunkList);
        }
    }

    public static boolean canUnloadChunk(my chunk) {
        for (IChunkLoadHandler loader : chunkLoadHandlers) {
            if (loader.canUnloadChunk(chunk)) continue;
            return false;
        }
        return true;
    }

    public static boolean canUpdateEntity(tv entity) {
        for (IChunkLoadHandler loader : chunkLoadHandlers) {
            if (!loader.canUpdateEntity(entity)) continue;
            return true;
        }
        return false;
    }

    public static boolean onEntityInteract(ih player, tv entity, boolean isAttack) {
        for (IEntityInteractHandler handler : entityInteractHandlers) {
            if (handler.onEntityInteract(player, entity, isAttack)) continue;
            return false;
        }
        return true;
    }

    public static String onServerChat(ih player, String message) {
        for (IChatHandler handler : chatHandlers) {
            message = handler.onServerChat(player, message);
            if (message != null) continue;
            return null;
        }
        return message;
    }

    public static boolean onChatCommand(ih player, boolean isOp, String command) {
        for (IChatHandler handler : chatHandlers) {
            if (!handler.onChatCommand(player, isOp, command)) continue;
            return true;
        }
        return false;
    }

    public static boolean onServerCommand(Object listener, String username, String command) {
        for (IChatHandler handler : chatHandlers) {
            if (!handler.onServerCommand(listener, username, command)) continue;
            return true;
        }
        return false;
    }

    public static String onServerCommandSay(Object listener, String username, String message) {
        for (IChatHandler handler : chatHandlers) {
            message = handler.onServerCommandSay(listener, username, message);
            if (message != null) continue;
            return null;
        }
        return message;
    }

    public static String onClientChatRecv(String message) {
        for (IChatHandler handler : chatHandlers) {
            message = handler.onClientChatRecv(message);
            if (message != null) continue;
            return null;
        }
        return message;
    }

    public static void onWorldLoad(ge world) {
        for (ISaveEventHandler handler : saveHandlers) {
            handler.onWorldLoad(world);
        }
    }

    public static void onWorldSave(ge world) {
        for (ISaveEventHandler handler : saveHandlers) {
            handler.onWorldSave(world);
        }
    }

    public static void onChunkLoad(ge world, my chunk) {
        for (ISaveEventHandler handler : saveHandlers) {
            handler.onChunkLoad(world, chunk);
        }
    }

    public static void onChunkUnload(ge world, my chunk) {
        for (ISaveEventHandler handler : saveHandlers) {
            handler.onChunkUnload(world, chunk);
        }
    }

    public static void onChunkLoadData(ge world, my chunk, ph data) {
        for (ISaveEventHandler handler : saveHandlers) {
            handler.onChunkLoadData(world, chunk, data);
        }
    }

    public static void onChunkSaveData(ge world, my chunk, ph data) {
        for (ISaveEventHandler handler : saveHandlers) {
            handler.onChunkSaveData(world, chunk, data);
        }
    }

    public static int getItemBurnTime(kp stack) {
        for (IFuelHandler handler : fuelHandlers) {
            int ret = handler.getItemBurnTime(stack);
            if (ret <= 0) continue;
            return ret;
        }
        return 0;
    }

    public static boolean onEntitySpawnSpecial(ne entity, ge world, float x2, float y, float z) {
        for (ISpecialMobSpawnHandler handler : specialMobSpawnHandlers) {
            if (!handler.onSpecialEntitySpawn(entity, world, x2, y, z)) continue;
            return true;
        }
        return false;
    }

    static ProbableItem getRandomItem(List<ProbableItem> list, int prop) {
        int n = Collections.binarySearch(list, prop, new Comparator(){

            public int compare(Object o1, Object o2) {
                ProbableItem pi = (ProbableItem)o1;
                Integer i1 = (Integer)o2;
                if (i1 < pi.WeightStart) {
                    return 1;
                }
                if (i1 >= pi.WeightEnd) {
                    return -1;
                }
                return 0;
            }
        });
        if (n < 0) {
            return null;
        }
        return list.get(n);
    }

    public static void plantGrassPlant(ge world, int x2, int y, int z) {
        int index = world.r.nextInt(plantGrassWeight);
        ProbableItem item = ForgeHooks.getRandomItem(plantGrassList, index);
        if (item == null) {
            return;
        }
        world.b(x2, y, z, item.ItemID, item.Metadata);
    }

    public static void addPlantGrass(int item, int metadata, int probability) {
        plantGrassList.add(new ProbableItem(item, metadata, 1, plantGrassWeight, plantGrassWeight + probability));
        plantGrassWeight += probability;
    }

    public static kp getGrassSeed(ge world) {
        int index = world.r.nextInt(seedGrassWeight);
        ProbableItem item = ForgeHooks.getRandomItem(seedGrassList, index);
        if (item == null) {
            return null;
        }
        return new kp(item.ItemID, item.Quantity, item.Metadata);
    }

    public static void addGrassSeed(int item, int metadata, int quantity, int probability) {
        seedGrassList.add(new ProbableItem(item, metadata, quantity, seedGrassWeight, seedGrassWeight + probability));
        seedGrassWeight += probability;
    }

    public static boolean canHarvestBlock(vz block, ih player, int metadata) {
        if (block.cd.k()) {
            return true;
        }
        kp stack = player.k.d();
        if (stack == null) {
            return player.b(block);
        }
        List info = (List)toolClasses.get(stack.c);
        if (info == null) {
            return player.b(block);
        }
        Object[] tmp = info.toArray();
        String toolClass = (String)tmp[0];
        int harvestLevel = (Integer)tmp[1];
        Integer blockHarvestLevel = (Integer)toolHarvestLevels.get(Arrays.asList(block.bO, metadata, toolClass));
        if (blockHarvestLevel == null) {
            return player.b(block);
        }
        return blockHarvestLevel <= harvestLevel;
    }

    public static float blockStrength(vz block, ih player, int metadata) {
        float hardness = block.getHardness(metadata);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (!ForgeHooks.canHarvestBlock(block, player, metadata)) {
            return 1.0f / hardness / 100.0f;
        }
        return player.getCurrentPlayerStrVsBlock(block, metadata) / hardness / 30.0f;
    }

    public static boolean isToolEffective(kp stack, vz block, int metadata) {
        List toolClass = (List)toolClasses.get(stack.c);
        if (toolClass == null) {
            return false;
        }
        return toolEffectiveness.contains(Arrays.asList(block.bO, metadata, (String)toolClass.get(0)));
    }

    static void initTools() {
        vz[] axeEff;
        vz[] spadeEff;
        vz[] pickeff;
        if (toolInit) {
            return;
        }
        toolInit = true;
        MinecraftForge.setToolClass(id.s, "pickaxe", 0);
        MinecraftForge.setToolClass(id.w, "pickaxe", 1);
        MinecraftForge.setToolClass(id.f, "pickaxe", 2);
        MinecraftForge.setToolClass(id.H, "pickaxe", 0);
        MinecraftForge.setToolClass(id.A, "pickaxe", 3);
        MinecraftForge.setToolClass(id.t, "axe", 0);
        MinecraftForge.setToolClass(id.x, "axe", 1);
        MinecraftForge.setToolClass(id.g, "axe", 2);
        MinecraftForge.setToolClass(id.I, "axe", 0);
        MinecraftForge.setToolClass(id.B, "axe", 3);
        MinecraftForge.setToolClass(id.r, "shovel", 0);
        MinecraftForge.setToolClass(id.v, "shovel", 1);
        MinecraftForge.setToolClass(id.e, "shovel", 2);
        MinecraftForge.setToolClass(id.G, "shovel", 0);
        MinecraftForge.setToolClass(id.z, "shovel", 3);
        MinecraftForge.setBlockHarvestLevel(vz.ap, "pickaxe", 3);
        MinecraftForge.setBlockHarvestLevel(vz.aw, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(vz.ax, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(vz.G, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(vz.ah, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(vz.H, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(vz.ai, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(vz.N, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(vz.O, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(vz.aN, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(vz.aO, "pickaxe", 2);
        MinecraftForge.removeBlockEffectiveness(vz.aN, "pickaxe");
        MinecraftForge.removeBlockEffectiveness(vz.ap, "pickaxe");
        MinecraftForge.removeBlockEffectiveness(vz.aO, "pickaxe");
        for (vz block : pickeff = new vz[]{vz.w, vz.aj, vz.ak, vz.t, vz.Q, vz.ao, vz.I, vz.aT, vz.bb, vz.N, vz.O}) {
            MinecraftForge.setBlockHarvestLevel(block, "pickaxe", 0);
        }
        for (vz block : spadeEff = new vz[]{vz.u, vz.v, vz.E, vz.F, vz.aS, vz.aU, vz.aW, vz.aA, vz.bc, vz.by}) {
            MinecraftForge.setBlockHarvestLevel(block, "shovel", 0);
        }
        for (vz block : axeEff = new vz[]{vz.x, vz.an, vz.J, vz.au, vz.aj, vz.ak, vz.ba, vz.bf}) {
            MinecraftForge.setBlockHarvestLevel(block, "axe", 0);
        }
    }

    public static lx getEntitySpawnPacket(tv entity) {
        EntityTrackerInfo info = MinecraftForge.getEntityTrackerInfo(entity, false);
        if (info == null) {
            return null;
        }
        PacketEntitySpawn pkt = new PacketEntitySpawn(entity, info.Mod, info.ID);
        return pkt.getPacket();
    }

    public static boolean onArrowLoose(kp itemstack, ge world, ih player, int heldTime) {
        for (IArrowLooseHandler handler : arrowLooseHandlers) {
            if (!handler.onArrowLoose(itemstack, world, player, heldTime)) continue;
            return true;
        }
        return false;
    }

    public static kp onArrowNock(kp itemstack, ge world, ih player) {
        for (IArrowNockHandler handler : arrowNockHandlers) {
            kp ret = handler.onArrowNock(itemstack, world, player);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public static int getMajorVersion() {
        return 3;
    }

    public static int getMinorVersion() {
        return 2;
    }

    public static int getRevisionVersion() {
        return 6;
    }

    public static int getBuildVersion() {
        return 129;
    }

    public static void setPacketHandler(PacketHandlerBase handler) {
        if (forgePacketHandler != null) {
            throw new RuntimeException("Attempted to set Forge's Internal packet handler after it was already set");
        }
        forgePacketHandler = handler;
    }

    public static PacketHandlerBase getPacketHandler() {
        return forgePacketHandler;
    }

    public static boolean onItemDataPacket(qq net, ao pkt) {
        NetworkMod mod = MinecraftForge.getModByID(pkt.a);
        if (mod == null) {
            ModLoader.getLogger().log(Level.WARNING, String.format("Received Unknown MapData packet %d:%d", pkt.a, pkt.b));
            return false;
        }
        mod.onPacketData(net, pkt.b, pkt.c);
        return true;
    }

    static {
        entityTrackerMap = new HashMap();
        networkMods = new Hashtable();
        guiHandlers = new Hashtable();
        arrowLooseHandlers = new ArrayList();
        arrowNockHandlers = new ArrayList();
        plantGrassList = new ArrayList<ProbableItem>();
        plantGrassList.add(new ProbableItem(vz.ad.bO, 0, 1, 0, 20));
        plantGrassList.add(new ProbableItem(vz.ae.bO, 0, 1, 20, 30));
        plantGrassWeight = 30;
        seedGrassList = new ArrayList<ProbableItem>();
        seedGrassList.add(new ProbableItem(id.R.bP, 0, 1, 0, 10));
        seedGrassWeight = 10;
        System.out.printf("MinecraftForge v%d.%d.%d.%d Initialized\n", 3, 2, 6, 129);
        ModLoader.getLogger().info(String.format("MinecraftForge v%d.%d.%d.%d Initialized", 3, 2, 6, 129));
        toolInit = false;
        toolClasses = new HashMap();
        toolHarvestLevels = new HashMap();
        toolEffectiveness = new HashSet();
        forgePacketHandler = null;
    }

    static class ProbableItem {
        int WeightStart;
        int WeightEnd;
        int ItemID;
        int Metadata;
        int Quantity;

        public ProbableItem(int item, int metadata, int quantity, int start, int end) {
            this.WeightStart = start;
            this.WeightEnd = end;
            this.ItemID = item;
            this.Metadata = metadata;
            this.Quantity = quantity;
        }
    }
}

