/*
 * Decompiled with CFR 0.152.
 */
package forge;

import forge.ForgeHooks;
import forge.IPacketHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;

public class MessageManager {
    private Hashtable<qq, ConnectionInstance> connections = new Hashtable();
    private static MessageManager instance;

    public static MessageManager getInstance() {
        if (instance == null) {
            instance = new MessageManager();
        }
        return instance;
    }

    public ConnectionInstance getConnection(qq manager) {
        ConnectionInstance ret = this.connections.get(manager);
        if (ret == null) {
            ret = new ConnectionInstance(manager);
            this.connections.put(manager, ret);
        }
        return ret;
    }

    public String[] removeConnection(qq manager) {
        if (this.connections.containsKey(manager)) {
            ConnectionInstance con = this.getConnection(manager);
            String[] ret = con.unregisterAll();
            this.connections.remove(manager);
            return ret;
        }
        return new String[0];
    }

    public boolean registerChannel(qq manager, IPacketHandler handler, String channel) {
        ConnectionInstance con = this.getConnection(manager);
        return con.registerChannel(handler, channel);
    }

    public boolean unregisterChannel(qq manager, IPacketHandler handler, String channel) {
        if (this.connections.containsKey(manager)) {
            ConnectionInstance con = this.getConnection(manager);
            return con.unregisterChannel(handler, channel);
        }
        return false;
    }

    public String[] unregisterHandler(qq manager, IPacketHandler handler) {
        if (this.connections.containsKey(manager)) {
            ConnectionInstance con = this.getConnection(manager);
            return con.unregisterHandler(handler);
        }
        return new String[0];
    }

    public String[] getRegisteredChannels(qq manager) {
        if (this.connections.containsKey(manager)) {
            ConnectionInstance con = this.getConnection(manager);
            return con.getRegisteredChannels();
        }
        return new String[0];
    }

    public IPacketHandler[] getChannelHandlers(qq manager, String channel) {
        if (this.connections.containsKey(manager)) {
            ConnectionInstance con = this.getConnection(manager);
            return con.getChannelHandlers(channel);
        }
        return new IPacketHandler[0];
    }

    public void addActiveChannel(qq manager, String channel) {
        ConnectionInstance con = this.getConnection(manager);
        con.addActiveChannel(channel);
    }

    public void removeActiveChannel(qq manager, String channel) {
        if (this.connections.containsKey(manager)) {
            ConnectionInstance con = this.getConnection(manager);
            con.removeActiveChannel(channel);
        }
    }

    public boolean isActiveChannel(qq manager, String channel) {
        if (this.connections.containsKey(manager)) {
            ConnectionInstance con = this.getConnection(manager);
            return con.isActiveChannel(channel);
        }
        return false;
    }

    public void dispatchIncomingMessage(qq manager, String channel, byte[] data) {
        if (data == null) {
            data = new byte[]{};
        }
        if (channel.equals("Forge") && ForgeHooks.getPacketHandler() != null) {
            byte[] tmpData = new byte[data.length];
            System.arraycopy(data, 0, tmpData, 0, data.length);
            ForgeHooks.getPacketHandler().onPacketData(manager, channel, tmpData);
        }
        if (this.connections.containsKey(manager)) {
            ConnectionInstance con = this.getConnection(manager);
            IPacketHandler[] handlers = con.getChannelHandlers(channel);
            byte[] tmpData = new byte[data.length];
            for (IPacketHandler handler : handlers) {
                System.arraycopy(data, 0, tmpData, 0, data.length);
                handler.onPacketData(manager, channel, tmpData);
            }
        }
    }

    public class ConnectionInstance {
        private qq network;
        private Hashtable<String, ArrayList<IPacketHandler>> channelToHandlers = new Hashtable();
        private Hashtable<IPacketHandler, ArrayList<String>> handlerToChannels = new Hashtable();
        private HashSet<String> activeChannels = new HashSet();

        public ConnectionInstance(qq mgr) {
            this.network = mgr;
        }

        public qq getNetwork() {
            return this.network;
        }

        public String[] unregisterAll() {
            String[] ret = this.getRegisteredChannels();
            this.channelToHandlers.clear();
            this.handlerToChannels.clear();
            return ret;
        }

        public boolean registerChannel(IPacketHandler handler, String channel) {
            ArrayList<IPacketHandler> handlers = this.channelToHandlers.get(channel);
            ArrayList<String> channels = this.handlerToChannels.get(handler);
            boolean ret = false;
            if (handlers == null) {
                ret = true;
                handlers = new ArrayList();
                this.channelToHandlers.put(channel, handlers);
            }
            if (channels == null) {
                channels = new ArrayList();
                this.handlerToChannels.put(handler, channels);
            }
            if (!channels.contains(channel)) {
                channels.add(channel);
            }
            if (!handlers.contains(handler)) {
                handlers.add(handler);
            }
            return ret;
        }

        public boolean unregisterChannel(IPacketHandler handler, String channel) {
            boolean ret = false;
            ArrayList<IPacketHandler> handlers = this.channelToHandlers.get(channel);
            ArrayList<String> channels = this.handlerToChannels.get(handler);
            if (handlers != null && handlers.contains(handler)) {
                handlers.remove(handler);
                if (handlers.size() == 0) {
                    ret = true;
                    this.channelToHandlers.remove(channel);
                }
            }
            if (channels != null && channels.contains(channel)) {
                channels.remove(channel);
                if (handlers.size() == 0) {
                    this.handlerToChannels.remove(handler);
                }
            }
            return ret;
        }

        public String[] unregisterHandler(IPacketHandler handler) {
            ArrayList<String> tmp = this.handlerToChannels.get(handler);
            if (tmp != null) {
                String[] channels = tmp.toArray(new String[0]);
                tmp = new ArrayList();
                for (String channel : channels) {
                    if (!this.unregisterChannel(handler, channel)) continue;
                    tmp.add(channel);
                }
                return tmp.toArray(new String[0]);
            }
            return new String[0];
        }

        public String[] getRegisteredChannels() {
            int x2 = 0;
            String[] ret = new String[this.channelToHandlers.size()];
            for (String value : this.channelToHandlers.keySet()) {
                ret[x2++] = value;
            }
            return ret;
        }

        public IPacketHandler[] getChannelHandlers(String channel) {
            ArrayList<IPacketHandler> handlers = this.channelToHandlers.get(channel);
            if (handlers != null) {
                return handlers.toArray(new IPacketHandler[0]);
            }
            return new IPacketHandler[0];
        }

        public void addActiveChannel(String channel) {
            if (!this.activeChannels.contains(channel)) {
                this.activeChannels.add(channel);
            }
        }

        public void removeActiveChannel(String channel) {
            if (this.activeChannels.contains(channel)) {
                this.activeChannels.remove(channel);
            }
        }

        public boolean isActiveChannel(String channel) {
            return this.activeChannels.contains(channel);
        }
    }
}

