/*
 * Decompiled with CFR 0.152.
 */
package forge;

import cpw.mods.fml.server.FMLServerHandler;
import forge.MinecraftForge;
import forge.NetworkMod;
import forge.packets.ForgePacket;
import forge.packets.PacketHandlerBase;
import forge.packets.PacketMissingMods;
import forge.packets.PacketModList;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;

public class PacketHandlerServer
extends PacketHandlerBase {
    @Override
    public void onPacketData(qq network, String channel, byte[] bytes) {
        mm net = (mm)network.getNetHandler();
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(bytes));
        PacketModList pkt = null;
        try {
            int packetID = data.read();
            switch (packetID) {
                case 2: {
                    pkt = new PacketModList(true);
                    ((ForgePacket)pkt).readData(data);
                    this.onModListResponse(net, pkt);
                }
            }
        }
        catch (IOException e) {
            ModLoader.getLogger().log(Level.SEVERE, "Exception in PacketHandlerServer.onPacketData", e);
            e.printStackTrace();
        }
    }

    private void onModListResponse(mm net, PacketModList pkt) throws IOException {
        if (DEBUG) {
            System.out.println("C->S: " + pkt.toString(true));
        }
        if (pkt.Length < 0) {
            net.a("Invalid mod list response, Size: " + pkt.Length);
            return;
        }
        if (pkt.Mods.length == 0) {
            ModLoader.getLogger().log(Level.INFO, net.d() + " joined with no mods");
        } else {
            ModLoader.getLogger().log(Level.INFO, net.d() + " joined with: " + Arrays.toString(pkt.Mods).replaceAll("mod_", ""));
        }
        NetworkMod[] serverMods = MinecraftForge.getNetworkMods();
        ArrayList<NetworkMod> missing = new ArrayList<NetworkMod>();
        for (NetworkMod mod : serverMods) {
            if (!mod.clientSideRequired()) continue;
            boolean found = false;
            for (String modName : pkt.Mods) {
                if (!modName.equals(mod.toString())) continue;
                found = true;
                break;
            }
            if (found) continue;
            missing.add(mod);
        }
        if (missing.size() > 0) {
            this.doMissingMods(net, missing);
        } else {
            this.finishLogin(net);
        }
    }

    private void doMissingMods(mm net, ArrayList<NetworkMod> list) {
        PacketMissingMods pkt = new PacketMissingMods(true);
        pkt.Mods = new String[list.size()];
        int x2 = 0;
        for (NetworkMod mod : list) {
            pkt.Mods[x2++] = mod.toString();
        }
        if (DEBUG) {
            System.out.println("S->C: " + pkt.toString(true));
        }
        net.b(pkt.getPacket());
        this.disconnectUser(net);
    }

    private void disconnectUser(mm net) {
        MinecraftServer mc2 = ModLoader.getMinecraftServerInstance();
        net.getPlayerEntity().I();
        net.b.d();
        mc2.h.a((lx)new qr("\u00a7e" + net.d() + " left the game."));
        mc2.h.e(net.getPlayerEntity());
        net.c = true;
    }

    private void finishLogin(mm net) {
        gi player = net.getPlayerEntity();
        gp world = net.d.a(player.w);
        cf spawn = world.p();
        net.b((lx)new pk("", player.bd, world.s().p(), player.c.a(), world.t.g, (byte)world.q, (byte)world.y(), (byte)net.d.h.k()));
        net.b((lx)new sg(spawn.a, spawn.b, spawn.c));
        net.b((lx)new hz(player.L));
        net.d.h.a(player, world);
        net.d.h.a((lx)new qr("\u00a7e" + player.v + " joined the game."));
        net.d.h.c(player);
        net.a(player.bm, player.bn, player.bo, player.bs, player.bt);
        net.b((lx)new iw(world.o()));
        for (Object efx : player.aM()) {
            net.b((lx)new es(player.bd, (zv)efx));
        }
        player.x();
        FMLServerHandler.instance().announceLogin(player);
    }

    @Override
    public void sendPacket(qq network, lx packet) {
        mm net = (mm)network.getNetHandler();
        net.b(packet);
    }
}

