/*
 * Decompiled with CFR 0.152.
 */
package forge.packets;

import forge.ISpawnHandler;
import forge.IThrowableEntity;
import forge.MinecraftForge;
import forge.NetworkMod;
import forge.packets.ForgePacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PacketEntitySpawn
extends ForgePacket {
    public int modID;
    public int entityID;
    public int typeID;
    public int posX;
    public int posY;
    public int posZ;
    public byte yaw;
    public byte pitch;
    public byte yawHead;
    public int throwerID;
    public int speedX;
    public int speedY;
    public int speedZ;
    public Object metadata;
    private ISpawnHandler handler;

    public PacketEntitySpawn() {
    }

    public PacketEntitySpawn(tv ent, NetworkMod mod, int type) {
        this.entityID = ent.bd;
        this.posX = kb.b((double)(ent.bm * 32.0));
        this.posY = kb.b((double)(ent.bn * 32.0));
        this.posZ = kb.b((double)(ent.bo * 32.0));
        this.typeID = type;
        this.modID = MinecraftForge.getModID(mod);
        this.yaw = (byte)(ent.bs * 256.0f / 360.0f);
        this.pitch = (byte)(ent.bt * 256.0f / 360.0f);
        this.yawHead = (byte)(ent instanceof ne ? ((ne)ent).X * 256.0f / 360.0f : 0.0f);
        this.metadata = ent.aP();
        if (ent instanceof IThrowableEntity) {
            tv owner = ((IThrowableEntity)((Object)ent)).getThrower();
            this.throwerID = owner == null ? ent.bd : owner.bd;
            double maxVel = 3.9;
            double mX = ent.bp;
            double mY = ent.bq;
            double mZ = ent.br;
            if (mX < -maxVel) {
                mX = -maxVel;
            }
            if (mY < -maxVel) {
                mY = -maxVel;
            }
            if (mZ < -maxVel) {
                mZ = -maxVel;
            }
            if (mX > maxVel) {
                mX = maxVel;
            }
            if (mY > maxVel) {
                mY = maxVel;
            }
            if (mZ > maxVel) {
                mZ = maxVel;
            }
            this.speedX = (int)(mX * 8000.0);
            this.speedY = (int)(mY * 8000.0);
            this.speedZ = (int)(mZ * 8000.0);
        }
        if (ent instanceof ISpawnHandler) {
            this.handler = (ISpawnHandler)((Object)ent);
        }
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeInt(this.modID);
        data.writeInt(this.entityID);
        data.writeByte(this.typeID & 0xFF);
        data.writeInt(this.posX);
        data.writeInt(this.posY);
        data.writeInt(this.posZ);
        data.writeByte(this.yaw);
        data.writeByte(this.pitch);
        data.writeByte(this.yawHead);
        ((vh)this.metadata).a(data);
        data.writeInt(this.throwerID);
        if (this.throwerID != 0) {
            data.writeShort(this.speedX);
            data.writeShort(this.speedY);
            data.writeShort(this.speedZ);
        }
        if (this.handler != null) {
            this.handler.writeSpawnData(data);
        }
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        this.modID = data.readInt();
        this.entityID = data.readInt();
        this.typeID = data.readByte() & 0xFF;
        this.posX = data.readInt();
        this.posY = data.readInt();
        this.posZ = data.readInt();
        this.yaw = data.readByte();
        this.pitch = data.readByte();
        this.yawHead = data.readByte();
        this.metadata = vh.a((DataInputStream)data);
        this.throwerID = data.readInt();
        if (this.throwerID != 0) {
            this.speedX = data.readShort();
            this.speedY = data.readShort();
            this.speedZ = data.readShort();
        }
    }

    @Override
    public int getID() {
        return 1;
    }
}

